/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-09-30 10:04:24 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2574 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=29596 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=7692 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_crocoblock_workflows` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `remote_id` mediumint(8) DEFAULT NULL,
  `namespace` text DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `steps` longtext DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jet_cct_customers_comments` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `customer_name` text DEFAULT NULL,
  `customer_opinion` longtext DEFAULT NULL,
  `scoring` bigint(20) DEFAULT NULL,
  `customer_image` bigint(20) DEFAULT NULL,
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_created` timestamp NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_jet_search_suggestions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text DEFAULT NULL,
  `weight` bigint(20) DEFAULT NULL,
  `parent` text DEFAULT NULL,
  `term` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_search_suggestions_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_smart_filters_indexer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `item_id` int(10) unsigned DEFAULT NULL,
  `item_query` varchar(50) DEFAULT NULL,
  `item_key` varchar(50) DEFAULT NULL,
  `item_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=942 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=71219 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=168623 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=16667 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_snippets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` tinytext NOT NULL,
  `description` text NOT NULL,
  `code` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `scope` varchar(15) NOT NULL DEFAULT 'global',
  `priority` smallint(6) NOT NULL DEFAULT 10,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT current_timestamp(),
  `revision` bigint(20) NOT NULL DEFAULT 1,
  `cloud_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=480 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3786 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=480 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1825 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19061 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=612 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=418 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("461", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2022-11-13 05:28:32", "2022-11-13 08:58:32", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1668317312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1668317312;}", "3", "1", "2022-11-13 05:29:10", "2022-11-13 08:59:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("624", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-04-26 06:10:18", "2023-04-26 09:40:18", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682489418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682489418;}", "3", "1", "2023-04-26 06:10:24", "2023-04-26 09:40:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("642", "rocket_preload_job_check_finished", "failed", "2023-04-26 07:02:43", "2023-04-26 10:32:43", "[1682492503]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682492563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682492563;}", "6", "1", "2023-04-26 07:02:53", "2023-04-26 10:32:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("979", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-11 05:43:48", "2023-05-11 09:13:48", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683783828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683783828;}", "3", "1", "2023-05-11 05:43:49", "2023-05-11 09:13:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1162", "rocket_preload_job_check_finished", "failed", "2023-07-13 07:39:24", "2023-07-13 11:09:24", "[1689233904]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1689233964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1689233964;}", "6", "1", "2023-07-13 07:39:41", "2023-07-13 11:09:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1083", "action_scheduler/migration_hook", "failed", "2023-06-14 08:16:54", "2023-06-14 11:46:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686730614;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686730614;}", "1", "1", "2023-06-14 08:17:05", "2023-06-14 11:47:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1175", "action_scheduler/migration_hook", "failed", "2023-07-13 07:41:44", "2023-07-13 11:11:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1689234104;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1689234104;}", "1", "1", "2023-07-13 07:41:48", "2023-07-13 11:11:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1201", "action_scheduler/migration_hook", "failed", "2023-07-23 06:18:07", "2023-07-23 09:48:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1690093087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1690093087;}", "1", "1", "2023-07-23 06:19:07", "2023-07-23 09:49:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1212", "action_scheduler/migration_hook", "failed", "2023-08-02 09:03:42", "2023-08-02 12:33:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1690967022;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1690967022;}", "1", "1", "2023-08-02 09:03:43", "2023-08-02 12:33:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1230", "action_scheduler/migration_hook", "failed", "2023-08-06 07:12:10", "2023-08-06 10:42:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1691305930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1691305930;}", "1", "1", "2023-08-06 07:12:13", "2023-08-06 10:42:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1940", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 09:54:24", "2024-09-08 13:24:24", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725789264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725789264;}", "4", "1", "2024-09-08 09:54:30", "2024-09-08 13:24:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1931", "action_scheduler/migration_hook", "complete", "2024-09-02 05:03:58", "2024-09-02 08:33:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725253438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725253438;}", "1", "1", "2024-09-02 05:03:59", "2024-09-02 08:33:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1932", "action_scheduler/migration_hook", "failed", "2024-09-02 05:04:59", "2024-09-02 08:34:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725253499;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725253499;}", "1", "1", "2024-09-02 05:05:05", "2024-09-02 08:35:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1933", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-02 10:13:00", "2024-09-02 13:43:00", "[10282,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725271980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725271980;}", "4", "1", "2024-09-02 10:13:32", "2024-09-02 13:43:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2297", "woocommerce_cleanup_draft_orders", "complete", "2024-09-19 11:08:47", "2024-09-19 14:38:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726744127;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726744127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-19 11:08:58", "2024-09-19 14:38:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2232", "woocommerce_cleanup_draft_orders", "complete", "2024-09-13 11:04:39", "2024-09-13 14:34:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726225479;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726225479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-13 11:06:28", "2024-09-13 14:36:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1319", "action_scheduler/migration_hook", "failed", "2024-05-30 12:41:06", "2024-05-30 16:11:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1717072866;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1717072866;}", "1", "1", "2024-05-30 12:41:08", "2024-05-30 16:11:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2301", "woocommerce_cleanup_draft_orders", "complete", "2024-09-24 05:16:09", "2024-09-24 08:46:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727154969;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727154969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-24 11:25:05", "2024-09-24 14:55:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2303", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:53:24", "2024-09-25 12:23:24", "[15506,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254404;}", "4", "1", "2024-09-25 08:53:28", "2024-09-25 12:23:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2304", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:53:42", "2024-09-25 12:23:42", "[15507,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254422;}", "4", "1", "2024-09-25 08:53:58", "2024-09-25 12:23:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2305", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:54:05", "2024-09-25 12:24:05", "[15506,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254445;}", "4", "1", "2024-09-25 08:54:33", "2024-09-25 12:24:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2306", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:54:05", "2024-09-25 12:24:05", "[15507,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254445;}", "4", "1", "2024-09-25 08:54:33", "2024-09-25 12:24:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2307", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:54:08", "2024-09-25 12:24:08", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254448;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254448;}", "4", "1", "2024-09-25 08:54:33", "2024-09-25 12:24:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2308", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:55:04", "2024-09-25 12:25:04", "[15507,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254504;}", "4", "1", "2024-09-25 08:55:41", "2024-09-25 12:25:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2069", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9772,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2571", "woocommerce_cleanup_draft_orders", "pending", "2024-10-01 05:18:35", "2024-10-01 08:48:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727759915;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727759915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2300", "woocommerce_cleanup_draft_orders", "complete", "2024-09-22 15:51:15", "2024-09-22 19:21:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727020275;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727020275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-23 05:16:09", "2024-09-23 08:46:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2067", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9779,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2068", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9777,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2302", "woocommerce_cleanup_draft_orders", "complete", "2024-09-25 11:25:05", "2024-09-25 14:55:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727263505;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727263505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-25 11:25:17", "2024-09-25 14:55:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2056", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9846,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2057", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9841,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2058", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9840,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2059", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9828,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2060", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9829,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2061", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9827,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2062", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9783,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2063", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9784,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2064", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9785,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2065", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9782,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2066", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9778,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2029", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9954,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2030", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9953,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2031", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9942,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2032", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9941,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2033", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9936,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2034", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9935,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2035", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9930,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2036", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9929,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2037", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9905,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2038", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9904,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2039", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9899,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2040", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9898,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2041", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9892,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2042", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9893,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2043", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9891,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2044", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9886,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2045", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9885,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2046", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9884,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2047", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9871,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2048", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9872,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2049", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:48", "2024-09-10 15:51:48", "[9870,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970908;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970908;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2050", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9865,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2051", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9864,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2052", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9860,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2053", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9861,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2054", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9859,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2055", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:49", "2024-09-10 15:51:49", "[9847,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970909;}", "4", "1", "2024-09-10 12:22:10", "2024-09-10 15:52:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2028", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9971,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2020", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10007,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2021", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10002,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2022", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10001,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2023", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9996,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2024", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9995,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2025", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9990,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2026", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9989,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2027", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[9972,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2010", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10049,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2011", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10044,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2012", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10043,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2013", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10026,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2014", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10025,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2015", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10020,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2016", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10019,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2017", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10014,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2018", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10013,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2019", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:47", "2024-09-10 15:51:47", "[10008,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970907;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1929", "woocommerce_cleanup_draft_orders", "complete", "2024-09-01 09:21:03", "2024-09-01 12:51:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725182463;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725182463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-02 04:33:50", "2024-09-02 08:03:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1928", "woocommerce_cleanup_draft_orders", "complete", "2024-08-30 15:23:55", "2024-08-30 18:53:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725031435;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725031435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-08-31 09:21:03", "2024-08-31 12:51:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1999", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10076,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2000", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10075,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2001", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10068,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2002", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10069,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2003", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10070,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2004", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10067,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2005", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10062,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2006", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10061,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2007", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10056,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2008", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10055,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2009", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10050,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1960", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10438,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1961", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10413,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1962", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10414,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1963", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10412,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1964", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10407,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1965", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10406,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1966", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10401,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1967", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10400,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1968", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10394,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1969", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10395,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1970", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10393,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1971", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10387,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1972", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10388,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1973", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10386,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1974", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:44", "2024-09-10 15:51:44", "[10381,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970904;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1975", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10380,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1976", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10375,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1977", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10374,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1978", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10369,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1979", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10368,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1980", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10363,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1981", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10362,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1982", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10357,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1983", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10356,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1984", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10351,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1985", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10350,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1986", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10345,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1987", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10344,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1988", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10339,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1989", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10338,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1990", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10332,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1991", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10333,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1992", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10331,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1993", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10325,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1994", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:45", "2024-09-10 15:51:45", "[10326,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970905;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1995", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10324,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1996", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10318,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1997", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10319,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1998", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:46", "2024-09-10 15:51:46", "[10317,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970906;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970906;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1942", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:06:40", "2024-09-08 13:36:40", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725790000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725790000;}", "4", "1", "2024-09-08 10:06:58", "2024-09-08 13:36:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1943", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:22:18", "2024-09-08 13:52:18", "[10414,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725790938;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725790938;}", "4", "1", "2024-09-08 10:22:22", "2024-09-08 13:52:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1944", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:22:18", "2024-09-08 13:52:18", "[10413,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725790938;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725790938;}", "4", "1", "2024-09-08 10:22:22", "2024-09-08 13:52:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1945", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:22:21", "2024-09-08 13:52:21", "[10412,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725790941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725790941;}", "4", "1", "2024-09-08 10:22:22", "2024-09-08 13:52:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1946", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:51:05", "2024-09-08 14:21:05", "[10401,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725792665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725792665;}", "4", "1", "2024-09-08 10:51:17", "2024-09-08 14:21:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1947", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:51:06", "2024-09-08 14:21:06", "[10400,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725792666;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725792666;}", "4", "1", "2024-09-08 10:51:17", "2024-09-08 14:21:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1948", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:51:54", "2024-09-08 14:21:54", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725792714;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725792714;}", "4", "1", "2024-09-08 10:52:19", "2024-09-08 14:22:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1949", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:52:15", "2024-09-08 14:22:15", "[10375,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725792735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725792735;}", "4", "1", "2024-09-08 10:52:19", "2024-09-08 14:22:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1950", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:52:18", "2024-09-08 14:22:18", "[10374,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725792738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725792738;}", "4", "1", "2024-09-08 10:52:19", "2024-09-08 14:22:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1951", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:52:30", "2024-09-08 14:22:30", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725792750;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725792750;}", "4", "1", "2024-09-08 10:52:31", "2024-09-08 14:22:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1952", "woocommerce_cleanup_draft_orders", "complete", "2024-09-10 09:01:48", "2024-09-10 12:31:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725958908;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725958908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-10 09:02:39", "2024-09-10 12:32:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1953", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-09 10:37:57", "2024-09-09 14:07:57", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725878277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725878277;}", "4", "1", "2024-09-09 10:38:41", "2024-09-09 14:08:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1955", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-09-10 10:51:40", "2024-09-10 14:21:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725965500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725965500;}", "3", "1", "2024-09-10 10:51:41", "2024-09-10 14:21:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1956", "woocommerce_run_update_callback", "complete", "2024-09-10 11:02:29", "2024-09-10 14:32:29", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725966149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725966149;}", "4", "1", "2024-09-10 11:02:29", "2024-09-10 14:32:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1957", "woocommerce_update_db_to_current_version", "complete", "2024-09-10 11:02:30", "2024-09-10 14:32:30", "{\"version\":\"9.2.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725966150;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725966150;}", "4", "1", "2024-09-10 11:03:04", "2024-09-10 14:33:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1958", "action_scheduler/migration_hook", "complete", "2024-09-10 11:07:34", "2024-09-10 14:37:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725966454;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725966454;}", "1", "1", "2024-09-10 11:08:30", "2024-09-10 14:38:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1959", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:21:43", "2024-09-10 15:51:43", "[10439,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970903;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970903;}", "4", "1", "2024-09-10 12:22:09", "2024-09-10 15:52:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1941", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-08 10:05:47", "2024-09-08 13:35:47", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725789947;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725789947;}", "4", "1", "2024-09-08 10:05:50", "2024-09-08 13:35:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1939", "woocommerce_cleanup_draft_orders", "complete", "2024-09-08 15:18:59", "2024-09-08 18:48:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725808739;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725808739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-09 09:01:48", "2024-09-09 12:31:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1938", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-02 10:20:04", "2024-09-02 13:50:04", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725272404;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725272404;}", "4", "1", "2024-09-02 10:20:34", "2024-09-02 13:50:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1937", "action_scheduler/migration_hook", "complete", "2024-09-02 10:20:47", "2024-09-02 13:50:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725272447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725272447;}", "1", "1", "2024-09-02 10:20:58", "2024-09-02 13:50:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1511", "action_scheduler/migration_hook", "failed", "2024-07-31 11:50:40", "2024-07-31 15:20:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1722426640;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1722426640;}", "1", "1", "2024-07-31 11:51:41", "2024-07-31 15:21:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1936", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-02 10:19:08", "2024-09-02 13:49:08", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725272348;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725272348;}", "4", "1", "2024-09-02 10:19:32", "2024-09-02 13:49:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1930", "woocommerce_cleanup_draft_orders", "complete", "2024-09-03 04:33:50", "2024-09-03 08:03:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1725338030;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1725338030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-07 15:18:59", "2024-09-07 18:48:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1935", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-02 10:13:34", "2024-09-02 13:43:34", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725272014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725272014;}", "4", "1", "2024-09-02 10:14:29", "2024-09-02 13:44:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1934", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-02 10:13:00", "2024-09-02 13:43:00", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725271980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725271980;}", "4", "1", "2024-09-02 10:13:32", "2024-09-02 13:43:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1954", "woocommerce_cleanup_draft_orders", "complete", "2024-09-11 09:02:39", "2024-09-11 12:32:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726045359;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726045359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-11 10:18:20", "2024-09-11 13:48:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2568", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-29 10:02:32", "2024-09-29 13:32:32", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727604152;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727604152;}", "4", "1", "2024-09-29 10:02:55", "2024-09-29 13:32:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2567", "woocommerce_cleanup_draft_orders", "complete", "2024-09-30 05:18:19", "2024-09-30 08:48:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727673499;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727673499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-30 05:18:35", "2024-09-30 08:48:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2566", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 12:18:29", "2024-09-28 15:48:29", "[9817,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525909;}", "4", "1", "2024-09-28 12:18:40", "2024-09-28 15:48:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2565", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 12:17:39", "2024-09-28 15:47:39", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525859;}", "4", "1", "2024-09-28 12:18:03", "2024-09-28 15:48:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2564", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 12:15:22", "2024-09-28 15:45:22", "[9817,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525722;}", "4", "1", "2024-09-28 12:15:32", "2024-09-28 15:45:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2563", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 12:15:22", "2024-09-28 15:45:22", "[16317,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525722;}", "4", "1", "2024-09-28 12:15:32", "2024-09-28 15:45:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2562", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 12:13:37", "2024-09-28 15:43:37", "[9817,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525617;}", "4", "1", "2024-09-28 12:14:02", "2024-09-28 15:44:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2561", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 12:13:28", "2024-09-28 15:43:28", "[16317,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525608;}", "4", "1", "2024-09-28 12:14:02", "2024-09-28 15:44:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2560", "action_scheduler/migration_hook", "failed", "2024-09-28 12:10:59", "2024-09-28 15:40:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525459;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525459;}", "1", "1", "2024-09-28 12:11:08", "2024-09-28 15:41:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2559", "action_scheduler/migration_hook", "complete", "2024-09-28 12:09:52", "2024-09-28 15:39:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727525392;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727525392;}", "1", "1", "2024-09-28 12:09:59", "2024-09-28 15:39:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2558", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:46:30", "2024-09-28 15:16:30", "[9977,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523990;}", "4", "1", "2024-09-28 11:47:01", "2024-09-28 15:17:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2557", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:44:00", "2024-09-28 15:14:00", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523840;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523840;}", "4", "1", "2024-09-28 11:44:05", "2024-09-28 15:14:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2556", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:42:06", "2024-09-28 15:12:06", "[10111,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523726;}", "4", "1", "2024-09-28 11:42:58", "2024-09-28 15:12:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2555", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:41:58", "2024-09-28 15:11:58", "[10111,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523718;}", "4", "1", "2024-09-28 11:41:58", "2024-09-28 15:11:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2554", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:40:08", "2024-09-28 15:10:08", "[10144,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523608;}", "4", "1", "2024-09-28 11:40:57", "2024-09-28 15:10:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2553", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:37:02", "2024-09-28 15:07:02", "[10165,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523422;}", "4", "1", "2024-09-28 11:37:43", "2024-09-28 15:07:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2552", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:37:01", "2024-09-28 15:07:01", "[10166,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523421;}", "4", "1", "2024-09-28 11:37:01", "2024-09-28 15:07:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2551", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:36:39", "2024-09-28 15:06:39", "[10165,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523399;}", "4", "1", "2024-09-28 11:37:01", "2024-09-28 15:07:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2550", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:34:31", "2024-09-28 15:04:31", "[10183,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523271;}", "4", "1", "2024-09-28 11:34:31", "2024-09-28 15:04:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2549", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:34:19", "2024-09-28 15:04:19", "[16296,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523259;}", "4", "1", "2024-09-28 11:34:31", "2024-09-28 15:04:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2548", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:34:19", "2024-09-28 15:04:19", "[10184,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523259;}", "4", "1", "2024-09-28 11:34:31", "2024-09-28 15:04:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2547", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:33:51", "2024-09-28 15:03:51", "[10183,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523231;}", "4", "1", "2024-09-28 11:34:00", "2024-09-28 15:04:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2546", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:31:40", "2024-09-28 15:01:40", "[10213,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523100;}", "4", "1", "2024-09-28 11:32:00", "2024-09-28 15:02:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2545", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:30:26", "2024-09-28 15:00:26", "[10270,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727523026;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727523026;}", "4", "1", "2024-09-28 11:30:59", "2024-09-28 15:00:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2544", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:29:39", "2024-09-28 14:59:39", "[10268,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522979;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522979;}", "4", "1", "2024-09-28 11:29:58", "2024-09-28 14:59:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2543", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:28:03", "2024-09-28 14:58:03", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522883;}", "4", "1", "2024-09-28 11:28:21", "2024-09-28 14:58:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2542", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:25:07", "2024-09-28 14:55:07", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522707;}", "4", "1", "2024-09-28 11:25:08", "2024-09-28 14:55:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2541", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:24:07", "2024-09-28 14:54:07", "[10288,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522647;}", "4", "1", "2024-09-28 11:24:07", "2024-09-28 14:54:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2540", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:24:07", "2024-09-28 14:54:07", "[16289,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522647;}", "4", "1", "2024-09-28 11:24:07", "2024-09-28 14:54:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2539", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:21:32", "2024-09-28 14:51:32", "[10299,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522492;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522492;}", "4", "1", "2024-09-28 11:22:00", "2024-09-28 14:52:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2538", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:17:55", "2024-09-28 14:47:55", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522275;}", "4", "1", "2024-09-28 11:18:00", "2024-09-28 14:48:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2537", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 11:16:18", "2024-09-28 14:46:18", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727522178;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727522178;}", "4", "1", "2024-09-28 11:16:47", "2024-09-28 14:46:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2536", "action_scheduler/migration_hook", "failed", "2024-09-28 11:12:34", "2024-09-28 14:42:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727521954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727521954;}", "1", "1", "2024-09-28 11:12:34", "2024-09-28 14:42:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2535", "action_scheduler/migration_hook", "complete", "2024-09-28 11:11:22", "2024-09-28 14:41:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727521882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727521882;}", "1", "1", "2024-09-28 11:11:33", "2024-09-28 14:41:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2534", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:43:28", "2024-09-28 14:13:28", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727520208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727520208;}", "4", "1", "2024-09-28 10:43:59", "2024-09-28 14:13:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2533", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:43:17", "2024-09-28 14:13:17", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727520197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727520197;}", "4", "1", "2024-09-28 10:43:17", "2024-09-28 14:13:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2532", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:36:21", "2024-09-28 14:06:21", "[9852,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519781;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519781;}", "4", "1", "2024-09-28 10:36:58", "2024-09-28 14:06:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2531", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:32:36", "2024-09-28 14:02:36", "[10268,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519556;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519556;}", "4", "1", "2024-09-28 10:32:48", "2024-09-28 14:02:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2530", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:27:54", "2024-09-28 13:57:54", "[9817,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519274;}", "4", "1", "2024-09-28 10:28:04", "2024-09-28 13:58:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2529", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:27:30", "2024-09-28 13:57:30", "[16316,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519250;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519250;}", "4", "1", "2024-09-28 10:27:38", "2024-09-28 13:57:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2528", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:27:11", "2024-09-28 13:57:11", "[16317,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519231;}", "4", "1", "2024-09-28 10:27:38", "2024-09-28 13:57:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2527", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "[16316,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519197;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2526", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:35", "2024-09-28 13:56:35", "[9817,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519195;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519195;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2525", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:35", "2024-09-28 13:56:35", "[9822,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519195;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519195;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2524", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:32", "2024-09-28 13:56:32", "[9821,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519192;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519192;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2523", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:30", "2024-09-28 13:56:30", "[9820,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519190;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519190;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2522", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:27", "2024-09-28 13:56:27", "[9819,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519187;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2521", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:24", "2024-09-28 13:56:24", "[9818,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519184;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519184;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2520", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:26:19", "2024-09-28 13:56:19", "[9817,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519179;}", "4", "1", "2024-09-28 10:26:37", "2024-09-28 13:56:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2519", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:24:46", "2024-09-28 13:54:46", "[9852,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519086;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519086;}", "4", "1", "2024-09-28 10:24:58", "2024-09-28 13:54:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2518", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:24:46", "2024-09-28 13:54:46", "[9854,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519086;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519086;}", "4", "1", "2024-09-28 10:24:58", "2024-09-28 13:54:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2517", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:24:46", "2024-09-28 13:54:46", "[9853,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519086;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519086;}", "4", "1", "2024-09-28 10:24:58", "2024-09-28 13:54:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2516", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:24:45", "2024-09-28 13:54:45", "[9853,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519085;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519085;}", "4", "1", "2024-09-28 10:24:58", "2024-09-28 13:54:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2515", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:24:44", "2024-09-28 13:54:44", "[9854,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519084;}", "4", "1", "2024-09-28 10:24:58", "2024-09-28 13:54:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2514", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:24:07", "2024-09-28 13:54:07", "[9852,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727519047;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727519047;}", "4", "1", "2024-09-28 10:24:35", "2024-09-28 13:54:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2513", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:22:33", "2024-09-28 13:52:33", "[9910,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518953;}", "4", "1", "2024-09-28 10:22:58", "2024-09-28 13:52:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2512", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:22:33", "2024-09-28 13:52:33", "[9911,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518953;}", "4", "1", "2024-09-28 10:22:58", "2024-09-28 13:52:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2511", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:22:33", "2024-09-28 13:52:33", "[9912,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518953;}", "4", "1", "2024-09-28 10:22:58", "2024-09-28 13:52:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2510", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:22:32", "2024-09-28 13:52:32", "[9911,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518952;}", "4", "1", "2024-09-28 10:22:58", "2024-09-28 13:52:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2509", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:22:32", "2024-09-28 13:52:32", "[9912,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518952;}", "4", "1", "2024-09-28 10:22:58", "2024-09-28 13:52:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2508", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:21:47", "2024-09-28 13:51:47", "[9910,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518907;}", "4", "1", "2024-09-28 10:21:58", "2024-09-28 13:51:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2507", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:19:56", "2024-09-28 13:49:56", "[9977,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518796;}", "4", "1", "2024-09-28 10:19:58", "2024-09-28 13:49:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2506", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:19:46", "2024-09-28 13:49:46", "[16312,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518786;}", "4", "1", "2024-09-28 10:19:58", "2024-09-28 13:49:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2505", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:19:46", "2024-09-28 13:49:46", "[9978,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518786;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518786;}", "4", "1", "2024-09-28 10:19:58", "2024-09-28 13:49:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2504", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:19:06", "2024-09-28 13:49:06", "[16312,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518746;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518746;}", "4", "1", "2024-09-28 10:19:27", "2024-09-28 13:49:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2503", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:18:56", "2024-09-28 13:48:56", "[9977,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518736;}", "4", "1", "2024-09-28 10:18:58", "2024-09-28 13:48:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2502", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:15:44", "2024-09-28 13:45:44", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518544;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518544;}", "4", "1", "2024-09-28 10:16:00", "2024-09-28 13:46:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2501", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:15:43", "2024-09-28 13:45:43", "[16310,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518543;}", "4", "1", "2024-09-28 10:16:00", "2024-09-28 13:46:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2500", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:15:43", "2024-09-28 13:45:43", "[10094,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518543;}", "4", "1", "2024-09-28 10:16:00", "2024-09-28 13:46:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2499", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:15:00", "2024-09-28 13:45:00", "[16310,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518500;}", "4", "1", "2024-09-28 10:15:20", "2024-09-28 13:45:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2498", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:13:28", "2024-09-28 13:43:28", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518408;}", "4", "1", "2024-09-28 10:14:01", "2024-09-28 13:44:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2497", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:13:07", "2024-09-28 13:43:07", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518387;}", "4", "1", "2024-09-28 10:13:18", "2024-09-28 13:43:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2496", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:09:59", "2024-09-28 13:39:59", "[10111,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518199;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518199;}", "4", "1", "2024-09-28 10:10:07", "2024-09-28 13:40:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2495", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:09:34", "2024-09-28 13:39:34", "[10112,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518174;}", "4", "1", "2024-09-28 10:09:58", "2024-09-28 13:39:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2494", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:09:34", "2024-09-28 13:39:34", "[16307,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518174;}", "4", "1", "2024-09-28 10:09:58", "2024-09-28 13:39:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2493", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:08:28", "2024-09-28 13:38:28", "[16307,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518108;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518108;}", "4", "1", "2024-09-28 10:08:58", "2024-09-28 13:38:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2492", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:08:21", "2024-09-28 13:38:21", "[10111,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727518101;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727518101;}", "4", "1", "2024-09-28 10:08:58", "2024-09-28 13:38:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2491", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:05:52", "2024-09-28 13:35:52", "[10144,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517952;}", "4", "1", "2024-09-28 10:06:00", "2024-09-28 13:36:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2490", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:05:51", "2024-09-28 13:35:51", "[10147,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517951;}", "4", "1", "2024-09-28 10:06:00", "2024-09-28 13:36:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2489", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 10:05:51", "2024-09-28 13:35:51", "[10148,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517951;}", "4", "1", "2024-09-28 10:05:59", "2024-09-28 13:35:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2488", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:57:47", "2024-09-28 13:27:47", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517467;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517467;}", "4", "1", "2024-09-28 09:58:00", "2024-09-28 13:28:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2487", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:55:36", "2024-09-28 13:25:36", "[10146,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517336;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517336;}", "4", "1", "2024-09-28 09:55:37", "2024-09-28 13:25:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2486", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:55:33", "2024-09-28 13:25:33", "[10145,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517333;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517333;}", "4", "1", "2024-09-28 09:55:37", "2024-09-28 13:25:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2485", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:55:22", "2024-09-28 13:25:22", "[10144,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517322;}", "4", "1", "2024-09-28 09:55:32", "2024-09-28 13:25:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2484", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:50:41", "2024-09-28 13:20:41", "[10165,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517041;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517041;}", "4", "1", "2024-09-28 09:50:58", "2024-09-28 13:20:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2483", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:50:19", "2024-09-28 13:20:19", "[10165,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517019;}", "4", "1", "2024-09-28 09:50:25", "2024-09-28 13:20:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2482", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:50:18", "2024-09-28 13:20:18", "[16300,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517018;}", "4", "1", "2024-09-28 09:50:25", "2024-09-28 13:20:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2480", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:49:08", "2024-09-28 13:19:08", "[16300,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516948;}", "4", "1", "2024-09-28 09:49:22", "2024-09-28 13:19:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2481", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:50:18", "2024-09-28 13:20:18", "[10166,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727517018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727517018;}", "4", "1", "2024-09-28 09:50:25", "2024-09-28 13:20:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2479", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:48:43", "2024-09-28 13:18:43", "[10165,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516923;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516923;}", "4", "1", "2024-09-28 09:48:58", "2024-09-28 13:18:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2478", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:46:08", "2024-09-28 13:16:08", "[10183,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516768;}", "4", "1", "2024-09-28 09:46:13", "2024-09-28 13:16:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2477", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:46:07", "2024-09-28 13:16:07", "[10184,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516767;}", "4", "1", "2024-09-28 09:46:13", "2024-09-28 13:16:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2476", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:46:07", "2024-09-28 13:16:07", "[16296,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516767;}", "4", "1", "2024-09-28 09:46:13", "2024-09-28 13:16:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2472", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:39:10", "2024-09-28 13:09:10", "[16296,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516350;}", "4", "1", "2024-09-28 09:40:01", "2024-09-28 13:10:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2475", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:45:01", "2024-09-28 13:15:01", "[10183,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516701;}", "4", "1", "2024-09-28 09:45:10", "2024-09-28 13:15:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2474", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:45:01", "2024-09-28 13:15:01", "[16296,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516701;}", "4", "1", "2024-09-28 09:45:10", "2024-09-28 13:15:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2473", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:45:01", "2024-09-28 13:15:01", "[10184,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516701;}", "4", "1", "2024-09-28 09:45:10", "2024-09-28 13:15:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2471", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:39:03", "2024-09-28 13:09:03", "[10183,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727516343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727516343;}", "4", "1", "2024-09-28 09:40:01", "2024-09-28 13:10:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2470", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:33:04", "2024-09-28 13:03:04", "[10213,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515984;}", "4", "1", "2024-09-28 09:33:42", "2024-09-28 13:03:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2469", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:33:04", "2024-09-28 13:03:04", "[16293,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515984;}", "4", "1", "2024-09-28 09:33:42", "2024-09-28 13:03:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2468", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:33:04", "2024-09-28 13:03:04", "[10214,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515984;}", "4", "1", "2024-09-28 09:33:42", "2024-09-28 13:03:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2467", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:32:11", "2024-09-28 13:02:11", "[16293,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515931;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515931;}", "4", "1", "2024-09-28 09:32:42", "2024-09-28 13:02:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2466", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:31:47", "2024-09-28 13:01:47", "[10213,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515907;}", "4", "1", "2024-09-28 09:32:00", "2024-09-28 13:02:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2462", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:27:56", "2024-09-28 12:57:56", "[10268,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515676;}", "4", "1", "2024-09-28 09:27:58", "2024-09-28 12:57:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2458", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:19:13", "2024-09-28 12:49:13", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515153;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515153;}", "4", "1", "2024-09-28 09:19:19", "2024-09-28 12:49:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2465", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:29:01", "2024-09-28 12:59:01", "[10268,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515741;}", "4", "1", "2024-09-28 09:29:35", "2024-09-28 12:59:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2464", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:29:00", "2024-09-28 12:59:00", "[10269,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515740;}", "4", "1", "2024-09-28 09:29:35", "2024-09-28 12:59:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2463", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:29:00", "2024-09-28 12:59:00", "[10270,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515740;}", "4", "1", "2024-09-28 09:29:35", "2024-09-28 12:59:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2461", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:20:03", "2024-09-28 12:50:03", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515203;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515203;}", "4", "1", "2024-09-28 09:20:21", "2024-09-28 12:50:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2460", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:20:02", "2024-09-28 12:50:02", "[10288,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515202;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515202;}", "4", "1", "2024-09-28 09:20:21", "2024-09-28 12:50:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2459", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:19:41", "2024-09-28 12:49:41", "[16289,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727515181;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727515181;}", "4", "1", "2024-09-28 09:20:01", "2024-09-28 12:50:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2457", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:14:43", "2024-09-28 12:44:43", "[10299,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727514883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727514883;}", "4", "1", "2024-09-28 09:15:02", "2024-09-28 12:45:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2456", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:13:56", "2024-09-28 12:43:56", "[10299,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727514836;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727514836;}", "4", "1", "2024-09-28 09:14:00", "2024-09-28 12:44:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2455", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:12:38", "2024-09-28 12:42:38", "[16284,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727514758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727514758;}", "4", "1", "2024-09-28 09:13:00", "2024-09-28 12:43:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2454", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:12:07", "2024-09-28 12:42:07", "[10299,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727514727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727514727;}", "4", "1", "2024-09-28 09:13:00", "2024-09-28 12:43:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2453", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 09:11:59", "2024-09-28 12:41:59", "[16284,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727514719;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727514719;}", "4", "1", "2024-09-28 09:12:00", "2024-09-28 12:42:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2452", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:59:27", "2024-09-28 12:29:27", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513967;}", "4", "1", "2024-09-28 09:00:17", "2024-09-28 12:30:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2451", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:58:04", "2024-09-28 12:28:04", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513884;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513884;}", "4", "1", "2024-09-28 08:58:16", "2024-09-28 12:28:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2450", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:57:06", "2024-09-28 12:27:06", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513826;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513826;}", "4", "1", "2024-09-28 08:57:14", "2024-09-28 12:27:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2449", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:53:57", "2024-09-28 12:23:57", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513637;}", "4", "1", "2024-09-28 08:53:59", "2024-09-28 12:23:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2448", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:47:13", "2024-09-28 12:17:13", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513233;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513233;}", "4", "1", "2024-09-28 08:47:48", "2024-09-28 12:17:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2447", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:45:35", "2024-09-28 12:15:35", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513135;}", "4", "1", "2024-09-28 08:45:45", "2024-09-28 12:15:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2446", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:44:05", "2024-09-28 12:14:05", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727513045;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727513045;}", "4", "1", "2024-09-28 08:44:44", "2024-09-28 12:14:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2445", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:42:05", "2024-09-28 12:12:05", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727512925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727512925;}", "4", "1", "2024-09-28 08:42:37", "2024-09-28 12:12:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2444", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:36:48", "2024-09-28 12:06:48", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727512608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727512608;}", "4", "1", "2024-09-28 08:37:01", "2024-09-28 12:07:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2443", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:35:54", "2024-09-28 12:05:54", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727512554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727512554;}", "4", "1", "2024-09-28 08:36:02", "2024-09-28 12:06:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2442", "wc_schedule_update_product_default_cat", "complete", "2024-09-28 08:35:03", "2024-09-28 12:05:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727512503;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727512503;}", "5", "1", "2024-09-28 08:35:18", "2024-09-28 12:05:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2441", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:26:59", "2024-09-28 11:56:59", "[9817,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727512019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727512019;}", "4", "1", "2024-09-28 08:26:59", "2024-09-28 11:56:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2440", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:26:45", "2024-09-28 11:56:45", "[9852,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727512005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727512005;}", "4", "1", "2024-09-28 08:26:46", "2024-09-28 11:56:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2439", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:26:29", "2024-09-28 11:56:29", "[9910,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511989;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511989;}", "4", "1", "2024-09-28 08:26:41", "2024-09-28 11:56:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2438", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:25:45", "2024-09-28 11:55:45", "[9910,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511945;}", "4", "1", "2024-09-28 08:25:45", "2024-09-28 11:55:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2437", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:25:04", "2024-09-28 11:55:04", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511904;}", "4", "1", "2024-09-28 08:25:40", "2024-09-28 11:55:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2436", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:24:39", "2024-09-28 11:54:39", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511879;}", "4", "1", "2024-09-28 08:24:39", "2024-09-28 11:54:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2435", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:24:00", "2024-09-28 11:54:00", "[9977,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511840;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511840;}", "4", "1", "2024-09-28 08:24:39", "2024-09-28 11:54:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2434", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:23:44", "2024-09-28 11:53:44", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511824;}", "4", "1", "2024-09-28 08:23:59", "2024-09-28 11:53:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2433", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:21:48", "2024-09-28 11:51:48", "[10111,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511708;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511708;}", "4", "1", "2024-09-28 08:21:58", "2024-09-28 11:51:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2432", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:21:32", "2024-09-28 11:51:32", "[10144,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511692;}", "4", "1", "2024-09-28 08:21:33", "2024-09-28 11:51:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2431", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:20:58", "2024-09-28 11:50:58", "[10165,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511658;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511658;}", "4", "1", "2024-09-28 08:20:58", "2024-09-28 11:50:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2430", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:20:40", "2024-09-28 11:50:40", "[10183,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511640;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511640;}", "4", "1", "2024-09-28 08:20:58", "2024-09-28 11:50:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2429", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:20:22", "2024-09-28 11:50:22", "[10213,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511622;}", "4", "1", "2024-09-28 08:20:32", "2024-09-28 11:50:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2428", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:19:55", "2024-09-28 11:49:55", "[10268,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511595;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511595;}", "4", "1", "2024-09-28 08:19:58", "2024-09-28 11:49:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2427", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:19:28", "2024-09-28 11:49:28", "[10287,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511568;}", "4", "1", "2024-09-28 08:19:30", "2024-09-28 11:49:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2426", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:19:11", "2024-09-28 11:49:11", "[10299,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511551;}", "4", "1", "2024-09-28 08:19:30", "2024-09-28 11:49:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2425", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:18:47", "2024-09-28 11:48:47", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511527;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511527;}", "4", "1", "2024-09-28 08:18:58", "2024-09-28 11:48:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2424", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:18:28", "2024-09-28 11:48:28", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511508;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511508;}", "4", "1", "2024-09-28 08:18:28", "2024-09-28 11:48:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2423", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 08:18:04", "2024-09-28 11:48:04", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727511484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727511484;}", "4", "1", "2024-09-28 08:18:28", "2024-09-28 11:48:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2422", "wc_schedule_update_product_default_cat", "complete", "2024-09-28 06:54:55", "2024-09-28 10:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506495;}", "5", "1", "2024-09-28 06:54:58", "2024-09-28 10:24:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2421", "wc_schedule_update_product_default_cat", "complete", "2024-09-28 06:54:55", "2024-09-28 10:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506495;}", "5", "1", "2024-09-28 06:54:58", "2024-09-28 10:24:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2420", "wc_schedule_update_product_default_cat", "complete", "2024-09-28 06:54:55", "2024-09-28 10:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506495;}", "5", "1", "2024-09-28 06:54:58", "2024-09-28 10:24:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2418", "wc_schedule_update_product_default_cat", "complete", "2024-09-28 06:54:55", "2024-09-28 10:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506495;}", "5", "1", "2024-09-28 06:54:58", "2024-09-28 10:24:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2419", "wc_schedule_update_product_default_cat", "complete", "2024-09-28 06:54:55", "2024-09-28 10:24:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506495;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506495;}", "5", "1", "2024-09-28 06:54:58", "2024-09-28 10:24:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2417", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:24", "2024-09-28 10:20:24", "[9790,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506224;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2416", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:24", "2024-09-28 10:20:24", "[9791,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506224;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2415", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:24", "2024-09-28 10:20:24", "[9796,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506224;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2414", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:24", "2024-09-28 10:20:24", "[9798,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506224;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2413", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:24", "2024-09-28 10:20:24", "[9797,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506224;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506224;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2412", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9800,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2411", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9799,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2410", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9805,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2409", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9806,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2408", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9811,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2407", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9812,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2406", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9834,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2405", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9835,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2404", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9877,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2403", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9879,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2402", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9878,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2401", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9917,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2400", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9918,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2399", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9947,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2398", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9948,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2397", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9959,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2396", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9960,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2395", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9965,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2394", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:23", "2024-09-28 10:20:23", "[9966,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506223;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506223;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2393", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[11881,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2392", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[11882,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2391", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[9983,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2389", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10031,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2388", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10032,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2387", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10037,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2386", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10038,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2385", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10081,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2390", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[9984,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2384", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10082,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2383", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10087,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2382", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10088,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2381", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10099,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2380", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10100,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2379", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10105,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2378", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10106,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2377", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10117,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2376", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10118,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2375", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10125,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2374", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:22", "2024-09-28 10:20:22", "[10126,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506222;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2372", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10131,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2371", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10139,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2370", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10143,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2369", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10142,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2368", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10141,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2373", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10130,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2367", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10140,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2366", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10153,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2365", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10154,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2364", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10159,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2363", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10160,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2362", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10171,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2361", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10172,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2336", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10256,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2335", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10257,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2334", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10262,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2360", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10177,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2359", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10178,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2358", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10189,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2357", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10190,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2356", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:21", "2024-09-28 10:20:21", "[10195,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506221;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2355", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10196,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2354", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10201,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2353", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10202,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2352", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10207,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2351", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10208,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2350", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10219,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2349", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10220,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2348", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10225,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2347", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10226,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2346", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:20", "2024-09-28 10:20:20", "[10231,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506220;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2345", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10232,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2344", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10237,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2343", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10238,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2342", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10243,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2341", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10244,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2340", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10249,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2339", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10251,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2338", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10250,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2337", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[11841,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2333", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10263,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2332", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10275,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2331", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10276,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2330", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10293,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2321", "wc-admin_import_orders", "complete", "2024-09-28 06:06:21", "2024-09-28 09:36:21", "[16126]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727503581;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727503581;}", "2", "1", "2024-09-28 06:06:56", "2024-09-28 09:36:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2320", "woocommerce_cleanup_draft_orders", "complete", "2024-09-28 15:03:29", "2024-09-28 18:33:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727535809;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727535809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-29 05:18:19", "2024-09-29 08:48:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2329", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10294,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2328", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10305,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2327", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10431,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2326", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:19", "2024-09-28 10:20:19", "[10432,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506219;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2325", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:18", "2024-09-28 10:20:18", "[10433,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506218;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2324", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:18", "2024-09-28 10:20:18", "[10281,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506218;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2323", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-28 06:50:18", "2024-09-28 10:20:18", "[9923,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727506218;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727506218;}", "4", "1", "2024-09-28 06:51:00", "2024-09-28 10:21:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2322", "wc-admin_import_orders", "complete", "2024-09-28 06:15:00", "2024-09-28 09:45:00", "[16139]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727504100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727504100;}", "2", "1", "2024-09-28 06:16:16", "2024-09-28 09:46:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2319", "fetch_patterns", "complete", "2024-09-26 13:31:29", "2024-09-26 17:01:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727357489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727357489;}", "7", "1", "2024-09-26 13:31:46", "2024-09-26 17:01:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2318", "woocommerce_cleanup_draft_orders", "complete", "2024-09-27 11:25:39", "2024-09-27 14:55:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727436339;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727436339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-27 15:03:29", "2024-09-27 18:33:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2317", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 12:44:23", "2024-09-25 16:14:23", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727268263;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727268263;}", "4", "1", "2024-09-25 12:45:02", "2024-09-25 16:15:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2316", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 12:36:03", "2024-09-25 16:06:03", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727267763;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727267763;}", "4", "1", "2024-09-25 12:37:05", "2024-09-25 16:07:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2315", "woocommerce_cleanup_draft_orders", "complete", "2024-09-26 11:25:17", "2024-09-26 14:55:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727349917;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727349917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-26 11:25:39", "2024-09-26 14:55:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2314", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 09:50:29", "2024-09-25 13:20:29", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727257829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727257829;}", "4", "1", "2024-09-25 09:51:50", "2024-09-25 13:21:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2313", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 09:42:43", "2024-09-25 13:12:43", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727257363;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727257363;}", "4", "1", "2024-09-25 09:42:54", "2024-09-25 13:12:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2312", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 09:40:42", "2024-09-25 13:10:42", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727257242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727257242;}", "4", "1", "2024-09-25 09:40:52", "2024-09-25 13:10:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2311", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 09:29:43", "2024-09-25 12:59:43", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727256583;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727256583;}", "4", "1", "2024-09-25 09:30:23", "2024-09-25 13:00:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2310", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:55:04", "2024-09-25 12:25:04", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254504;}", "4", "1", "2024-09-25 08:55:41", "2024-09-25 12:25:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2309", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-25 08:55:04", "2024-09-25 12:25:04", "[15506,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727254504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727254504;}", "4", "1", "2024-09-25 08:55:41", "2024-09-25 12:25:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2070", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9771,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2071", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9767,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2072", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9766,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2073", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9760,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2074", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9761,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2075", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9759,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2076", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9756,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2077", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9755,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2078", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:19", "2024-09-10 15:52:19", "[9752,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970939;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970939;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2079", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9751,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2080", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9744,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2081", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9745,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2082", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9746,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2083", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9747,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2084", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9743,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2085", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9738,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2086", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9737,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2087", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9732,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2088", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9731,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2089", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9726,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2090", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9725,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2091", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9720,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2092", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9719,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2093", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9714,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2094", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:20", "2024-09-10 15:52:20", "[9713,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970940;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970940;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2095", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:34", "2024-09-10 15:52:34", "[9828,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970954;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970954;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2096", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9829,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2097", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9827,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2098", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9841,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2099", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9840,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2100", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9847,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2101", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9846,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2102", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:35", "2024-09-10 15:52:35", "[9860,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970955;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970955;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2103", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9861,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2104", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9859,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2105", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9865,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2106", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9864,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2107", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9871,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2108", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9872,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2109", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:36", "2024-09-10 15:52:36", "[9870,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970956;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2110", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:37", "2024-09-10 15:52:37", "[9886,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970957;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2111", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:37", "2024-09-10 15:52:37", "[9885,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970957;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2112", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:37", "2024-09-10 15:52:37", "[9884,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970957;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2113", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:37", "2024-09-10 15:52:37", "[9892,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970957;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2114", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:37", "2024-09-10 15:52:37", "[9893,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970957;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2115", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:37", "2024-09-10 15:52:37", "[9891,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970957;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970957;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2116", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:38", "2024-09-10 15:52:38", "[9899,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970958;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2117", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:38", "2024-09-10 15:52:38", "[9898,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970958;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2118", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:38", "2024-09-10 15:52:38", "[9905,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970958;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2119", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:38", "2024-09-10 15:52:38", "[9904,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970958;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2120", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:38", "2024-09-10 15:52:38", "[9930,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970958;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2121", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:38", "2024-09-10 15:52:38", "[9929,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970958;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2122", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:39", "2024-09-10 15:52:39", "[9936,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970959;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2123", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:39", "2024-09-10 15:52:39", "[9935,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970959;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2124", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:39", "2024-09-10 15:52:39", "[9942,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970959;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2125", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:39", "2024-09-10 15:52:39", "[9941,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970959;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2126", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:40", "2024-09-10 15:52:40", "[9954,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970960;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2127", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:40", "2024-09-10 15:52:40", "[9953,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970960;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2128", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:40", "2024-09-10 15:52:40", "[9972,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970960;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2129", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:40", "2024-09-10 15:52:40", "[9971,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970960;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2130", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:40", "2024-09-10 15:52:40", "[9990,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970960;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2131", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:40", "2024-09-10 15:52:40", "[9989,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970960;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2132", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:41", "2024-09-10 15:52:41", "[9996,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970961;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2133", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:41", "2024-09-10 15:52:41", "[9995,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970961;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2134", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:41", "2024-09-10 15:52:41", "[10002,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970961;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2135", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:41", "2024-09-10 15:52:41", "[10001,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970961;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2136", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:41", "2024-09-10 15:52:41", "[10008,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970961;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2137", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:41", "2024-09-10 15:52:41", "[10007,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970961;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2138", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:42", "2024-09-10 15:52:42", "[10014,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970962;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2139", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:42", "2024-09-10 15:52:42", "[10013,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970962;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2140", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:42", "2024-09-10 15:52:42", "[10020,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970962;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2141", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:42", "2024-09-10 15:52:42", "[10019,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970962;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2142", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:42", "2024-09-10 15:52:42", "[10026,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970962;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2143", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:42", "2024-09-10 15:52:42", "[10025,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970962;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2144", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:43", "2024-09-10 15:52:43", "[10044,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970963;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2145", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:43", "2024-09-10 15:52:43", "[10043,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970963;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2146", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:43", "2024-09-10 15:52:43", "[10050,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970963;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2147", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:43", "2024-09-10 15:52:43", "[10049,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970963;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2148", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:43", "2024-09-10 15:52:43", "[10056,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970963;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2149", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:43", "2024-09-10 15:52:43", "[10055,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970963;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2150", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "[10062,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970964;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2151", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "[10061,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970964;}", "4", "1", "2024-09-10 12:22:44", "2024-09-10 15:52:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2152", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10068,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2153", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10069,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2154", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10070,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2155", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10067,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2156", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10076,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2157", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10075,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2158", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:45", "2024-09-10 15:52:45", "[10318,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970965;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2159", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10319,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2160", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10317,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2161", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10325,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2162", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10326,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2163", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10324,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2164", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10332,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2165", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10333,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2166", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:46", "2024-09-10 15:52:46", "[10331,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970966;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2167", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:47", "2024-09-10 15:52:47", "[10339,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970967;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2168", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:47", "2024-09-10 15:52:47", "[10338,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970967;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2169", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:47", "2024-09-10 15:52:47", "[10345,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970967;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2170", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:47", "2024-09-10 15:52:47", "[10344,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970967;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2171", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:47", "2024-09-10 15:52:47", "[10351,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970967;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2172", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:47", "2024-09-10 15:52:47", "[10350,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970967;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2173", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:48", "2024-09-10 15:52:48", "[10357,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970968;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2174", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:48", "2024-09-10 15:52:48", "[10356,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970968;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2175", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:48", "2024-09-10 15:52:48", "[10363,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970968;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2176", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:48", "2024-09-10 15:52:48", "[10362,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970968;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2177", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:48", "2024-09-10 15:52:48", "[10369,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970968;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2178", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:48", "2024-09-10 15:52:48", "[10368,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970968;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2179", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:49", "2024-09-10 15:52:49", "[10375,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970969;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2180", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:49", "2024-09-10 15:52:49", "[10374,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970969;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2181", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:49", "2024-09-10 15:52:49", "[10381,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970969;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2182", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:49", "2024-09-10 15:52:49", "[10380,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970969;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2183", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:49", "2024-09-10 15:52:49", "[10387,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970969;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2184", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:49", "2024-09-10 15:52:49", "[10388,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970969;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2185", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "[10386,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970970;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2186", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "[10394,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970970;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2187", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "[10395,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970970;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2188", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "[10393,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970970;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2189", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "[10401,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970970;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2190", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "[10400,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970970;}", "4", "1", "2024-09-10 12:22:50", "2024-09-10 15:52:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2191", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10407,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2192", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10406,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2193", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10413,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2194", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10414,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2195", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10412,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2196", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10439,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2197", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:22:51", "2024-09-10 15:52:51", "[10438,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725970971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725970971;}", "4", "1", "2024-09-10 12:22:55", "2024-09-10 15:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2198", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:24:50", "2024-09-10 15:54:50", "[10293,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725971090;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725971090;}", "4", "1", "2024-09-10 12:24:51", "2024-09-10 15:54:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2199", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:24:51", "2024-09-10 15:54:51", "[10243,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725971091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725971091;}", "4", "1", "2024-09-10 12:24:51", "2024-09-10 15:54:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2200", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:26:55", "2024-09-10 15:56:55", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725971215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725971215;}", "4", "1", "2024-09-10 12:26:57", "2024-09-10 15:56:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2201", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:29:51", "2024-09-10 15:59:51", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725971391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725971391;}", "4", "1", "2024-09-10 12:30:05", "2024-09-10 16:00:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2202", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:30:56", "2024-09-10 16:00:56", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725971456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725971456;}", "4", "1", "2024-09-10 12:31:07", "2024-09-10 16:01:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2203", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:31:23", "2024-09-10 16:01:23", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725971483;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725971483;}", "4", "1", "2024-09-10 12:36:50", "2024-09-10 16:06:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2204", "action_scheduler/migration_hook", "complete", "2024-09-10 12:47:33", "2024-09-10 16:17:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972453;}", "1", "1", "2024-09-10 12:48:05", "2024-09-10 16:18:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2205", "action_scheduler/migration_hook", "failed", "2024-09-10 12:49:05", "2024-09-10 16:19:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972545;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972545;}", "1", "1", "2024-09-10 12:49:05", "2024-09-10 16:19:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2206", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:50:44", "2024-09-10 16:20:44", "[10431,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972644;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972644;}", "4", "1", "2024-09-10 12:51:08", "2024-09-10 16:21:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2207", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:52:21", "2024-09-10 16:22:21", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972741;}", "4", "1", "2024-09-10 12:52:26", "2024-09-10 16:22:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2208", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:52:48", "2024-09-10 16:22:48", "[9947,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972768;}", "4", "1", "2024-09-10 12:53:06", "2024-09-10 16:23:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2209", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:53:27", "2024-09-10 16:23:27", "[10037,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972807;}", "4", "1", "2024-09-10 12:54:06", "2024-09-10 16:24:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2210", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:53:52", "2024-09-10 16:23:52", "[9959,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972832;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972832;}", "4", "1", "2024-09-10 12:54:06", "2024-09-10 16:24:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2211", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:54:48", "2024-09-10 16:24:48", "[9983,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972888;}", "4", "1", "2024-09-10 12:55:06", "2024-09-10 16:25:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2212", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:55:19", "2024-09-10 16:25:19", "[10031,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725972919;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725972919;}", "4", "1", "2024-09-10 12:55:50", "2024-09-10 16:25:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2213", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:56:45", "2024-09-10 16:26:45", "[10243,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973005;}", "4", "1", "2024-09-10 12:56:52", "2024-09-10 16:26:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2214", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:57:17", "2024-09-10 16:27:17", "[10237,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973037;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973037;}", "4", "1", "2024-09-10 12:57:53", "2024-09-10 16:27:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2215", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:57:50", "2024-09-10 16:27:50", "[10231,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973070;}", "4", "1", "2024-09-10 12:57:53", "2024-09-10 16:27:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2216", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:58:18", "2024-09-10 16:28:18", "[10225,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973098;}", "4", "1", "2024-09-10 12:58:54", "2024-09-10 16:28:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2217", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 12:59:08", "2024-09-10 16:29:08", "[9965,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973148;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973148;}", "4", "1", "2024-09-10 12:59:56", "2024-09-10 16:29:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2218", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:00:06", "2024-09-10 16:30:06", "[9977,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973206;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973206;}", "4", "1", "2024-09-10 13:00:58", "2024-09-10 16:30:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2219", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:00:58", "2024-09-10 16:30:58", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973258;}", "4", "1", "2024-09-10 13:00:58", "2024-09-10 16:30:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2220", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:01:00", "2024-09-10 16:31:00", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973260;}", "4", "1", "2024-09-10 13:01:03", "2024-09-10 16:31:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2221", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:01:22", "2024-09-10 16:31:22", "[10219,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973282;}", "4", "1", "2024-09-10 13:02:05", "2024-09-10 16:32:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2222", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:01:29", "2024-09-10 16:31:29", "[10220,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973289;}", "4", "1", "2024-09-10 13:02:05", "2024-09-10 16:32:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2223", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:02:41", "2024-09-10 16:32:41", "[10087,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973361;}", "4", "1", "2024-09-10 13:03:06", "2024-09-10 16:33:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2224", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:03:07", "2024-09-10 16:33:07", "[10081,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973387;}", "4", "1", "2024-09-10 13:03:20", "2024-09-10 16:33:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2225", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:03:33", "2024-09-10 16:33:33", "[10117,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973413;}", "4", "1", "2024-09-10 13:04:12", "2024-09-10 16:34:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2226", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:03:51", "2024-09-10 16:33:51", "[10111,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973431;}", "4", "1", "2024-09-10 13:04:12", "2024-09-10 16:34:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2227", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:04:53", "2024-09-10 16:34:53", "[10207,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973493;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973493;}", "4", "1", "2024-09-10 13:05:07", "2024-09-10 16:35:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2228", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:06:00", "2024-09-10 16:36:00", "[10099,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973560;}", "4", "1", "2024-09-10 13:06:05", "2024-09-10 16:36:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2229", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:06:15", "2024-09-10 16:36:15", "[10093,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973575;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973575;}", "4", "1", "2024-09-10 13:07:17", "2024-09-10 16:37:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2230", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-10 13:06:22", "2024-09-10 16:36:22", "[10099,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1725973582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1725973582;}", "4", "1", "2024-09-10 13:07:17", "2024-09-10 16:37:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2231", "woocommerce_cleanup_draft_orders", "complete", "2024-09-12 10:18:20", "2024-09-12 13:48:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726136300;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726136300;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-12 11:04:39", "2024-09-12 14:34:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2233", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-12 18:18:59", "2024-09-12 21:48:59", "[10249,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726165139;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726165139;}", "4", "1", "2024-09-12 18:19:10", "2024-09-12 21:49:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2234", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-12 18:19:11", "2024-09-12 21:49:11", "[10251,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726165151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726165151;}", "4", "1", "2024-09-12 18:19:46", "2024-09-12 21:49:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2235", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-12 18:20:05", "2024-09-12 21:50:05", "[11841,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726165205;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726165205;}", "4", "1", "2024-09-12 18:20:14", "2024-09-12 21:50:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2236", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-12 18:20:16", "2024-09-12 21:50:16", "[10249,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726165216;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726165216;}", "4", "1", "2024-09-12 18:20:50", "2024-09-12 21:50:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2237", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-12 18:38:19", "2024-09-12 22:08:19", "[10249,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726166299;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726166299;}", "4", "1", "2024-09-12 18:39:11", "2024-09-12 22:09:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2238", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:19:45", "2024-09-13 11:49:45", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215585;}", "4", "1", "2024-09-13 08:20:06", "2024-09-13 11:50:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2239", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:20:31", "2024-09-13 11:50:31", "[9965,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215631;}", "4", "1", "2024-09-13 08:20:42", "2024-09-13 11:50:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2240", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:20:38", "2024-09-13 11:50:38", "[11881,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215638;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215638;}", "4", "1", "2024-09-13 08:20:42", "2024-09-13 11:50:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2241", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:20:47", "2024-09-13 11:50:47", "[11882,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215647;}", "4", "1", "2024-09-13 08:20:47", "2024-09-13 11:50:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2242", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:21:10", "2024-09-13 11:51:10", "[9966,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215670;}", "4", "1", "2024-09-13 08:21:44", "2024-09-13 11:51:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2243", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:21:10", "2024-09-13 11:51:10", "[11881,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215670;}", "4", "1", "2024-09-13 08:21:44", "2024-09-13 11:51:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2244", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:21:10", "2024-09-13 11:51:10", "[11882,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215670;}", "4", "1", "2024-09-13 08:21:44", "2024-09-13 11:51:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2245", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:21:11", "2024-09-13 11:51:11", "[9965,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726215671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726215671;}", "4", "1", "2024-09-13 08:21:44", "2024-09-13 11:51:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2246", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:41:07", "2024-09-13 12:11:07", "[9965,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726216867;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726216867;}", "4", "1", "2024-09-13 08:41:27", "2024-09-13 12:11:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2247", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-13 08:49:15", "2024-09-13 12:19:15", "[11882,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726217355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726217355;}", "4", "1", "2024-09-13 08:49:41", "2024-09-13 12:19:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2248", "action_scheduler/migration_hook", "complete", "2024-09-13 09:54:19", "2024-09-13 13:24:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726221259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726221259;}", "1", "1", "2024-09-13 09:54:54", "2024-09-13 13:24:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2249", "woocommerce_cleanup_draft_orders", "complete", "2024-09-14 11:06:28", "2024-09-14 14:36:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726311988;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726311988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-14 11:06:44", "2024-09-14 14:36:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2250", "fetch_patterns", "complete", "2024-09-14 06:37:26", "2024-09-14 10:07:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726295846;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726295846;}", "7", "1", "2024-09-14 06:37:54", "2024-09-14 10:07:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2251", "woocommerce_run_update_callback", "complete", "2024-09-14 06:45:19", "2024-09-14 10:15:19", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726296319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726296319;}", "4", "1", "2024-09-14 06:45:29", "2024-09-14 10:15:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2252", "woocommerce_run_update_callback", "complete", "2024-09-14 06:45:20", "2024-09-14 10:15:20", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726296320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726296320;}", "4", "1", "2024-09-14 06:45:29", "2024-09-14 10:15:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2253", "woocommerce_update_db_to_current_version", "complete", "2024-09-14 06:45:21", "2024-09-14 10:15:21", "{\"version\":\"9.3.1\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726296321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726296321;}", "4", "1", "2024-09-14 06:45:29", "2024-09-14 10:15:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2254", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 10:54:18", "2024-09-14 14:24:18", "[10306,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311258;}", "4", "1", "2024-09-14 10:55:03", "2024-09-14 14:25:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2255", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 10:54:18", "2024-09-14 14:24:18", "[10305,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311258;}", "4", "1", "2024-09-14 10:55:03", "2024-09-14 14:25:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2256", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 10:54:42", "2024-09-14 14:24:42", "[10420,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311282;}", "4", "1", "2024-09-14 10:55:03", "2024-09-14 14:25:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2257", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 10:54:42", "2024-09-14 14:24:42", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311282;}", "4", "1", "2024-09-14 10:55:03", "2024-09-14 14:25:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2258", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 10:55:07", "2024-09-14 14:25:07", "[10312,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311307;}", "4", "1", "2024-09-14 10:55:07", "2024-09-14 14:25:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2259", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 10:55:07", "2024-09-14 14:25:07", "[10311,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311307;}", "4", "1", "2024-09-14 10:55:07", "2024-09-14 14:25:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2260", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:03:17", "2024-09-14 14:33:17", "[12555,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311797;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311797;}", "4", "1", "2024-09-14 11:04:07", "2024-09-14 14:34:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2261", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:03:33", "2024-09-14 14:33:33", "[10426,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311813;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311813;}", "4", "1", "2024-09-14 11:04:07", "2024-09-14 14:34:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2262", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:03:33", "2024-09-14 14:33:33", "[12555,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311813;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311813;}", "4", "1", "2024-09-14 11:04:07", "2024-09-14 14:34:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2263", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:03:35", "2024-09-14 14:33:35", "[12555,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726311815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726311815;}", "4", "1", "2024-09-14 11:04:07", "2024-09-14 14:34:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2264", "woocommerce_cleanup_draft_orders", "complete", "2024-09-15 11:06:44", "2024-09-15 14:36:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726398404;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726398404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-15 11:07:08", "2024-09-15 14:37:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2265", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:08:43", "2024-09-14 14:38:43", "[12556,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726312123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726312123;}", "4", "1", "2024-09-14 11:08:59", "2024-09-14 14:38:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2266", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:09:06", "2024-09-14 14:39:06", "[12556,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726312146;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726312146;}", "4", "1", "2024-09-14 11:10:00", "2024-09-14 14:40:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2267", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:09:10", "2024-09-14 14:39:10", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726312150;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726312150;}", "4", "1", "2024-09-14 11:10:00", "2024-09-14 14:40:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2268", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:10:08", "2024-09-14 14:40:08", "[12556,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726312208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726312208;}", "4", "1", "2024-09-14 11:11:08", "2024-09-14 14:41:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2269", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:11:22", "2024-09-14 14:41:22", "[12556,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726312282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726312282;}", "4", "1", "2024-09-14 11:11:59", "2024-09-14 14:41:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2270", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:26:23", "2024-09-14 14:56:23", "[12559,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313183;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313183;}", "4", "1", "2024-09-14 11:27:04", "2024-09-14 14:57:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2271", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:26:41", "2024-09-14 14:56:41", "[10426,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313201;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313201;}", "4", "1", "2024-09-14 11:27:04", "2024-09-14 14:57:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2272", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:26:44", "2024-09-14 14:56:44", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313204;}", "4", "1", "2024-09-14 11:27:04", "2024-09-14 14:57:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2273", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:27:53", "2024-09-14 14:57:53", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313273;}", "4", "1", "2024-09-14 11:27:57", "2024-09-14 14:57:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2274", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:27:58", "2024-09-14 14:57:58", "[10426,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313278;}", "4", "1", "2024-09-14 11:28:32", "2024-09-14 14:58:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2275", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:28:01", "2024-09-14 14:58:01", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313281;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313281;}", "4", "1", "2024-09-14 11:28:32", "2024-09-14 14:58:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2276", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:29:59", "2024-09-14 14:59:59", "[10426,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313399;}", "4", "1", "2024-09-14 11:30:39", "2024-09-14 15:00:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2277", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-14 11:30:01", "2024-09-14 15:00:01", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726313401;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726313401;}", "4", "1", "2024-09-14 11:30:39", "2024-09-14 15:00:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2278", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 09:04:13", "2024-09-15 12:34:13", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726391053;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726391053;}", "4", "1", "2024-09-15 09:05:06", "2024-09-15 12:35:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2279", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 09:17:24", "2024-09-15 12:47:24", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726391844;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726391844;}", "4", "1", "2024-09-15 09:18:00", "2024-09-15 12:48:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2280", "woocommerce_cleanup_draft_orders", "complete", "2024-09-16 11:07:08", "2024-09-16 14:37:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726484828;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726484828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-16 11:07:33", "2024-09-16 14:37:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2281", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:32:22", "2024-09-15 15:02:22", "[10281,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726399942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726399942;}", "4", "1", "2024-09-15 11:32:41", "2024-09-15 15:02:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2282", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:33:26", "2024-09-15 15:03:26", "[12559,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400006;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400006;}", "4", "1", "2024-09-15 11:33:53", "2024-09-15 15:03:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2283", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:33:27", "2024-09-15 15:03:27", "[10426,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400007;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400007;}", "4", "1", "2024-09-15 11:33:53", "2024-09-15 15:03:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2284", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:33:27", "2024-09-15 15:03:27", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400007;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400007;}", "4", "1", "2024-09-15 11:33:53", "2024-09-15 15:03:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2285", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:34:58", "2024-09-15 15:04:58", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400098;}", "4", "1", "2024-09-15 11:36:08", "2024-09-15 15:06:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2286", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:36:51", "2024-09-15 15:06:51", "[10419,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400211;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400211;}", "4", "1", "2024-09-15 11:37:01", "2024-09-15 15:07:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2287", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:39:07", "2024-09-15 15:09:07", "[9924,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400347;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400347;}", "4", "1", "2024-09-15 11:39:42", "2024-09-15 15:09:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2288", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:39:07", "2024-09-15 15:09:07", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400347;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400347;}", "4", "1", "2024-09-15 11:39:42", "2024-09-15 15:09:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2289", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:40:08", "2024-09-15 15:10:08", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400408;}", "4", "1", "2024-09-15 11:40:46", "2024-09-15 15:10:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2290", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:41:00", "2024-09-15 15:11:00", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400460;}", "4", "1", "2024-09-15 11:41:50", "2024-09-15 15:11:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2291", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:42:30", "2024-09-15 15:12:30", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400550;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400550;}", "4", "1", "2024-09-15 11:42:55", "2024-09-15 15:12:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2292", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-15 11:44:38", "2024-09-15 15:14:38", "[9923,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726400678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726400678;}", "4", "1", "2024-09-15 11:44:58", "2024-09-15 15:14:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2293", "woocommerce_cleanup_draft_orders", "complete", "2024-09-17 11:07:33", "2024-09-17 14:37:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726571253;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726571253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-17 11:08:13", "2024-09-17 14:38:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2294", "woocommerce_cleanup_draft_orders", "complete", "2024-09-18 11:08:13", "2024-09-18 14:38:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726657693;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726657693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-18 11:08:47", "2024-09-18 14:38:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2295", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-17 11:50:49", "2024-09-17 15:20:49", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726573849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726573849;}", "4", "1", "2024-09-17 11:50:58", "2024-09-17 15:20:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2296", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-17 11:51:19", "2024-09-17 15:21:19", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726573879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726573879;}", "4", "1", "2024-09-17 11:52:02", "2024-09-17 15:22:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2298", "fetch_patterns", "complete", "2024-09-19 07:17:10", "2024-09-19 10:47:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1726730230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1726730230;}", "7", "1", "2024-09-19 07:17:48", "2024-09-19 10:47:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2299", "woocommerce_cleanup_draft_orders", "complete", "2024-09-20 11:08:59", "2024-09-20 14:38:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726830539;s:18:\"\0*\0first_timestamp\";i:1656142542;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726830539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-09-21 15:51:15", "2024-09-21 19:21:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2569", "action_scheduler/migration_hook", "complete", "2024-09-29 12:55:20", "2024-09-29 16:25:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727614520;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727614520;}", "1", "1", "2024-09-29 13:08:18", "2024-09-29 16:38:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2570", "action_scheduler/migration_hook", "failed", "2024-09-29 13:09:18", "2024-09-29 16:39:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727615358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727615358;}", "1", "1", "2024-09-29 13:13:12", "2024-09-29 16:43:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2572", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-09-30 07:51:43", "2024-09-30 11:21:43", "[10425,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727682703;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727682703;}", "4", "1", "2024-09-30 07:53:49", "2024-09-30 11:23:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2573", "action_scheduler/migration_hook", "pending", "2024-09-30 10:04:13", "2024-09-30 13:34:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1727690653;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1727690653;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1358", "461", "action created", "2022-11-13 05:28:32", "2022-11-13 08:58:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1359", "461", "action started via WP Cron", "2022-11-13 05:29:10", "2022-11-13 08:59:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1360", "461", "action failed via WP Cron: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2022-11-13 05:29:10", "2022-11-13 08:59:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1846", "624", "ایجاد فعالیت", "2023-04-26 06:10:18", "2023-04-26 09:40:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1847", "624", "عملیات توسط Async Request شروع شد", "2023-04-26 06:10:24", "2023-04-26 09:40:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1848", "624", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-04-26 06:10:24", "2023-04-26 09:40:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1900", "642", "ایجاد فعالیت", "2023-04-26 07:01:43", "2023-04-26 10:31:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1902", "642", "عملیات توسط WP Cron شروع شد", "2023-04-26 07:02:53", "2023-04-26 10:32:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1903", "642", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-04-26 07:02:53", "2023-04-26 10:32:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2911", "979", "ایجاد فعالیت", "2023-05-11 05:43:48", "2023-05-11 09:13:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2912", "979", "عملیات توسط Async Request شروع شد", "2023-05-11 05:43:49", "2023-05-11 09:13:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2913", "979", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-11 05:43:49", "2023-05-11 09:13:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3458", "1162", "ایجاد فعالیت", "2023-07-13 07:38:24", "2023-07-13 11:08:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3223", "1083", "ایجاد فعالیت", "2023-06-14 08:15:54", "2023-06-14 11:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3224", "1083", "عملیات توسط Async Request شروع شد", "2023-06-14 08:17:05", "2023-06-14 11:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3225", "1083", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-14 08:17:05", "2023-06-14 11:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3495", "1162", "عملیات توسط Async Request شروع شد", "2023-07-13 07:39:41", "2023-07-13 11:09:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3496", "1162", "اقدام از طریق Async Request انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-07-13 07:39:41", "2023-07-13 11:09:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3499", "1175", "ایجاد فعالیت", "2023-07-13 07:40:44", "2023-07-13 11:10:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3500", "1175", "عملیات توسط Async Request شروع شد", "2023-07-13 07:41:48", "2023-07-13 11:11:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3501", "1175", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-07-13 07:41:48", "2023-07-13 11:11:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3577", "1201", "ایجاد فعالیت", "2023-07-23 06:17:07", "2023-07-23 09:47:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3578", "1201", "عملیات توسط WP Cron شروع شد", "2023-07-23 06:19:07", "2023-07-23 09:49:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3579", "1201", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-07-23 06:19:07", "2023-07-23 09:49:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3610", "1212", "ایجاد فعالیت", "2023-08-02 09:02:42", "2023-08-02 12:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3611", "1212", "عملیات توسط Async Request شروع شد", "2023-08-02 09:03:43", "2023-08-02 12:33:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3612", "1212", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-08-02 09:03:43", "2023-08-02 12:33:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3664", "1230", "ایجاد فعالیت", "2023-08-06 07:11:10", "2023-08-06 10:41:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3665", "1230", "عملیات توسط Async Request شروع شد", "2023-08-06 07:12:13", "2023-08-06 10:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3666", "1230", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-08-06 07:12:13", "2023-08-06 10:42:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("5787", "1937", "عملیات توسط Async Request شروع شد", "2024-09-02 10:20:58", "2024-09-02 13:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5784", "1938", "ایجاد فعالیت", "2024-09-02 10:20:03", "2024-09-02 13:50:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("5785", "1938", "عملیات توسط WP Cron شروع شد", "2024-09-02 10:20:34", "2024-09-02 13:50:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5786", "1938", "عملیات توسط WP Cron کامل شد", "2024-09-02 10:20:34", "2024-09-02 13:50:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6670", "2232", "ایجاد فعالیت", "2024-09-12 11:04:39", "2024-09-12 14:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3928", "1319", "ایجاد فعالیت", "2024-05-30 12:40:06", "2024-05-30 16:10:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3929", "1319", "عملیات توسط WP Cron شروع شد", "2024-05-30 12:41:08", "2024-05-30 16:11:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3930", "1319", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-30 12:41:08", "2024-05-30 16:11:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6669", "2231", "عملیات توسط WP Cron کامل شد", "2024-09-12 11:04:39", "2024-09-12 14:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6668", "2231", "عملیات توسط WP Cron شروع شد", "2024-09-12 11:04:39", "2024-09-12 14:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5835", "1952", "عملیات توسط WP Cron کامل شد", "2024-09-10 09:02:39", "2024-09-10 12:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6864", "2294", "عملیات توسط Async Request کامل شد", "2024-09-18 11:08:47", "2024-09-18 14:38:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6863", "2294", "عملیات توسط Async Request شروع شد", "2024-09-18 11:08:47", "2024-09-18 14:38:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6104", "2035", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6872", "2299", "عملیات توسط WP Cron شروع شد", "2024-09-21 15:51:15", "2024-09-21 19:21:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6873", "2299", "عملیات توسط WP Cron کامل شد", "2024-09-21 15:51:15", "2024-09-21 19:21:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6874", "2300", "ایجاد فعالیت", "2024-09-21 15:51:15", "2024-09-21 19:21:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6877", "2301", "ایجاد فعالیت", "2024-09-23 05:16:09", "2024-09-23 08:46:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6881", "2303", "ایجاد فعالیت", "2024-09-25 08:53:23", "2024-09-25 12:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("6882", "2303", "عملیات توسط Async Request شروع شد", "2024-09-25 08:53:28", "2024-09-25 12:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6883", "2303", "عملیات توسط Async Request کامل شد", "2024-09-25 08:53:28", "2024-09-25 12:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6103", "2034", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6102", "2034", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6072", "2019", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6073", "2019", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6880", "2302", "ایجاد فعالیت", "2024-09-24 11:25:05", "2024-09-24 14:55:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6101", "2033", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6876", "2300", "عملیات توسط WP Cron کامل شد", "2024-09-23 05:16:09", "2024-09-23 08:46:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6875", "2300", "عملیات توسط WP Cron شروع شد", "2024-09-23 05:16:09", "2024-09-23 08:46:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6100", "2033", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6098", "2032", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6096", "2031", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6094", "2030", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6092", "2029", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6088", "2027", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6089", "2027", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6099", "2032", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6097", "2031", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6095", "2030", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6093", "2029", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6091", "2028", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6090", "2028", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6087", "2026", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6086", "2026", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6085", "2025", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6084", "2025", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6083", "2024", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6082", "2024", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6081", "2023", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6075", "2020", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6076", "2021", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6077", "2021", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6078", "2022", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6080", "2023", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6079", "2022", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6074", "2020", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6071", "2018", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6070", "2018", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6014", "1990", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6069", "2017", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6068", "2017", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6067", "2016", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6066", "2016", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6065", "2015", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6063", "2014", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6059", "2012", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6060", "2013", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6064", "2015", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6062", "2014", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6061", "2013", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6058", "2012", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6057", "2011", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6056", "2011", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6054", "2010", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6048", "2007", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6049", "2007", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6050", "2008", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6051", "2008", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6055", "2010", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6053", "2009", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6052", "2009", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6047", "2006", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6046", "2006", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6045", "2005", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6044", "2005", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6043", "2004", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6039", "2002", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6040", "2003", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6042", "2004", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6041", "2003", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6038", "2002", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6037", "2001", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6036", "2001", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6032", "1999", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6033", "1999", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6035", "2000", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6034", "2000", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6031", "1998", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6030", "1998", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6029", "1997", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6028", "1997", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6027", "1996", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6021", "1993", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6022", "1994", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6023", "1994", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6024", "1995", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6026", "1996", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6025", "1995", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6020", "1993", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6019", "1992", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6015", "1990", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6016", "1991", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6017", "1991", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6018", "1992", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6879", "2301", "عملیات توسط WP Cron کامل شد", "2024-09-24 11:25:05", "2024-09-24 14:55:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6878", "2301", "عملیات توسط WP Cron شروع شد", "2024-09-24 11:25:05", "2024-09-24 14:55:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6013", "1989", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6012", "1989", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6011", "1988", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6010", "1988", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5994", "1980", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6009", "1987", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6003", "1984", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6004", "1985", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6005", "1985", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6006", "1986", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6008", "1987", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6007", "1986", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6002", "1984", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6001", "1983", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5999", "1982", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6000", "1983", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5998", "1982", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5997", "1981", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5996", "1981", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5995", "1980", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5993", "1979", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5992", "1979", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5942", "2052", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5943", "2053", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5990", "1978", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5986", "1976", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5987", "1976", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5991", "1978", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5989", "1977", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5988", "1977", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5985", "1975", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5984", "1975", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5983", "1974", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5982", "1974", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5981", "1973", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5980", "1973", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5979", "1972", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5978", "1972", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5977", "1971", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5976", "1971", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5975", "1970", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5758", "1928", "ایجاد فعالیت", "2024-08-29 15:23:55", "2024-08-29 18:53:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7686", "2567", "عملیات توسط Async Request کامل شد", "2024-09-30 05:18:35", "2024-09-30 08:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7685", "2567", "عملیات توسط Async Request شروع شد", "2024-09-30 05:18:35", "2024-09-30 08:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5974", "1970", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5973", "1969", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5972", "1969", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5971", "1968", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5970", "1968", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5969", "1967", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5965", "1965", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5966", "1966", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5968", "1967", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5967", "1966", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5964", "1965", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5963", "1964", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5962", "1964", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5961", "1963", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5960", "1963", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5956", "1961", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5957", "1961", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5959", "1962", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5958", "1962", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5955", "1960", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5954", "1960", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5953", "1959", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5952", "1959", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5951", "2061", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5950", "2060", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5949", "2059", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5948", "2058", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5947", "2057", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5946", "2056", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5945", "2055", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5944", "2054", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5941", "2051", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5940", "2050", "ایجاد فعالیت", "2024-09-10 12:21:48", "2024-09-10 15:51:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5827", "1951", "عملیات توسط WP Cron کامل شد", "2024-09-08 10:52:31", "2024-09-08 14:22:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5937", "2047", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5938", "2048", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5939", "2049", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5936", "2046", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5935", "2045", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5934", "2044", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5933", "2043", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5932", "2042", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5931", "2041", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5928", "2038", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5929", "2039", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5930", "2040", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5927", "2037", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5926", "2036", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5925", "2035", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5922", "2032", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5923", "2033", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5924", "2034", "ایجاد فعالیت", "2024-09-10 12:21:47", "2024-09-10 15:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5921", "2031", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5920", "2030", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5919", "2029", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5916", "2026", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5917", "2027", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5918", "2028", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5915", "2025", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5914", "2024", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5913", "2023", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5910", "2020", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5911", "2021", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5912", "2022", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5909", "2019", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5908", "2018", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5907", "2017", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5906", "2016", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5905", "2015", "ایجاد فعالیت", "2024-09-10 12:21:46", "2024-09-10 15:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5898", "2008", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5899", "2009", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5900", "2010", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5901", "2011", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5902", "2012", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5903", "2013", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5904", "2014", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5897", "2007", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5896", "2006", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5895", "2005", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5894", "2004", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5893", "2003", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5892", "2002", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5891", "2001", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5890", "2000", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5889", "1999", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5886", "1996", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5887", "1997", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5888", "1998", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5885", "1995", "ایجاد فعالیت", "2024-09-10 12:21:45", "2024-09-10 15:51:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("5884", "1994", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5883", "1993", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5882", "1992", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5877", "1987", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5878", "1988", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5879", "1989", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5880", "1990", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5881", "1991", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5876", "1986", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5875", "1985", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5874", "1984", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5871", "1981", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5872", "1982", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5873", "1983", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5870", "1980", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5869", "1979", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5868", "1978", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5761", "1929", "ایجاد فعالیت", "2024-08-31 09:21:03", "2024-08-31 12:51:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("5866", "1976", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5867", "1977", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5760", "1928", "عملیات توسط WP Cron کامل شد", "2024-08-31 09:21:03", "2024-08-31 12:51:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("5759", "1928", "عملیات توسط WP Cron شروع شد", "2024-08-31 09:21:03", "2024-08-31 12:51:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("5865", "1975", "ایجاد فعالیت", "2024-09-10 12:21:44", "2024-09-10 15:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("5859", "1969", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5860", "1970", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5861", "1971", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5862", "1972", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5863", "1973", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5864", "1974", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5858", "1968", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5857", "1967", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5856", "1966", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5853", "1963", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5854", "1964", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5855", "1965", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5852", "1962", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5851", "1961", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5850", "1960", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5845", "1957", "عملیات توسط Async Request کامل شد", "2024-09-10 11:03:04", "2024-09-10 14:33:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5846", "1958", "ایجاد فعالیت", "2024-09-10 11:06:35", "2024-09-10 14:36:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5847", "1958", "عملیات توسط WP Cron شروع شد", "2024-09-10 11:08:30", "2024-09-10 14:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5848", "1958", "عملیات توسط WP Cron کامل شد", "2024-09-10 11:08:30", "2024-09-10 14:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5849", "1959", "ایجاد فعالیت", "2024-09-10 12:21:43", "2024-09-10 15:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5844", "1957", "عملیات توسط Async Request شروع شد", "2024-09-10 11:03:04", "2024-09-10 14:33:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5843", "1956", "عملیات توسط WP Cron کامل شد", "2024-09-10 11:02:29", "2024-09-10 14:32:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5840", "1956", "ایجاد فعالیت", "2024-09-10 11:02:29", "2024-09-10 14:32:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5841", "1957", "ایجاد فعالیت", "2024-09-10 11:02:29", "2024-09-10 14:32:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5842", "1956", "عملیات توسط WP Cron شروع شد", "2024-09-10 11:02:29", "2024-09-10 14:32:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5839", "1955", "عملیات توسط WP Cron کامل شد", "2024-09-10 10:51:41", "2024-09-10 14:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5838", "1955", "عملیات توسط WP Cron شروع شد", "2024-09-10 10:51:41", "2024-09-10 14:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5837", "1955", "ایجاد فعالیت", "2024-09-10 10:51:40", "2024-09-10 14:21:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("5830", "1952", "ایجاد فعالیت", "2024-09-09 09:01:48", "2024-09-09 12:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5831", "1953", "ایجاد فعالیت", "2024-09-09 10:37:56", "2024-09-09 14:07:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("5832", "1953", "عملیات توسط WP Cron شروع شد", "2024-09-09 10:38:41", "2024-09-09 14:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5833", "1953", "عملیات توسط WP Cron کامل شد", "2024-09-09 10:38:41", "2024-09-09 14:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5836", "1954", "ایجاد فعالیت", "2024-09-10 09:02:39", "2024-09-10 12:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5829", "1939", "عملیات توسط WP Cron کامل شد", "2024-09-09 09:01:48", "2024-09-09 12:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5828", "1939", "عملیات توسط WP Cron شروع شد", "2024-09-09 09:01:48", "2024-09-09 12:31:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("5826", "1951", "عملیات توسط WP Cron شروع شد", "2024-09-08 10:52:31", "2024-09-08 14:22:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("5825", "1951", "ایجاد فعالیت", "2024-09-08 10:52:29", "2024-09-08 14:22:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5790", "1930", "عملیات توسط WP Cron کامل شد", "2024-09-07 15:18:59", "2024-09-07 18:48:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5824", "1950", "عملیات توسط Async Request کامل شد", "2024-09-08 10:52:19", "2024-09-08 14:22:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5823", "1950", "عملیات توسط Async Request شروع شد", "2024-09-08 10:52:19", "2024-09-08 14:22:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5822", "1949", "عملیات توسط Async Request کامل شد", "2024-09-08 10:52:19", "2024-09-08 14:22:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5821", "1949", "عملیات توسط Async Request شروع شد", "2024-09-08 10:52:19", "2024-09-08 14:22:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5816", "1948", "ایجاد فعالیت", "2024-09-08 10:51:53", "2024-09-08 14:21:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("5817", "1949", "ایجاد فعالیت", "2024-09-08 10:52:14", "2024-09-08 14:22:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("5818", "1950", "ایجاد فعالیت", "2024-09-08 10:52:17", "2024-09-08 14:22:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5819", "1948", "عملیات توسط Async Request شروع شد", "2024-09-08 10:52:19", "2024-09-08 14:22:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5820", "1948", "عملیات توسط Async Request کامل شد", "2024-09-08 10:52:19", "2024-09-08 14:22:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5815", "1947", "عملیات توسط Async Request کامل شد", "2024-09-08 10:51:17", "2024-09-08 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5814", "1947", "عملیات توسط Async Request شروع شد", "2024-09-08 10:51:17", "2024-09-08 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5812", "1946", "عملیات توسط Async Request شروع شد", "2024-09-08 10:51:17", "2024-09-08 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5813", "1946", "عملیات توسط Async Request کامل شد", "2024-09-08 10:51:17", "2024-09-08 14:21:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5811", "1947", "ایجاد فعالیت", "2024-09-08 10:51:05", "2024-09-08 14:21:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5810", "1946", "ایجاد فعالیت", "2024-09-08 10:51:04", "2024-09-08 14:21:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("5808", "1945", "عملیات توسط Async Request شروع شد", "2024-09-08 10:22:22", "2024-09-08 13:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5809", "1945", "عملیات توسط Async Request کامل شد", "2024-09-08 10:22:22", "2024-09-08 13:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5807", "1944", "عملیات توسط Async Request کامل شد", "2024-09-08 10:22:22", "2024-09-08 13:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5806", "1944", "عملیات توسط Async Request شروع شد", "2024-09-08 10:22:22", "2024-09-08 13:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5801", "1943", "ایجاد فعالیت", "2024-09-08 10:22:17", "2024-09-08 13:52:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5802", "1944", "ایجاد فعالیت", "2024-09-08 10:22:17", "2024-09-08 13:52:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("5803", "1945", "ایجاد فعالیت", "2024-09-08 10:22:20", "2024-09-08 13:52:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("5804", "1943", "عملیات توسط Async Request شروع شد", "2024-09-08 10:22:22", "2024-09-08 13:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5805", "1943", "عملیات توسط Async Request کامل شد", "2024-09-08 10:22:22", "2024-09-08 13:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5800", "1942", "عملیات توسط Async Request کامل شد", "2024-09-08 10:06:58", "2024-09-08 13:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5799", "1942", "عملیات توسط Async Request شروع شد", "2024-09-08 10:06:58", "2024-09-08 13:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5793", "1940", "عملیات توسط WP Cron شروع شد", "2024-09-08 09:54:30", "2024-09-08 13:24:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5794", "1940", "عملیات توسط WP Cron کامل شد", "2024-09-08 09:54:30", "2024-09-08 13:24:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("5798", "1942", "ایجاد فعالیت", "2024-09-08 10:06:39", "2024-09-08 13:36:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("5797", "1941", "عملیات توسط Async Request کامل شد", "2024-09-08 10:05:50", "2024-09-08 13:35:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5796", "1941", "عملیات توسط Async Request شروع شد", "2024-09-08 10:05:50", "2024-09-08 13:35:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5795", "1941", "ایجاد فعالیت", "2024-09-08 10:05:46", "2024-09-08 13:35:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("5792", "1940", "ایجاد فعالیت", "2024-09-08 09:54:23", "2024-09-08 13:24:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("5791", "1939", "ایجاد فعالیت", "2024-09-07 15:18:59", "2024-09-07 18:48:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5789", "1930", "عملیات توسط WP Cron شروع شد", "2024-09-07 15:18:59", "2024-09-07 18:48:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5788", "1937", "عملیات توسط Async Request کامل شد", "2024-09-02 10:20:58", "2024-09-02 13:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5767", "1931", "عملیات توسط Async Request کامل شد", "2024-09-02 05:03:59", "2024-09-02 08:33:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5768", "1932", "ایجاد فعالیت", "2024-09-02 05:03:59", "2024-09-02 08:33:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5769", "1932", "عملیات توسط Async Request شروع شد", "2024-09-02 05:05:05", "2024-09-02 08:35:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5783", "1937", "ایجاد فعالیت", "2024-09-02 10:19:47", "2024-09-02 13:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("5782", "1936", "عملیات توسط WP Cron کامل شد", "2024-09-02 10:19:32", "2024-09-02 13:49:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5781", "1936", "عملیات توسط WP Cron شروع شد", "2024-09-02 10:19:32", "2024-09-02 13:49:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5780", "1936", "ایجاد فعالیت", "2024-09-02 10:19:07", "2024-09-02 13:49:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("5779", "1935", "عملیات توسط Async Request کامل شد", "2024-09-02 10:14:29", "2024-09-02 13:44:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5778", "1935", "عملیات توسط Async Request شروع شد", "2024-09-02 10:14:29", "2024-09-02 13:44:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("5777", "1935", "ایجاد فعالیت", "2024-09-02 10:13:33", "2024-09-02 13:43:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("5776", "1934", "عملیات توسط WP Cron کامل شد", "2024-09-02 10:13:32", "2024-09-02 13:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4505", "1511", "ایجاد فعالیت", "2024-07-31 11:49:40", "2024-07-31 15:19:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4506", "1511", "عملیات توسط WP Cron شروع شد", "2024-07-31 11:51:41", "2024-07-31 15:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("4507", "1511", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-07-31 11:51:41", "2024-07-31 15:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("5775", "1934", "عملیات توسط WP Cron شروع شد", "2024-09-02 10:13:32", "2024-09-02 13:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5774", "1933", "عملیات توسط WP Cron کامل شد", "2024-09-02 10:13:32", "2024-09-02 13:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5773", "1933", "عملیات توسط WP Cron شروع شد", "2024-09-02 10:13:32", "2024-09-02 13:43:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("5764", "1930", "ایجاد فعالیت", "2024-09-02 04:33:50", "2024-09-02 08:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5763", "1929", "عملیات توسط WP Cron کامل شد", "2024-09-02 04:33:50", "2024-09-02 08:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5762", "1929", "عملیات توسط WP Cron شروع شد", "2024-09-02 04:33:50", "2024-09-02 08:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5772", "1934", "ایجاد فعالیت", "2024-09-02 10:12:59", "2024-09-02 13:42:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5771", "1933", "ایجاد فعالیت", "2024-09-02 10:12:59", "2024-09-02 13:42:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5770", "1932", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-02 05:05:05", "2024-09-02 08:35:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("5766", "1931", "عملیات توسط Async Request شروع شد", "2024-09-02 05:03:59", "2024-09-02 08:33:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("5765", "1931", "ایجاد فعالیت", "2024-09-02 05:02:58", "2024-09-02 08:32:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("5834", "1952", "عملیات توسط WP Cron شروع شد", "2024-09-10 09:02:39", "2024-09-10 12:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7675", "2567", "ایجاد فعالیت", "2024-09-29 05:18:19", "2024-09-29 08:48:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7676", "2568", "ایجاد فعالیت", "2024-09-29 10:02:31", "2024-09-29 13:32:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7677", "2568", "عملیات توسط Async Request شروع شد", "2024-09-29 10:02:55", "2024-09-29 13:32:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7678", "2568", "عملیات توسط Async Request کامل شد", "2024-09-29 10:02:55", "2024-09-29 13:32:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7674", "2320", "عملیات توسط WP Cron کامل شد", "2024-09-29 05:18:19", "2024-09-29 08:48:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7673", "2320", "عملیات توسط WP Cron شروع شد", "2024-09-29 05:18:19", "2024-09-29 08:48:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7672", "2566", "عملیات توسط Async Request کامل شد", "2024-09-28 12:18:40", "2024-09-28 15:48:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7670", "2566", "ایجاد فعالیت", "2024-09-28 12:18:28", "2024-09-28 15:48:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7668", "2565", "عملیات توسط WP Cron شروع شد", "2024-09-28 12:18:03", "2024-09-28 15:48:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7666", "2564", "عملیات توسط Async Request کامل شد", "2024-09-28 12:15:32", "2024-09-28 15:45:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7664", "2563", "عملیات توسط Async Request کامل شد", "2024-09-28 12:15:32", "2024-09-28 15:45:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7661", "2563", "ایجاد فعالیت", "2024-09-28 12:15:21", "2024-09-28 15:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7659", "2562", "عملیات توسط WP Cron شروع شد", "2024-09-28 12:14:02", "2024-09-28 15:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7656", "2562", "ایجاد فعالیت", "2024-09-28 12:13:36", "2024-09-28 15:43:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7650", "2559", "عملیات توسط WP Cron شروع شد", "2024-09-28 12:09:59", "2024-09-28 15:39:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7651", "2559", "عملیات توسط WP Cron کامل شد", "2024-09-28 12:09:59", "2024-09-28 15:39:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7652", "2560", "ایجاد فعالیت", "2024-09-28 12:09:59", "2024-09-28 15:39:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7653", "2560", "عملیات توسط WP Cron شروع شد", "2024-09-28 12:11:08", "2024-09-28 15:41:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7654", "2560", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-28 12:11:08", "2024-09-28 15:41:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7671", "2566", "عملیات توسط Async Request شروع شد", "2024-09-28 12:18:40", "2024-09-28 15:48:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7669", "2565", "عملیات توسط WP Cron کامل شد", "2024-09-28 12:18:03", "2024-09-28 15:48:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7667", "2565", "ایجاد فعالیت", "2024-09-28 12:17:38", "2024-09-28 15:47:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7665", "2564", "عملیات توسط Async Request شروع شد", "2024-09-28 12:15:32", "2024-09-28 15:45:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7663", "2563", "عملیات توسط Async Request شروع شد", "2024-09-28 12:15:32", "2024-09-28 15:45:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7662", "2564", "ایجاد فعالیت", "2024-09-28 12:15:21", "2024-09-28 15:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7660", "2562", "عملیات توسط WP Cron کامل شد", "2024-09-28 12:14:02", "2024-09-28 15:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7658", "2561", "عملیات توسط WP Cron کامل شد", "2024-09-28 12:14:02", "2024-09-28 15:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7657", "2561", "عملیات توسط WP Cron شروع شد", "2024-09-28 12:14:02", "2024-09-28 15:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7655", "2561", "ایجاد فعالیت", "2024-09-28 12:13:27", "2024-09-28 15:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7649", "2559", "ایجاد فعالیت", "2024-09-28 12:08:52", "2024-09-28 15:38:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7648", "2558", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:47:01", "2024-09-28 15:17:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7645", "2557", "عملیات توسط Async Request کامل شد", "2024-09-28 11:44:05", "2024-09-28 15:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7646", "2558", "ایجاد فعالیت", "2024-09-28 11:46:29", "2024-09-28 15:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7647", "2558", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:47:01", "2024-09-28 15:17:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7644", "2557", "عملیات توسط Async Request شروع شد", "2024-09-28 11:44:05", "2024-09-28 15:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7643", "2557", "ایجاد فعالیت", "2024-09-28 11:43:59", "2024-09-28 15:13:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7642", "2556", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:42:58", "2024-09-28 15:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7630", "2552", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:37:01", "2024-09-28 15:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7631", "2553", "ایجاد فعالیت", "2024-09-28 11:37:02", "2024-09-28 15:07:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7632", "2553", "عملیات توسط Async Request شروع شد", "2024-09-28 11:37:43", "2024-09-28 15:07:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7641", "2556", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:42:58", "2024-09-28 15:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7640", "2556", "ایجاد فعالیت", "2024-09-28 11:42:05", "2024-09-28 15:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7639", "2555", "عملیات توسط Async Request کامل شد", "2024-09-28 11:41:58", "2024-09-28 15:11:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7638", "2555", "عملیات توسط Async Request شروع شد", "2024-09-28 11:41:58", "2024-09-28 15:11:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7637", "2555", "ایجاد فعالیت", "2024-09-28 11:41:57", "2024-09-28 15:11:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7636", "2554", "عملیات توسط Async Request کامل شد", "2024-09-28 11:40:57", "2024-09-28 15:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7635", "2554", "عملیات توسط Async Request شروع شد", "2024-09-28 11:40:57", "2024-09-28 15:10:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7634", "2554", "ایجاد فعالیت", "2024-09-28 11:40:07", "2024-09-28 15:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7633", "2553", "عملیات توسط Async Request کامل شد", "2024-09-28 11:37:43", "2024-09-28 15:07:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7629", "2552", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:37:01", "2024-09-28 15:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7628", "2551", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:37:01", "2024-09-28 15:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7627", "2551", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:37:01", "2024-09-28 15:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7626", "2552", "ایجاد فعالیت", "2024-09-28 11:37:00", "2024-09-28 15:07:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7625", "2551", "ایجاد فعالیت", "2024-09-28 11:36:38", "2024-09-28 15:06:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7624", "2550", "عملیات توسط Async Request کامل شد", "2024-09-28 11:34:31", "2024-09-28 15:04:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7623", "2550", "عملیات توسط Async Request شروع شد", "2024-09-28 11:34:31", "2024-09-28 15:04:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7621", "2549", "عملیات توسط Async Request شروع شد", "2024-09-28 11:34:31", "2024-09-28 15:04:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7618", "2550", "ایجاد فعالیت", "2024-09-28 11:34:30", "2024-09-28 15:04:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7605", "2544", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:29:58", "2024-09-28 14:59:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7606", "2544", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:29:58", "2024-09-28 14:59:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7607", "2545", "ایجاد فعالیت", "2024-09-28 11:30:25", "2024-09-28 15:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7608", "2545", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:30:59", "2024-09-28 15:00:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7609", "2545", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:30:59", "2024-09-28 15:00:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7610", "2546", "ایجاد فعالیت", "2024-09-28 11:31:39", "2024-09-28 15:01:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7611", "2546", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:32:00", "2024-09-28 15:02:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7612", "2546", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:32:00", "2024-09-28 15:02:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7613", "2547", "ایجاد فعالیت", "2024-09-28 11:33:50", "2024-09-28 15:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("7614", "2547", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:34:00", "2024-09-28 15:04:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7615", "2547", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:34:00", "2024-09-28 15:04:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7622", "2549", "عملیات توسط Async Request کامل شد", "2024-09-28 11:34:31", "2024-09-28 15:04:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7620", "2548", "عملیات توسط Async Request کامل شد", "2024-09-28 11:34:31", "2024-09-28 15:04:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7619", "2548", "عملیات توسط Async Request شروع شد", "2024-09-28 11:34:31", "2024-09-28 15:04:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7617", "2549", "ایجاد فعالیت", "2024-09-28 11:34:18", "2024-09-28 15:04:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7616", "2548", "ایجاد فعالیت", "2024-09-28 11:34:18", "2024-09-28 15:04:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7604", "2544", "ایجاد فعالیت", "2024-09-28 11:29:38", "2024-09-28 14:59:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7603", "2543", "عملیات توسط Async Request کامل شد", "2024-09-28 11:28:21", "2024-09-28 14:58:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7598", "2542", "ایجاد فعالیت", "2024-09-28 11:25:06", "2024-09-28 14:55:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7599", "2542", "عملیات توسط Async Request شروع شد", "2024-09-28 11:25:08", "2024-09-28 14:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7600", "2542", "عملیات توسط Async Request کامل شد", "2024-09-28 11:25:08", "2024-09-28 14:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7601", "2543", "ایجاد فعالیت", "2024-09-28 11:28:02", "2024-09-28 14:58:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7602", "2543", "عملیات توسط Async Request شروع شد", "2024-09-28 11:28:21", "2024-09-28 14:58:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7597", "2541", "عملیات توسط Async Request کامل شد", "2024-09-28 11:24:07", "2024-09-28 14:54:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7596", "2541", "عملیات توسط Async Request شروع شد", "2024-09-28 11:24:07", "2024-09-28 14:54:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7595", "2540", "عملیات توسط Async Request کامل شد", "2024-09-28 11:24:07", "2024-09-28 14:54:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7592", "2540", "ایجاد فعالیت", "2024-09-28 11:24:06", "2024-09-28 14:54:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7589", "2539", "ایجاد فعالیت", "2024-09-28 11:21:32", "2024-09-28 14:51:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7587", "2538", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:18:00", "2024-09-28 14:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7585", "2537", "عملیات توسط Async Request کامل شد", "2024-09-28 11:16:47", "2024-09-28 14:46:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7594", "2540", "عملیات توسط Async Request شروع شد", "2024-09-28 11:24:07", "2024-09-28 14:54:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7593", "2541", "ایجاد فعالیت", "2024-09-28 11:24:06", "2024-09-28 14:54:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7591", "2539", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:22:00", "2024-09-28 14:52:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7590", "2539", "عملیات توسط WP Cron شروع شد", "2024-09-28 11:22:00", "2024-09-28 14:52:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7588", "2538", "عملیات توسط WP Cron کامل شد", "2024-09-28 11:18:00", "2024-09-28 14:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7586", "2538", "ایجاد فعالیت", "2024-09-28 11:17:54", "2024-09-28 14:47:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("7584", "2537", "عملیات توسط Async Request شروع شد", "2024-09-28 11:16:47", "2024-09-28 14:46:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7583", "2537", "ایجاد فعالیت", "2024-09-28 11:16:17", "2024-09-28 14:46:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7582", "2536", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-28 11:12:34", "2024-09-28 14:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7581", "2536", "عملیات توسط Async Request شروع شد", "2024-09-28 11:12:34", "2024-09-28 14:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7576", "2534", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:43:59", "2024-09-28 14:13:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7577", "2535", "ایجاد فعالیت", "2024-09-28 11:10:22", "2024-09-28 14:40:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7578", "2535", "عملیات توسط Async Request شروع شد", "2024-09-28 11:11:33", "2024-09-28 14:41:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7579", "2535", "عملیات توسط Async Request کامل شد", "2024-09-28 11:11:33", "2024-09-28 14:41:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7580", "2536", "ایجاد فعالیت", "2024-09-28 11:11:34", "2024-09-28 14:41:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7575", "2534", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:43:59", "2024-09-28 14:13:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7574", "2534", "ایجاد فعالیت", "2024-09-28 10:43:27", "2024-09-28 14:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7569", "2532", "عملیات توسط Async Request شروع شد", "2024-09-28 10:36:58", "2024-09-28 14:06:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7570", "2532", "عملیات توسط Async Request کامل شد", "2024-09-28 10:36:58", "2024-09-28 14:06:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7571", "2533", "ایجاد فعالیت", "2024-09-28 10:43:17", "2024-09-28 14:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7572", "2533", "عملیات توسط Async Request شروع شد", "2024-09-28 10:43:17", "2024-09-28 14:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7573", "2533", "عملیات توسط Async Request کامل شد", "2024-09-28 10:43:17", "2024-09-28 14:13:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7568", "2532", "ایجاد فعالیت", "2024-09-28 10:36:20", "2024-09-28 14:06:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7567", "2531", "عملیات توسط Async Request کامل شد", "2024-09-28 10:32:48", "2024-09-28 14:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7566", "2531", "عملیات توسط Async Request شروع شد", "2024-09-28 10:32:48", "2024-09-28 14:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7561", "2529", "عملیات توسط Async Request کامل شد", "2024-09-28 10:27:38", "2024-09-28 13:57:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7562", "2530", "ایجاد فعالیت", "2024-09-28 10:27:54", "2024-09-28 13:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("7563", "2530", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:28:04", "2024-09-28 13:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7564", "2530", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:28:04", "2024-09-28 13:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7565", "2531", "ایجاد فعالیت", "2024-09-28 10:32:35", "2024-09-28 14:02:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7560", "2529", "عملیات توسط Async Request شروع شد", "2024-09-28 10:27:38", "2024-09-28 13:57:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7557", "2529", "ایجاد فعالیت", "2024-09-28 10:27:29", "2024-09-28 13:57:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7555", "2527", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7550", "2525", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7551", "2525", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7552", "2526", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7559", "2528", "عملیات توسط Async Request کامل شد", "2024-09-28 10:27:38", "2024-09-28 13:57:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7558", "2528", "عملیات توسط Async Request شروع شد", "2024-09-28 10:27:38", "2024-09-28 13:57:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7556", "2528", "ایجاد فعالیت", "2024-09-28 10:27:10", "2024-09-28 13:57:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7554", "2527", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7553", "2526", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7549", "2524", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7548", "2524", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7547", "2523", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7543", "2521", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7544", "2522", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7545", "2522", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7546", "2523", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7542", "2521", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7541", "2520", "عملیات توسط Async Request کامل شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7540", "2520", "عملیات توسط Async Request شروع شد", "2024-09-28 10:26:37", "2024-09-28 13:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7532", "2520", "ایجاد فعالیت", "2024-09-28 10:26:18", "2024-09-28 13:56:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7533", "2521", "ایجاد فعالیت", "2024-09-28 10:26:23", "2024-09-28 13:56:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7534", "2522", "ایجاد فعالیت", "2024-09-28 10:26:26", "2024-09-28 13:56:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("7535", "2523", "ایجاد فعالیت", "2024-09-28 10:26:29", "2024-09-28 13:56:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7536", "2524", "ایجاد فعالیت", "2024-09-28 10:26:31", "2024-09-28 13:56:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7537", "2525", "ایجاد فعالیت", "2024-09-28 10:26:34", "2024-09-28 13:56:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7538", "2526", "ایجاد فعالیت", "2024-09-28 10:26:34", "2024-09-28 13:56:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7539", "2527", "ایجاد فعالیت", "2024-09-28 10:26:36", "2024-09-28 13:56:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7531", "2519", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7530", "2519", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7529", "2518", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7528", "2518", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7527", "2517", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7516", "2514", "عملیات توسط Async Request کامل شد", "2024-09-28 10:24:35", "2024-09-28 13:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7517", "2515", "ایجاد فعالیت", "2024-09-28 10:24:43", "2024-09-28 13:54:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7518", "2516", "ایجاد فعالیت", "2024-09-28 10:24:44", "2024-09-28 13:54:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7519", "2517", "ایجاد فعالیت", "2024-09-28 10:24:45", "2024-09-28 13:54:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7520", "2518", "ایجاد فعالیت", "2024-09-28 10:24:45", "2024-09-28 13:54:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7521", "2519", "ایجاد فعالیت", "2024-09-28 10:24:45", "2024-09-28 13:54:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7522", "2515", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7523", "2515", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7524", "2516", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7525", "2516", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7526", "2517", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:24:58", "2024-09-28 13:54:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7515", "2514", "عملیات توسط Async Request شروع شد", "2024-09-28 10:24:35", "2024-09-28 13:54:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7514", "2514", "ایجاد فعالیت", "2024-09-28 10:24:06", "2024-09-28 13:54:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7513", "2513", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7512", "2513", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7511", "2512", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7496", "2508", "ایجاد فعالیت", "2024-09-28 10:21:46", "2024-09-28 13:51:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7497", "2508", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:21:58", "2024-09-28 13:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7498", "2508", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:21:58", "2024-09-28 13:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7499", "2509", "ایجاد فعالیت", "2024-09-28 10:22:31", "2024-09-28 13:52:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7500", "2510", "ایجاد فعالیت", "2024-09-28 10:22:31", "2024-09-28 13:52:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7501", "2511", "ایجاد فعالیت", "2024-09-28 10:22:32", "2024-09-28 13:52:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7502", "2512", "ایجاد فعالیت", "2024-09-28 10:22:32", "2024-09-28 13:52:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7503", "2513", "ایجاد فعالیت", "2024-09-28 10:22:32", "2024-09-28 13:52:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7504", "2509", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7505", "2509", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7506", "2510", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7507", "2510", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7508", "2511", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7509", "2511", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7510", "2512", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:22:58", "2024-09-28 13:52:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7495", "2507", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:19:58", "2024-09-28 13:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7494", "2507", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:19:58", "2024-09-28 13:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7493", "2506", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:19:58", "2024-09-28 13:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7492", "2506", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:19:58", "2024-09-28 13:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7489", "2507", "ایجاد فعالیت", "2024-09-28 10:19:55", "2024-09-28 13:49:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7484", "2504", "ایجاد فعالیت", "2024-09-28 10:19:05", "2024-09-28 13:49:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7485", "2504", "عملیات توسط Async Request شروع شد", "2024-09-28 10:19:27", "2024-09-28 13:49:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7486", "2504", "عملیات توسط Async Request کامل شد", "2024-09-28 10:19:27", "2024-09-28 13:49:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7491", "2505", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:19:58", "2024-09-28 13:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7490", "2505", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:19:58", "2024-09-28 13:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7488", "2506", "ایجاد فعالیت", "2024-09-28 10:19:45", "2024-09-28 13:49:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7487", "2505", "ایجاد فعالیت", "2024-09-28 10:19:45", "2024-09-28 13:49:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7483", "2503", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:18:58", "2024-09-28 13:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7482", "2503", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:18:58", "2024-09-28 13:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7481", "2503", "ایجاد فعالیت", "2024-09-28 10:18:55", "2024-09-28 13:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7480", "2502", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:16:00", "2024-09-28 13:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7479", "2502", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:16:00", "2024-09-28 13:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7466", "2498", "ایجاد فعالیت", "2024-09-28 10:13:27", "2024-09-28 13:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7467", "2498", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:14:01", "2024-09-28 13:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7468", "2498", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:14:01", "2024-09-28 13:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7469", "2499", "ایجاد فعالیت", "2024-09-28 10:14:59", "2024-09-28 13:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7470", "2499", "عملیات توسط Async Request شروع شد", "2024-09-28 10:15:20", "2024-09-28 13:45:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7471", "2499", "عملیات توسط Async Request کامل شد", "2024-09-28 10:15:20", "2024-09-28 13:45:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7472", "2500", "ایجاد فعالیت", "2024-09-28 10:15:42", "2024-09-28 13:45:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7473", "2501", "ایجاد فعالیت", "2024-09-28 10:15:42", "2024-09-28 13:45:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7474", "2502", "ایجاد فعالیت", "2024-09-28 10:15:43", "2024-09-28 13:45:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7475", "2500", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:16:00", "2024-09-28 13:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7476", "2500", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:16:00", "2024-09-28 13:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7477", "2501", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:16:00", "2024-09-28 13:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7478", "2501", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:16:00", "2024-09-28 13:46:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7465", "2497", "عملیات توسط Async Request کامل شد", "2024-09-28 10:13:18", "2024-09-28 13:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7464", "2497", "عملیات توسط Async Request شروع شد", "2024-09-28 10:13:18", "2024-09-28 13:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7463", "2497", "ایجاد فعالیت", "2024-09-28 10:13:06", "2024-09-28 13:43:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7461", "2496", "عملیات توسط Async Request شروع شد", "2024-09-28 10:10:07", "2024-09-28 13:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7459", "2495", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:09:58", "2024-09-28 13:39:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7456", "2496", "ایجاد فعالیت", "2024-09-28 10:09:58", "2024-09-28 13:39:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7452", "2493", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:08:58", "2024-09-28 13:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7453", "2493", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:08:58", "2024-09-28 13:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7462", "2496", "عملیات توسط Async Request کامل شد", "2024-09-28 10:10:07", "2024-09-28 13:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7460", "2495", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:09:58", "2024-09-28 13:39:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7458", "2494", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:09:58", "2024-09-28 13:39:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7457", "2494", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:09:58", "2024-09-28 13:39:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7455", "2495", "ایجاد فعالیت", "2024-09-28 10:09:33", "2024-09-28 13:39:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7454", "2494", "ایجاد فعالیت", "2024-09-28 10:09:33", "2024-09-28 13:39:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7451", "2492", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:08:58", "2024-09-28 13:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7450", "2492", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:08:58", "2024-09-28 13:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7449", "2493", "ایجاد فعالیت", "2024-09-28 10:08:27", "2024-09-28 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7448", "2492", "ایجاد فعالیت", "2024-09-28 10:08:20", "2024-09-28 13:38:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7446", "2491", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:06:00", "2024-09-28 13:36:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7444", "2490", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:06:00", "2024-09-28 13:36:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7442", "2489", "عملیات توسط WP Cron شروع شد", "2024-09-28 10:05:59", "2024-09-28 13:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7439", "2489", "ایجاد فعالیت", "2024-09-28 10:05:50", "2024-09-28 13:35:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("7437", "2488", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:58:00", "2024-09-28 13:28:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7428", "2485", "عملیات توسط Async Request شروع شد", "2024-09-28 09:55:31", "2024-09-28 13:25:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7429", "2485", "عملیات توسط Async Request کامل شد", "2024-09-28 09:55:32", "2024-09-28 13:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7430", "2486", "ایجاد فعالیت", "2024-09-28 09:55:32", "2024-09-28 13:25:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7431", "2487", "ایجاد فعالیت", "2024-09-28 09:55:35", "2024-09-28 13:25:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7432", "2486", "عملیات توسط Async Request شروع شد", "2024-09-28 09:55:37", "2024-09-28 13:25:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7433", "2486", "عملیات توسط Async Request کامل شد", "2024-09-28 09:55:37", "2024-09-28 13:25:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7434", "2487", "عملیات توسط Async Request شروع شد", "2024-09-28 09:55:37", "2024-09-28 13:25:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7447", "2491", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:06:00", "2024-09-28 13:36:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7445", "2490", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:06:00", "2024-09-28 13:36:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7443", "2489", "عملیات توسط WP Cron کامل شد", "2024-09-28 10:05:59", "2024-09-28 13:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7441", "2491", "ایجاد فعالیت", "2024-09-28 10:05:51", "2024-09-28 13:35:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("7440", "2490", "ایجاد فعالیت", "2024-09-28 10:05:50", "2024-09-28 13:35:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("7438", "2488", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:58:00", "2024-09-28 13:28:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7436", "2488", "ایجاد فعالیت", "2024-09-28 09:57:46", "2024-09-28 13:27:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7435", "2487", "عملیات توسط Async Request کامل شد", "2024-09-28 09:55:37", "2024-09-28 13:25:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7427", "2485", "ایجاد فعالیت", "2024-09-28 09:55:21", "2024-09-28 13:25:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7426", "2484", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:50:58", "2024-09-28 13:20:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7423", "2483", "عملیات توسط Async Request کامل شد", "2024-09-28 09:50:25", "2024-09-28 13:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7424", "2484", "ایجاد فعالیت", "2024-09-28 09:50:40", "2024-09-28 13:20:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7425", "2484", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:50:58", "2024-09-28 13:20:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7422", "2483", "عملیات توسط Async Request شروع شد", "2024-09-28 09:50:25", "2024-09-28 13:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7421", "2482", "عملیات توسط Async Request کامل شد", "2024-09-28 09:50:25", "2024-09-28 13:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7419", "2481", "عملیات توسط Async Request کامل شد", "2024-09-28 09:50:25", "2024-09-28 13:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7420", "2482", "عملیات توسط Async Request شروع شد", "2024-09-28 09:50:25", "2024-09-28 13:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7418", "2481", "عملیات توسط Async Request شروع شد", "2024-09-28 09:50:25", "2024-09-28 13:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7417", "2483", "ایجاد فعالیت", "2024-09-28 09:50:18", "2024-09-28 13:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7416", "2482", "ایجاد فعالیت", "2024-09-28 09:50:17", "2024-09-28 13:20:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7415", "2481", "ایجاد فعالیت", "2024-09-28 09:50:17", "2024-09-28 13:20:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7414", "2480", "عملیات توسط Async Request کامل شد", "2024-09-28 09:49:22", "2024-09-28 13:19:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7413", "2480", "عملیات توسط Async Request شروع شد", "2024-09-28 09:49:22", "2024-09-28 13:19:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7412", "2480", "ایجاد فعالیت", "2024-09-28 09:49:07", "2024-09-28 13:19:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7409", "2479", "ایجاد فعالیت", "2024-09-28 09:48:42", "2024-09-28 13:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7407", "2478", "عملیات توسط Async Request شروع شد", "2024-09-28 09:46:13", "2024-09-28 13:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7405", "2477", "عملیات توسط Async Request شروع شد", "2024-09-28 09:46:13", "2024-09-28 13:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7403", "2476", "عملیات توسط Async Request شروع شد", "2024-09-28 09:46:13", "2024-09-28 13:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7400", "2476", "ایجاد فعالیت", "2024-09-28 09:46:06", "2024-09-28 13:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7386", "2472", "ایجاد فعالیت", "2024-09-28 09:39:09", "2024-09-28 13:09:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("7387", "2471", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:40:01", "2024-09-28 13:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7388", "2471", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:40:01", "2024-09-28 13:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7389", "2472", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:40:01", "2024-09-28 13:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7390", "2472", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:40:01", "2024-09-28 13:10:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7391", "2473", "ایجاد فعالیت", "2024-09-28 09:45:00", "2024-09-28 13:15:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7392", "2474", "ایجاد فعالیت", "2024-09-28 09:45:00", "2024-09-28 13:15:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7393", "2475", "ایجاد فعالیت", "2024-09-28 09:45:00", "2024-09-28 13:15:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7394", "2473", "عملیات توسط Async Request شروع شد", "2024-09-28 09:45:09", "2024-09-28 13:15:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("7395", "2473", "عملیات توسط Async Request کامل شد", "2024-09-28 09:45:10", "2024-09-28 13:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7396", "2474", "عملیات توسط Async Request شروع شد", "2024-09-28 09:45:10", "2024-09-28 13:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7397", "2474", "عملیات توسط Async Request کامل شد", "2024-09-28 09:45:10", "2024-09-28 13:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7411", "2479", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:48:58", "2024-09-28 13:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7410", "2479", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:48:58", "2024-09-28 13:18:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7408", "2478", "عملیات توسط Async Request کامل شد", "2024-09-28 09:46:13", "2024-09-28 13:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7406", "2477", "عملیات توسط Async Request کامل شد", "2024-09-28 09:46:13", "2024-09-28 13:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7404", "2476", "عملیات توسط Async Request کامل شد", "2024-09-28 09:46:13", "2024-09-28 13:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7402", "2478", "ایجاد فعالیت", "2024-09-28 09:46:07", "2024-09-28 13:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7401", "2477", "ایجاد فعالیت", "2024-09-28 09:46:06", "2024-09-28 13:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7399", "2475", "عملیات توسط Async Request کامل شد", "2024-09-28 09:45:10", "2024-09-28 13:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7398", "2475", "عملیات توسط Async Request شروع شد", "2024-09-28 09:45:10", "2024-09-28 13:15:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7385", "2471", "ایجاد فعالیت", "2024-09-28 09:39:02", "2024-09-28 13:09:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7384", "2470", "عملیات توسط Async Request کامل شد", "2024-09-28 09:33:42", "2024-09-28 13:03:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7382", "2469", "عملیات توسط Async Request کامل شد", "2024-09-28 09:33:42", "2024-09-28 13:03:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7383", "2470", "عملیات توسط Async Request شروع شد", "2024-09-28 09:33:42", "2024-09-28 13:03:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7381", "2469", "عملیات توسط Async Request شروع شد", "2024-09-28 09:33:42", "2024-09-28 13:03:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7380", "2468", "عملیات توسط Async Request کامل شد", "2024-09-28 09:33:42", "2024-09-28 13:03:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7379", "2468", "عملیات توسط Async Request شروع شد", "2024-09-28 09:33:42", "2024-09-28 13:03:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7377", "2469", "ایجاد فعالیت", "2024-09-28 09:33:03", "2024-09-28 13:03:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7375", "2467", "عملیات توسط Async Request کامل شد", "2024-09-28 09:32:42", "2024-09-28 13:02:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7368", "2465", "عملیات توسط Async Request شروع شد", "2024-09-28 09:29:35", "2024-09-28 12:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7369", "2465", "عملیات توسط Async Request کامل شد", "2024-09-28 09:29:35", "2024-09-28 12:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7370", "2466", "ایجاد فعالیت", "2024-09-28 09:31:46", "2024-09-28 13:01:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7371", "2466", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:32:00", "2024-09-28 13:02:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7372", "2466", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:32:00", "2024-09-28 13:02:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7378", "2470", "ایجاد فعالیت", "2024-09-28 09:33:03", "2024-09-28 13:03:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7376", "2468", "ایجاد فعالیت", "2024-09-28 09:33:03", "2024-09-28 13:03:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7374", "2467", "عملیات توسط Async Request شروع شد", "2024-09-28 09:32:42", "2024-09-28 13:02:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7373", "2467", "ایجاد فعالیت", "2024-09-28 09:32:10", "2024-09-28 13:02:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7367", "2464", "عملیات توسط Async Request کامل شد", "2024-09-28 09:29:35", "2024-09-28 12:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7366", "2464", "عملیات توسط Async Request شروع شد", "2024-09-28 09:29:35", "2024-09-28 12:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7365", "2463", "عملیات توسط Async Request کامل شد", "2024-09-28 09:29:35", "2024-09-28 12:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7364", "2463", "عملیات توسط Async Request شروع شد", "2024-09-28 09:29:35", "2024-09-28 12:59:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7363", "2465", "ایجاد فعالیت", "2024-09-28 09:29:00", "2024-09-28 12:59:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7361", "2463", "ایجاد فعالیت", "2024-09-28 09:28:59", "2024-09-28 12:58:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7349", "2459", "ایجاد فعالیت", "2024-09-28 09:19:40", "2024-09-28 12:49:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7350", "2460", "ایجاد فعالیت", "2024-09-28 09:20:01", "2024-09-28 12:50:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7351", "2459", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:20:01", "2024-09-28 12:50:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7352", "2459", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:20:01", "2024-09-28 12:50:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7353", "2461", "ایجاد فعالیت", "2024-09-28 09:20:02", "2024-09-28 12:50:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7354", "2460", "عملیات توسط Async Request شروع شد", "2024-09-28 09:20:20", "2024-09-28 12:50:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7355", "2460", "عملیات توسط Async Request کامل شد", "2024-09-28 09:20:21", "2024-09-28 12:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7356", "2461", "عملیات توسط Async Request شروع شد", "2024-09-28 09:20:21", "2024-09-28 12:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7362", "2464", "ایجاد فعالیت", "2024-09-28 09:28:59", "2024-09-28 12:58:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7360", "2462", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:27:58", "2024-09-28 12:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7359", "2462", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:27:58", "2024-09-28 12:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7358", "2462", "ایجاد فعالیت", "2024-09-28 09:27:55", "2024-09-28 12:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7357", "2461", "عملیات توسط Async Request کامل شد", "2024-09-28 09:20:21", "2024-09-28 12:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7348", "2458", "عملیات توسط Async Request کامل شد", "2024-09-28 09:19:19", "2024-09-28 12:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7347", "2458", "عملیات توسط Async Request شروع شد", "2024-09-28 09:19:19", "2024-09-28 12:49:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7346", "2458", "ایجاد فعالیت", "2024-09-28 09:19:12", "2024-09-28 12:49:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7345", "2457", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:15:02", "2024-09-28 12:45:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7334", "2454", "ایجاد فعالیت", "2024-09-28 09:12:06", "2024-09-28 12:42:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7335", "2455", "ایجاد فعالیت", "2024-09-28 09:12:37", "2024-09-28 12:42:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7336", "2454", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:13:00", "2024-09-28 12:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7337", "2454", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:13:00", "2024-09-28 12:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7338", "2455", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:13:00", "2024-09-28 12:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7339", "2455", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:13:00", "2024-09-28 12:43:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7340", "2456", "ایجاد فعالیت", "2024-09-28 09:13:55", "2024-09-28 12:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7341", "2456", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:14:00", "2024-09-28 12:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7342", "2456", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:14:00", "2024-09-28 12:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7343", "2457", "ایجاد فعالیت", "2024-09-28 09:14:42", "2024-09-28 12:44:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7344", "2457", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:15:02", "2024-09-28 12:45:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7333", "2453", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:12:00", "2024-09-28 12:42:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7332", "2453", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:12:00", "2024-09-28 12:42:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7329", "2452", "عملیات توسط WP Cron شروع شد", "2024-09-28 09:00:17", "2024-09-28 12:30:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7330", "2452", "عملیات توسط WP Cron کامل شد", "2024-09-28 09:00:17", "2024-09-28 12:30:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("7331", "2453", "ایجاد فعالیت", "2024-09-28 09:11:58", "2024-09-28 12:41:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7328", "2452", "ایجاد فعالیت", "2024-09-28 08:59:26", "2024-09-28 12:29:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("7327", "2451", "عملیات توسط Async Request کامل شد", "2024-09-28 08:58:16", "2024-09-28 12:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7326", "2451", "عملیات توسط Async Request شروع شد", "2024-09-28 08:58:16", "2024-09-28 12:28:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7325", "2451", "ایجاد فعالیت", "2024-09-28 08:58:03", "2024-09-28 12:28:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7324", "2450", "عملیات توسط Async Request کامل شد", "2024-09-28 08:57:14", "2024-09-28 12:27:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7317", "2448", "عملیات توسط Async Request شروع شد", "2024-09-28 08:47:48", "2024-09-28 12:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7318", "2448", "عملیات توسط Async Request کامل شد", "2024-09-28 08:47:48", "2024-09-28 12:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7319", "2449", "ایجاد فعالیت", "2024-09-28 08:53:56", "2024-09-28 12:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7320", "2449", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:53:59", "2024-09-28 12:23:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7321", "2449", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:53:59", "2024-09-28 12:23:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7323", "2450", "عملیات توسط Async Request شروع شد", "2024-09-28 08:57:14", "2024-09-28 12:27:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7322", "2450", "ایجاد فعالیت", "2024-09-28 08:57:05", "2024-09-28 12:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7316", "2448", "ایجاد فعالیت", "2024-09-28 08:47:12", "2024-09-28 12:17:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7315", "2447", "عملیات توسط Async Request کامل شد", "2024-09-28 08:45:45", "2024-09-28 12:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7313", "2447", "ایجاد فعالیت", "2024-09-28 08:45:34", "2024-09-28 12:15:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7314", "2447", "عملیات توسط Async Request شروع شد", "2024-09-28 08:45:45", "2024-09-28 12:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7312", "2446", "عملیات توسط Async Request کامل شد", "2024-09-28 08:44:44", "2024-09-28 12:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7311", "2446", "عملیات توسط Async Request شروع شد", "2024-09-28 08:44:44", "2024-09-28 12:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7310", "2446", "ایجاد فعالیت", "2024-09-28 08:44:04", "2024-09-28 12:14:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7306", "2444", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:37:01", "2024-09-28 12:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7299", "2442", "عملیات توسط Async Request شروع شد", "2024-09-28 08:35:18", "2024-09-28 12:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7300", "2442", "عملیات توسط Async Request کامل شد", "2024-09-28 08:35:18", "2024-09-28 12:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7301", "2443", "ایجاد فعالیت", "2024-09-28 08:35:53", "2024-09-28 12:05:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7302", "2443", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:36:02", "2024-09-28 12:06:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7303", "2443", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:36:02", "2024-09-28 12:06:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7309", "2445", "عملیات توسط Async Request کامل شد", "2024-09-28 08:42:37", "2024-09-28 12:12:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7308", "2445", "عملیات توسط Async Request شروع شد", "2024-09-28 08:42:37", "2024-09-28 12:12:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7307", "2445", "ایجاد فعالیت", "2024-09-28 08:42:04", "2024-09-28 12:12:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7305", "2444", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:37:01", "2024-09-28 12:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7304", "2444", "ایجاد فعالیت", "2024-09-28 08:36:47", "2024-09-28 12:06:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7298", "2442", "ایجاد فعالیت", "2024-09-28 08:35:03", "2024-09-28 12:05:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7297", "2441", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:26:59", "2024-09-28 11:56:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7296", "2441", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:26:59", "2024-09-28 11:56:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7283", "2437", "ایجاد فعالیت", "2024-09-28 08:25:03", "2024-09-28 11:55:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7284", "2437", "عملیات توسط Async Request شروع شد", "2024-09-28 08:25:40", "2024-09-28 11:55:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7285", "2437", "عملیات توسط Async Request کامل شد", "2024-09-28 08:25:40", "2024-09-28 11:55:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7295", "2441", "ایجاد فعالیت", "2024-09-28 08:26:58", "2024-09-28 11:56:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7294", "2440", "عملیات توسط Async Request کامل شد", "2024-09-28 08:26:46", "2024-09-28 11:56:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7293", "2440", "عملیات توسط Async Request شروع شد", "2024-09-28 08:26:46", "2024-09-28 11:56:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7292", "2440", "ایجاد فعالیت", "2024-09-28 08:26:44", "2024-09-28 11:56:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7291", "2439", "عملیات توسط Async Request کامل شد", "2024-09-28 08:26:41", "2024-09-28 11:56:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7290", "2439", "عملیات توسط Async Request شروع شد", "2024-09-28 08:26:40", "2024-09-28 11:56:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7289", "2439", "ایجاد فعالیت", "2024-09-28 08:26:28", "2024-09-28 11:56:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7288", "2438", "عملیات توسط Async Request کامل شد", "2024-09-28 08:25:45", "2024-09-28 11:55:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7287", "2438", "عملیات توسط Async Request شروع شد", "2024-09-28 08:25:45", "2024-09-28 11:55:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7286", "2438", "ایجاد فعالیت", "2024-09-28 08:25:44", "2024-09-28 11:55:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7282", "2436", "عملیات توسط Async Request کامل شد", "2024-09-28 08:24:39", "2024-09-28 11:54:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7281", "2436", "عملیات توسط Async Request شروع شد", "2024-09-28 08:24:39", "2024-09-28 11:54:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7280", "2435", "عملیات توسط Async Request کامل شد", "2024-09-28 08:24:39", "2024-09-28 11:54:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7279", "2435", "عملیات توسط Async Request شروع شد", "2024-09-28 08:24:39", "2024-09-28 11:54:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7277", "2435", "ایجاد فعالیت", "2024-09-28 08:23:59", "2024-09-28 11:53:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7274", "2434", "ایجاد فعالیت", "2024-09-28 08:23:43", "2024-09-28 11:53:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7271", "2433", "ایجاد فعالیت", "2024-09-28 08:21:47", "2024-09-28 11:51:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7267", "2431", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:20:58", "2024-09-28 11:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7265", "2430", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:20:58", "2024-09-28 11:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7262", "2430", "ایجاد فعالیت", "2024-09-28 08:20:39", "2024-09-28 11:50:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7259", "2429", "ایجاد فعالیت", "2024-09-28 08:20:21", "2024-09-28 11:50:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7257", "2428", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:19:58", "2024-09-28 11:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7248", "2425", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:18:58", "2024-09-28 11:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7249", "2425", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:18:58", "2024-09-28 11:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7250", "2426", "ایجاد فعالیت", "2024-09-28 08:19:10", "2024-09-28 11:49:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7251", "2427", "ایجاد فعالیت", "2024-09-28 08:19:27", "2024-09-28 11:49:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7252", "2426", "عملیات توسط Async Request شروع شد", "2024-09-28 08:19:30", "2024-09-28 11:49:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7253", "2426", "عملیات توسط Async Request کامل شد", "2024-09-28 08:19:30", "2024-09-28 11:49:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7254", "2427", "عملیات توسط Async Request شروع شد", "2024-09-28 08:19:30", "2024-09-28 11:49:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7278", "2436", "ایجاد فعالیت", "2024-09-28 08:24:38", "2024-09-28 11:54:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7276", "2434", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:23:59", "2024-09-28 11:53:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7275", "2434", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:23:59", "2024-09-28 11:53:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7273", "2433", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:21:58", "2024-09-28 11:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7272", "2433", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:21:58", "2024-09-28 11:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7270", "2432", "عملیات توسط Async Request کامل شد", "2024-09-28 08:21:33", "2024-09-28 11:51:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7269", "2432", "عملیات توسط Async Request شروع شد", "2024-09-28 08:21:33", "2024-09-28 11:51:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7268", "2432", "ایجاد فعالیت", "2024-09-28 08:21:31", "2024-09-28 11:51:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("7266", "2431", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:20:58", "2024-09-28 11:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7264", "2430", "عملیات توسط WP Cron شروع شد", "2024-09-28 08:20:58", "2024-09-28 11:50:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7263", "2431", "ایجاد فعالیت", "2024-09-28 08:20:57", "2024-09-28 11:50:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7261", "2429", "عملیات توسط Async Request کامل شد", "2024-09-28 08:20:32", "2024-09-28 11:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7260", "2429", "عملیات توسط Async Request شروع شد", "2024-09-28 08:20:32", "2024-09-28 11:50:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7258", "2428", "عملیات توسط WP Cron کامل شد", "2024-09-28 08:19:58", "2024-09-28 11:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7256", "2428", "ایجاد فعالیت", "2024-09-28 08:19:54", "2024-09-28 11:49:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("7255", "2427", "عملیات توسط Async Request کامل شد", "2024-09-28 08:19:30", "2024-09-28 11:49:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7247", "2425", "ایجاد فعالیت", "2024-09-28 08:18:46", "2024-09-28 11:48:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7246", "2424", "عملیات توسط Async Request کامل شد", "2024-09-28 08:18:28", "2024-09-28 11:48:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7241", "2423", "ایجاد فعالیت", "2024-09-28 08:18:03", "2024-09-28 11:48:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7239", "2422", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7237", "2421", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7235", "2420", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7233", "2419", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7230", "2422", "ایجاد فعالیت", "2024-09-28 06:54:55", "2024-09-28 10:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7227", "2419", "ایجاد فعالیت", "2024-09-28 06:54:55", "2024-09-28 10:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7225", "2417", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7221", "2415", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7222", "2416", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7245", "2424", "عملیات توسط Async Request شروع شد", "2024-09-28 08:18:28", "2024-09-28 11:48:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7244", "2423", "عملیات توسط Async Request کامل شد", "2024-09-28 08:18:28", "2024-09-28 11:48:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7243", "2423", "عملیات توسط Async Request شروع شد", "2024-09-28 08:18:28", "2024-09-28 11:48:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7242", "2424", "ایجاد فعالیت", "2024-09-28 08:18:28", "2024-09-28 11:48:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("7240", "2422", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7238", "2421", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7236", "2420", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7234", "2419", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7232", "2418", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7231", "2418", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:54:58", "2024-09-28 10:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7229", "2421", "ایجاد فعالیت", "2024-09-28 06:54:55", "2024-09-28 10:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7228", "2420", "ایجاد فعالیت", "2024-09-28 06:54:55", "2024-09-28 10:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7226", "2418", "ایجاد فعالیت", "2024-09-28 06:54:55", "2024-09-28 10:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7224", "2417", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7223", "2416", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7220", "2415", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7219", "2414", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7218", "2414", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7214", "2412", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7215", "2412", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7216", "2413", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7217", "2413", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7213", "2411", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7212", "2411", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7211", "2410", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7210", "2410", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7208", "2409", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7204", "2407", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7205", "2407", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7206", "2408", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7207", "2408", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7209", "2409", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7203", "2406", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7201", "2405", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7199", "2404", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7197", "2403", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7195", "2402", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7193", "2401", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7191", "2400", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7189", "2399", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7187", "2398", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7181", "2395", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7182", "2396", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7183", "2396", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7184", "2397", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7202", "2406", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7200", "2405", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7198", "2404", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7196", "2403", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7194", "2402", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7192", "2401", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7190", "2400", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7188", "2399", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7186", "2398", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7185", "2397", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7180", "2395", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7179", "2394", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7178", "2394", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7176", "2393", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7170", "2390", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7171", "2390", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7172", "2391", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7173", "2391", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7177", "2393", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7175", "2392", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7174", "2392", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7169", "2389", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7168", "2389", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7165", "2387", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7166", "2388", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7167", "2388", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7164", "2387", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7163", "2386", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7160", "2385", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7161", "2385", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7162", "2386", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7159", "2384", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7158", "2384", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7155", "2382", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7156", "2383", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7157", "2383", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7154", "2382", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7153", "2381", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7152", "2381", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7150", "2380", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7148", "2379", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7142", "2376", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7143", "2376", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7144", "2377", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7145", "2377", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7151", "2380", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7149", "2379", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7147", "2378", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7146", "2378", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7141", "2375", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7140", "2375", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7139", "2374", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7137", "2373", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7131", "2370", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7132", "2371", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7133", "2371", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7134", "2372", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7138", "2374", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7136", "2373", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7135", "2372", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7130", "2370", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7129", "2369", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7128", "2369", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7126", "2368", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7124", "2367", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7120", "2365", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7121", "2365", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7127", "2368", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7125", "2367", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7123", "2366", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7122", "2366", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7119", "2364", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7118", "2364", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7117", "2363", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7111", "2360", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7112", "2361", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7113", "2361", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7114", "2362", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7116", "2363", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7115", "2362", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7110", "2360", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7109", "2359", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7108", "2359", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7106", "2358", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7102", "2356", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7103", "2356", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7107", "2358", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7105", "2357", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7104", "2357", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7101", "2355", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7100", "2355", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7099", "2354", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7097", "2353", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7095", "2352", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7093", "2351", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7091", "2350", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7089", "2349", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7083", "2346", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7084", "2347", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7085", "2347", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7086", "2348", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7098", "2354", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7096", "2353", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7094", "2352", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7092", "2351", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7090", "2350", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7088", "2349", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7087", "2348", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7082", "2346", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7081", "2345", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7078", "2344", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7079", "2344", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7080", "2345", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7077", "2343", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7076", "2343", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7075", "2342", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7073", "2341", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7071", "2340", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7065", "2337", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7066", "2338", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7067", "2338", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7068", "2339", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7074", "2342", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7072", "2341", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7070", "2340", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7069", "2339", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7064", "2337", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7063", "2336", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7062", "2336", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7060", "2335", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7058", "2334", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7056", "2333", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7054", "2332", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7052", "2331", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7050", "2330", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7046", "2328", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7047", "2328", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7061", "2335", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7059", "2334", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7057", "2333", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7055", "2332", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7053", "2331", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7051", "2330", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7049", "2329", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7048", "2329", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7045", "2327", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7044", "2327", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7043", "2326", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7034", "2416", "ایجاد فعالیت", "2024-09-28 06:50:23", "2024-09-28 10:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7035", "2417", "ایجاد فعالیت", "2024-09-28 06:50:23", "2024-09-28 10:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7036", "2323", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7037", "2323", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7038", "2324", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7039", "2324", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7040", "2325", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7041", "2325", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7042", "2326", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:51:00", "2024-09-28 10:21:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7033", "2415", "ایجاد فعالیت", "2024-09-28 06:50:23", "2024-09-28 10:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7032", "2414", "ایجاد فعالیت", "2024-09-28 06:50:23", "2024-09-28 10:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7031", "2413", "ایجاد فعالیت", "2024-09-28 06:50:23", "2024-09-28 10:20:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7030", "2412", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7029", "2411", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7028", "2410", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7027", "2409", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7026", "2408", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7025", "2407", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7024", "2406", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7023", "2405", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7022", "2404", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7021", "2403", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7020", "2402", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7019", "2401", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7018", "2400", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7017", "2399", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7016", "2398", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7015", "2397", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7014", "2396", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7013", "2395", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7012", "2394", "ایجاد فعالیت", "2024-09-28 06:50:22", "2024-09-28 10:20:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7011", "2393", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7010", "2392", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7009", "2391", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7008", "2390", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7007", "2389", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7006", "2388", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7005", "2387", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6941", "2323", "ایجاد فعالیت", "2024-09-28 06:50:17", "2024-09-28 10:20:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6942", "2324", "ایجاد فعالیت", "2024-09-28 06:50:17", "2024-09-28 10:20:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6943", "2325", "ایجاد فعالیت", "2024-09-28 06:50:17", "2024-09-28 10:20:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6944", "2326", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6945", "2327", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6946", "2328", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6947", "2329", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6948", "2330", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6949", "2331", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6950", "2332", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6951", "2333", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6952", "2334", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6953", "2335", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6954", "2336", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6955", "2337", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6956", "2338", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6957", "2339", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6958", "2340", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6959", "2341", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6960", "2342", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6961", "2343", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6962", "2344", "ایجاد فعالیت", "2024-09-28 06:50:18", "2024-09-28 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6963", "2345", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6964", "2346", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6965", "2347", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6966", "2348", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6967", "2349", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6968", "2350", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6969", "2351", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6970", "2352", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6971", "2353", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6972", "2354", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6973", "2355", "ایجاد فعالیت", "2024-09-28 06:50:19", "2024-09-28 10:20:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6974", "2356", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6975", "2357", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6976", "2358", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6977", "2359", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6978", "2360", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6979", "2361", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6980", "2362", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6981", "2363", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6982", "2364", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6983", "2365", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6984", "2366", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6985", "2367", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6986", "2368", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6987", "2369", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6988", "2370", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6989", "2371", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6990", "2372", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6991", "2373", "ایجاد فعالیت", "2024-09-28 06:50:20", "2024-09-28 10:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6992", "2374", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6993", "2375", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6994", "2376", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6995", "2377", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6996", "2378", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6997", "2379", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6998", "2380", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6999", "2381", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7000", "2382", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7001", "2383", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7002", "2384", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7003", "2385", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7004", "2386", "ایجاد فعالیت", "2024-09-28 06:50:21", "2024-09-28 10:20:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6940", "2322", "عملیات توسط WP Cron کامل شد", "2024-09-28 06:16:16", "2024-09-28 09:46:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("6939", "2322", "عملیات توسط WP Cron شروع شد", "2024-09-28 06:16:15", "2024-09-28 09:46:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6938", "2322", "ایجاد فعالیت", "2024-09-28 06:14:55", "2024-09-28 09:44:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6937", "2321", "عملیات توسط Async Request کامل شد", "2024-09-28 06:06:56", "2024-09-28 09:36:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6934", "2320", "ایجاد فعالیت", "2024-09-27 15:03:29", "2024-09-27 18:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6930", "2319", "عملیات توسط Async Request شروع شد", "2024-09-26 13:31:46", "2024-09-26 17:01:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6926", "2315", "عملیات توسط Async Request شروع شد", "2024-09-26 11:25:39", "2024-09-26 14:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6924", "2317", "عملیات توسط WP Cron شروع شد", "2024-09-25 12:45:02", "2024-09-25 16:15:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6922", "2316", "عملیات توسط WP Cron کامل شد", "2024-09-25 12:37:05", "2024-09-25 16:07:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6911", "2313", "ایجاد فعالیت", "2024-09-25 09:42:42", "2024-09-25 13:12:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6912", "2313", "عملیات توسط Async Request شروع شد", "2024-09-25 09:42:54", "2024-09-25 13:12:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6913", "2313", "عملیات توسط Async Request کامل شد", "2024-09-25 09:42:54", "2024-09-25 13:12:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6914", "2314", "ایجاد فعالیت", "2024-09-25 09:50:28", "2024-09-25 13:20:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6915", "2314", "عملیات توسط WP Cron شروع شد", "2024-09-25 09:51:50", "2024-09-25 13:21:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6916", "2314", "عملیات توسط WP Cron کامل شد", "2024-09-25 09:51:50", "2024-09-25 13:21:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6917", "2302", "عملیات توسط Async Request شروع شد", "2024-09-25 11:25:17", "2024-09-25 14:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6936", "2321", "عملیات توسط Async Request شروع شد", "2024-09-28 06:06:56", "2024-09-28 09:36:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6935", "2321", "ایجاد فعالیت", "2024-09-28 06:06:16", "2024-09-28 09:36:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("6933", "2318", "عملیات توسط WP Cron کامل شد", "2024-09-27 15:03:29", "2024-09-27 18:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6932", "2318", "عملیات توسط WP Cron شروع شد", "2024-09-27 15:03:29", "2024-09-27 18:33:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6931", "2319", "عملیات توسط Async Request کامل شد", "2024-09-26 13:31:46", "2024-09-26 17:01:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6929", "2319", "ایجاد فعالیت", "2024-09-26 13:31:29", "2024-09-26 17:01:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6928", "2318", "ایجاد فعالیت", "2024-09-26 11:25:39", "2024-09-26 14:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6927", "2315", "عملیات توسط Async Request کامل شد", "2024-09-26 11:25:39", "2024-09-26 14:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6925", "2317", "عملیات توسط WP Cron کامل شد", "2024-09-25 12:45:02", "2024-09-25 16:15:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6923", "2317", "ایجاد فعالیت", "2024-09-25 12:44:22", "2024-09-25 16:14:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("6921", "2316", "عملیات توسط WP Cron شروع شد", "2024-09-25 12:37:05", "2024-09-25 16:07:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6920", "2316", "ایجاد فعالیت", "2024-09-25 12:36:02", "2024-09-25 16:06:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6919", "2315", "ایجاد فعالیت", "2024-09-25 11:25:17", "2024-09-25 14:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6918", "2302", "عملیات توسط Async Request کامل شد", "2024-09-25 11:25:17", "2024-09-25 14:55:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6910", "2312", "عملیات توسط Async Request کامل شد", "2024-09-25 09:40:52", "2024-09-25 13:10:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6909", "2312", "عملیات توسط Async Request شروع شد", "2024-09-25 09:40:52", "2024-09-25 13:10:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6907", "2311", "عملیات توسط WP Cron کامل شد", "2024-09-25 09:30:23", "2024-09-25 13:00:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("6902", "2309", "عملیات توسط Async Request کامل شد", "2024-09-25 08:55:41", "2024-09-25 12:25:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6903", "2310", "عملیات توسط Async Request شروع شد", "2024-09-25 08:55:41", "2024-09-25 12:25:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6904", "2310", "عملیات توسط Async Request کامل شد", "2024-09-25 08:55:41", "2024-09-25 12:25:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6908", "2312", "ایجاد فعالیت", "2024-09-25 09:40:41", "2024-09-25 13:10:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6906", "2311", "عملیات توسط WP Cron شروع شد", "2024-09-25 09:30:23", "2024-09-25 13:00:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("6905", "2311", "ایجاد فعالیت", "2024-09-25 09:29:42", "2024-09-25 12:59:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6901", "2309", "عملیات توسط Async Request شروع شد", "2024-09-25 08:55:41", "2024-09-25 12:25:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6900", "2308", "عملیات توسط Async Request کامل شد", "2024-09-25 08:55:41", "2024-09-25 12:25:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6895", "2307", "عملیات توسط Async Request کامل شد", "2024-09-25 08:54:33", "2024-09-25 12:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6896", "2308", "ایجاد فعالیت", "2024-09-25 08:55:03", "2024-09-25 12:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6897", "2309", "ایجاد فعالیت", "2024-09-25 08:55:03", "2024-09-25 12:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6898", "2310", "ایجاد فعالیت", "2024-09-25 08:55:03", "2024-09-25 12:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6899", "2308", "عملیات توسط Async Request شروع شد", "2024-09-25 08:55:41", "2024-09-25 12:25:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6894", "2307", "عملیات توسط Async Request شروع شد", "2024-09-25 08:54:33", "2024-09-25 12:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6893", "2306", "عملیات توسط Async Request کامل شد", "2024-09-25 08:54:33", "2024-09-25 12:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6892", "2306", "عملیات توسط Async Request شروع شد", "2024-09-25 08:54:33", "2024-09-25 12:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6886", "2304", "عملیات توسط WP Cron کامل شد", "2024-09-25 08:53:58", "2024-09-25 12:23:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6887", "2305", "ایجاد فعالیت", "2024-09-25 08:54:04", "2024-09-25 12:24:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6888", "2306", "ایجاد فعالیت", "2024-09-25 08:54:04", "2024-09-25 12:24:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6889", "2307", "ایجاد فعالیت", "2024-09-25 08:54:07", "2024-09-25 12:24:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6890", "2305", "عملیات توسط Async Request شروع شد", "2024-09-25 08:54:33", "2024-09-25 12:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6891", "2305", "عملیات توسط Async Request کامل شد", "2024-09-25 08:54:33", "2024-09-25 12:24:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6885", "2304", "عملیات توسط WP Cron شروع شد", "2024-09-25 08:53:58", "2024-09-25 12:23:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6884", "2304", "ایجاد فعالیت", "2024-09-25 08:53:41", "2024-09-25 12:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6105", "2035", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6106", "2036", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6107", "2036", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6108", "2037", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6109", "2037", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6110", "2038", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:09", "2024-09-10 15:52:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6111", "2038", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6112", "2039", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6113", "2039", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6114", "2040", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6115", "2040", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6116", "2041", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6117", "2041", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6118", "2042", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6119", "2042", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6120", "2043", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6121", "2043", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6122", "2044", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6123", "2044", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6124", "2045", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6125", "2045", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6126", "2046", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6127", "2046", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6128", "2047", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6129", "2047", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6130", "2048", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6131", "2048", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6132", "2049", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6133", "2049", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6134", "2050", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6135", "2050", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6136", "2051", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6137", "2051", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6138", "2052", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6139", "2052", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6140", "2053", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6141", "2053", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6142", "2054", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6143", "2054", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6144", "2055", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6145", "2055", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6146", "2056", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6147", "2056", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6148", "2057", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6149", "2057", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6150", "2058", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6151", "2058", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6152", "2059", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6153", "2059", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6154", "2060", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6155", "2060", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6156", "2061", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6157", "2061", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:22:10", "2024-09-10 15:52:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6158", "2062", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6159", "2063", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6160", "2064", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6161", "2065", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6162", "2066", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6163", "2067", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6164", "2068", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6165", "2069", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6166", "2070", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6167", "2071", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6168", "2072", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6169", "2073", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6170", "2074", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6171", "2075", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6172", "2076", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6173", "2077", "ایجاد فعالیت", "2024-09-10 12:22:18", "2024-09-10 15:52:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6174", "2078", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6175", "2079", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6176", "2080", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6177", "2081", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6178", "2082", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6179", "2083", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6180", "2084", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6181", "2085", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6182", "2086", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6183", "2087", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6184", "2088", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6185", "2089", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6186", "2090", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6187", "2091", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6188", "2092", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6189", "2093", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6190", "2094", "ایجاد فعالیت", "2024-09-10 12:22:19", "2024-09-10 15:52:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6191", "2095", "ایجاد فعالیت", "2024-09-10 12:22:33", "2024-09-10 15:52:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6192", "2096", "ایجاد فعالیت", "2024-09-10 12:22:34", "2024-09-10 15:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6193", "2097", "ایجاد فعالیت", "2024-09-10 12:22:34", "2024-09-10 15:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6194", "2098", "ایجاد فعالیت", "2024-09-10 12:22:34", "2024-09-10 15:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6195", "2099", "ایجاد فعالیت", "2024-09-10 12:22:34", "2024-09-10 15:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6196", "2100", "ایجاد فعالیت", "2024-09-10 12:22:34", "2024-09-10 15:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6197", "2101", "ایجاد فعالیت", "2024-09-10 12:22:34", "2024-09-10 15:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6198", "2102", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6199", "2103", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6200", "2104", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6201", "2105", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6202", "2106", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6203", "2107", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6204", "2108", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6205", "2109", "ایجاد فعالیت", "2024-09-10 12:22:35", "2024-09-10 15:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("6206", "2110", "ایجاد فعالیت", "2024-09-10 12:22:36", "2024-09-10 15:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("6207", "2111", "ایجاد فعالیت", "2024-09-10 12:22:36", "2024-09-10 15:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("6208", "2112", "ایجاد فعالیت", "2024-09-10 12:22:36", "2024-09-10 15:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("6209", "2113", "ایجاد فعالیت", "2024-09-10 12:22:36", "2024-09-10 15:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("6210", "2114", "ایجاد فعالیت", "2024-09-10 12:22:36", "2024-09-10 15:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("6211", "2115", "ایجاد فعالیت", "2024-09-10 12:22:36", "2024-09-10 15:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("6212", "2116", "ایجاد فعالیت", "2024-09-10 12:22:37", "2024-09-10 15:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6213", "2117", "ایجاد فعالیت", "2024-09-10 12:22:37", "2024-09-10 15:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6214", "2118", "ایجاد فعالیت", "2024-09-10 12:22:37", "2024-09-10 15:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6215", "2119", "ایجاد فعالیت", "2024-09-10 12:22:37", "2024-09-10 15:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6216", "2120", "ایجاد فعالیت", "2024-09-10 12:22:37", "2024-09-10 15:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6217", "2121", "ایجاد فعالیت", "2024-09-10 12:22:38", "2024-09-10 15:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("6218", "2122", "ایجاد فعالیت", "2024-09-10 12:22:38", "2024-09-10 15:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("6219", "2123", "ایجاد فعالیت", "2024-09-10 12:22:38", "2024-09-10 15:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("6220", "2124", "ایجاد فعالیت", "2024-09-10 12:22:38", "2024-09-10 15:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("6221", "2125", "ایجاد فعالیت", "2024-09-10 12:22:38", "2024-09-10 15:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("6222", "2126", "ایجاد فعالیت", "2024-09-10 12:22:39", "2024-09-10 15:52:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6223", "2127", "ایجاد فعالیت", "2024-09-10 12:22:39", "2024-09-10 15:52:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6224", "2128", "ایجاد فعالیت", "2024-09-10 12:22:39", "2024-09-10 15:52:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6225", "2129", "ایجاد فعالیت", "2024-09-10 12:22:39", "2024-09-10 15:52:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6226", "2130", "ایجاد فعالیت", "2024-09-10 12:22:39", "2024-09-10 15:52:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6227", "2131", "ایجاد فعالیت", "2024-09-10 12:22:39", "2024-09-10 15:52:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6228", "2132", "ایجاد فعالیت", "2024-09-10 12:22:40", "2024-09-10 15:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6229", "2133", "ایجاد فعالیت", "2024-09-10 12:22:40", "2024-09-10 15:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6230", "2134", "ایجاد فعالیت", "2024-09-10 12:22:40", "2024-09-10 15:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6231", "2135", "ایجاد فعالیت", "2024-09-10 12:22:40", "2024-09-10 15:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6232", "2136", "ایجاد فعالیت", "2024-09-10 12:22:40", "2024-09-10 15:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6233", "2137", "ایجاد فعالیت", "2024-09-10 12:22:40", "2024-09-10 15:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6234", "2138", "ایجاد فعالیت", "2024-09-10 12:22:41", "2024-09-10 15:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6235", "2139", "ایجاد فعالیت", "2024-09-10 12:22:41", "2024-09-10 15:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6236", "2140", "ایجاد فعالیت", "2024-09-10 12:22:41", "2024-09-10 15:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6237", "2141", "ایجاد فعالیت", "2024-09-10 12:22:41", "2024-09-10 15:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6238", "2142", "ایجاد فعالیت", "2024-09-10 12:22:41", "2024-09-10 15:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6239", "2143", "ایجاد فعالیت", "2024-09-10 12:22:41", "2024-09-10 15:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6240", "2144", "ایجاد فعالیت", "2024-09-10 12:22:42", "2024-09-10 15:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6241", "2145", "ایجاد فعالیت", "2024-09-10 12:22:42", "2024-09-10 15:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6242", "2146", "ایجاد فعالیت", "2024-09-10 12:22:42", "2024-09-10 15:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6243", "2147", "ایجاد فعالیت", "2024-09-10 12:22:42", "2024-09-10 15:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6244", "2148", "ایجاد فعالیت", "2024-09-10 12:22:42", "2024-09-10 15:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6245", "2149", "ایجاد فعالیت", "2024-09-10 12:22:42", "2024-09-10 15:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6246", "2150", "ایجاد فعالیت", "2024-09-10 12:22:43", "2024-09-10 15:52:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6247", "2151", "ایجاد فعالیت", "2024-09-10 12:22:43", "2024-09-10 15:52:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6248", "2152", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6249", "2153", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6250", "2154", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6251", "2062", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6252", "2155", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6253", "2062", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6254", "2063", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6255", "2063", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6256", "2064", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6257", "2064", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6258", "2065", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6259", "2065", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6260", "2066", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6261", "2066", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6262", "2067", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6263", "2067", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6264", "2068", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6265", "2068", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6266", "2069", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6267", "2069", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6268", "2070", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6269", "2070", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6270", "2071", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6271", "2071", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6272", "2072", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6273", "2072", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6274", "2073", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6275", "2073", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6276", "2074", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6277", "2074", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6278", "2075", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6279", "2075", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6280", "2076", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6281", "2076", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6282", "2077", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6283", "2077", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6284", "2078", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6285", "2078", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6286", "2079", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6287", "2079", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6288", "2080", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6289", "2080", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6290", "2081", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6291", "2081", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6292", "2082", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6293", "2082", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6294", "2083", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6295", "2083", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6296", "2084", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6297", "2084", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6298", "2085", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6299", "2085", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6300", "2086", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6301", "2086", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6302", "2087", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6303", "2087", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6304", "2088", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6305", "2088", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6306", "2089", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6307", "2089", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6308", "2090", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6309", "2090", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6310", "2091", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6311", "2091", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6312", "2092", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6313", "2092", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6314", "2093", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6315", "2093", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6316", "2094", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6317", "2094", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6318", "2095", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6319", "2095", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6320", "2096", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6321", "2096", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6322", "2097", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6323", "2097", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6324", "2098", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6325", "2098", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6326", "2099", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6327", "2099", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6328", "2100", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6329", "2100", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6330", "2101", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6331", "2101", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6332", "2102", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6333", "2102", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6334", "2103", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6335", "2103", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6336", "2104", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6337", "2104", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6338", "2105", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6339", "2105", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6340", "2106", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6341", "2106", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6342", "2107", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6343", "2107", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6344", "2108", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6345", "2108", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6346", "2109", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6347", "2109", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6348", "2110", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6349", "2110", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6350", "2111", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6351", "2111", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6352", "2112", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6353", "2112", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6354", "2113", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6355", "2113", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6356", "2114", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6357", "2114", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6358", "2115", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6359", "2115", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6360", "2116", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6361", "2116", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6362", "2117", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6363", "2117", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6364", "2118", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6365", "2118", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6366", "2119", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6367", "2119", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6368", "2120", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6369", "2120", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6370", "2121", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6371", "2121", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6372", "2122", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6373", "2122", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6374", "2123", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6375", "2123", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6376", "2124", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6377", "2124", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6378", "2125", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6379", "2125", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6380", "2126", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6381", "2126", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6382", "2127", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6383", "2127", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6384", "2128", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6385", "2128", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6386", "2129", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6387", "2129", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6388", "2156", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6389", "2130", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6390", "2130", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6391", "2131", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6392", "2131", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6393", "2157", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6394", "2132", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6395", "2132", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6396", "2133", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6397", "2133", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6398", "2134", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6399", "2134", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6400", "2135", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6401", "2135", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6402", "2136", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6403", "2136", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6404", "2137", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6405", "2137", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6406", "2138", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6407", "2138", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6408", "2139", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6409", "2139", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6410", "2140", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6411", "2140", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6412", "2141", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6413", "2141", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6414", "2142", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6415", "2142", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6416", "2143", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6417", "2143", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6418", "2144", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6419", "2144", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6420", "2145", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6421", "2145", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6422", "2146", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6423", "2146", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6424", "2147", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6425", "2147", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6426", "2148", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6427", "2148", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6428", "2149", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6429", "2149", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6430", "2150", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6431", "2150", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6432", "2151", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6433", "2151", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6434", "2158", "ایجاد فعالیت", "2024-09-10 12:22:44", "2024-09-10 15:52:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6435", "2159", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6436", "2160", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6437", "2161", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6438", "2162", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6439", "2163", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6440", "2164", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6441", "2165", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6442", "2166", "ایجاد فعالیت", "2024-09-10 12:22:45", "2024-09-10 15:52:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("6443", "2167", "ایجاد فعالیت", "2024-09-10 12:22:46", "2024-09-10 15:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6444", "2168", "ایجاد فعالیت", "2024-09-10 12:22:46", "2024-09-10 15:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6445", "2169", "ایجاد فعالیت", "2024-09-10 12:22:46", "2024-09-10 15:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6446", "2170", "ایجاد فعالیت", "2024-09-10 12:22:46", "2024-09-10 15:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6447", "2171", "ایجاد فعالیت", "2024-09-10 12:22:46", "2024-09-10 15:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6448", "2172", "ایجاد فعالیت", "2024-09-10 12:22:46", "2024-09-10 15:52:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6449", "2173", "ایجاد فعالیت", "2024-09-10 12:22:47", "2024-09-10 15:52:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6450", "2174", "ایجاد فعالیت", "2024-09-10 12:22:47", "2024-09-10 15:52:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6451", "2175", "ایجاد فعالیت", "2024-09-10 12:22:47", "2024-09-10 15:52:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6452", "2176", "ایجاد فعالیت", "2024-09-10 12:22:47", "2024-09-10 15:52:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6453", "2177", "ایجاد فعالیت", "2024-09-10 12:22:47", "2024-09-10 15:52:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6454", "2178", "ایجاد فعالیت", "2024-09-10 12:22:47", "2024-09-10 15:52:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6455", "2179", "ایجاد فعالیت", "2024-09-10 12:22:48", "2024-09-10 15:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6456", "2180", "ایجاد فعالیت", "2024-09-10 12:22:48", "2024-09-10 15:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6457", "2181", "ایجاد فعالیت", "2024-09-10 12:22:48", "2024-09-10 15:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6458", "2182", "ایجاد فعالیت", "2024-09-10 12:22:48", "2024-09-10 15:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6459", "2183", "ایجاد فعالیت", "2024-09-10 12:22:48", "2024-09-10 15:52:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6460", "2184", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6461", "2185", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6462", "2186", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6463", "2187", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6464", "2188", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6465", "2189", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6466", "2190", "ایجاد فعالیت", "2024-09-10 12:22:49", "2024-09-10 15:52:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6467", "2191", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6468", "2152", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6469", "2192", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6470", "2152", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6471", "2153", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6472", "2153", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6473", "2154", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6474", "2154", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6475", "2155", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6476", "2155", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6477", "2156", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6478", "2156", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6479", "2157", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6480", "2157", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6481", "2158", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6482", "2158", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6483", "2159", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6484", "2159", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6485", "2160", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6486", "2160", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6487", "2161", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6488", "2161", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6489", "2162", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6490", "2162", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6491", "2163", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6492", "2163", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6493", "2164", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6494", "2164", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6495", "2165", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6496", "2165", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6497", "2166", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6498", "2166", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6499", "2167", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6500", "2167", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6501", "2168", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6502", "2168", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6503", "2169", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6504", "2169", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6505", "2170", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6506", "2170", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6507", "2171", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6508", "2171", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6509", "2172", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6510", "2172", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6511", "2173", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6512", "2173", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6513", "2174", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6514", "2174", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6515", "2175", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6516", "2175", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6517", "2176", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6518", "2176", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6519", "2177", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6520", "2177", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6521", "2178", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6522", "2178", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6523", "2179", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6524", "2179", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6525", "2180", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6526", "2180", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6527", "2181", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6528", "2181", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6529", "2182", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6530", "2182", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6531", "2183", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6532", "2183", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6533", "2184", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6534", "2184", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6535", "2185", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6536", "2185", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6537", "2186", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6538", "2186", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6539", "2187", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6540", "2187", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6541", "2188", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6542", "2188", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6543", "2189", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6544", "2189", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6545", "2190", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6546", "2190", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6547", "2193", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6548", "2194", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6549", "2195", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6550", "2196", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6551", "2197", "ایجاد فعالیت", "2024-09-10 12:22:50", "2024-09-10 15:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6552", "2191", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6553", "2191", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6554", "2192", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6555", "2192", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6556", "2193", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6557", "2193", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6558", "2194", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6559", "2194", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6560", "2195", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6561", "2195", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6562", "2196", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6563", "2196", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6564", "2197", "عملیات توسط Async Request شروع شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6565", "2197", "عملیات توسط Async Request کامل شد", "2024-09-10 12:22:55", "2024-09-10 15:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6566", "2198", "ایجاد فعالیت", "2024-09-10 12:24:49", "2024-09-10 15:54:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6567", "2199", "ایجاد فعالیت", "2024-09-10 12:24:50", "2024-09-10 15:54:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6568", "2198", "عملیات توسط Async Request شروع شد", "2024-09-10 12:24:51", "2024-09-10 15:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6569", "2198", "عملیات توسط Async Request کامل شد", "2024-09-10 12:24:51", "2024-09-10 15:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6570", "2199", "عملیات توسط Async Request شروع شد", "2024-09-10 12:24:51", "2024-09-10 15:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6571", "2199", "عملیات توسط Async Request کامل شد", "2024-09-10 12:24:51", "2024-09-10 15:54:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6572", "2200", "ایجاد فعالیت", "2024-09-10 12:26:54", "2024-09-10 15:56:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6573", "2200", "عملیات توسط Async Request شروع شد", "2024-09-10 12:26:57", "2024-09-10 15:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6574", "2200", "عملیات توسط Async Request کامل شد", "2024-09-10 12:26:57", "2024-09-10 15:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6575", "2201", "ایجاد فعالیت", "2024-09-10 12:29:50", "2024-09-10 15:59:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6576", "2201", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:30:05", "2024-09-10 16:00:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6577", "2201", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:30:05", "2024-09-10 16:00:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6578", "2202", "ایجاد فعالیت", "2024-09-10 12:30:55", "2024-09-10 16:00:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6579", "2202", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:31:07", "2024-09-10 16:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6580", "2202", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:31:07", "2024-09-10 16:01:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6581", "2203", "ایجاد فعالیت", "2024-09-10 12:31:22", "2024-09-10 16:01:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("6582", "2203", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:36:50", "2024-09-10 16:06:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6583", "2203", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:36:50", "2024-09-10 16:06:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6584", "2204", "ایجاد فعالیت", "2024-09-10 12:46:33", "2024-09-10 16:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6585", "2204", "عملیات توسط Async Request شروع شد", "2024-09-10 12:48:05", "2024-09-10 16:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6586", "2204", "عملیات توسط Async Request کامل شد", "2024-09-10 12:48:05", "2024-09-10 16:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6587", "2205", "ایجاد فعالیت", "2024-09-10 12:48:05", "2024-09-10 16:18:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6588", "2205", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:49:05", "2024-09-10 16:19:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6589", "2205", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-10 12:49:05", "2024-09-10 16:19:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6590", "2206", "ایجاد فعالیت", "2024-09-10 12:50:43", "2024-09-10 16:20:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6591", "2206", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:51:08", "2024-09-10 16:21:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6592", "2206", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:51:08", "2024-09-10 16:21:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6593", "2207", "ایجاد فعالیت", "2024-09-10 12:52:20", "2024-09-10 16:22:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6594", "2207", "عملیات توسط Async Request شروع شد", "2024-09-10 12:52:26", "2024-09-10 16:22:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6595", "2207", "عملیات توسط Async Request کامل شد", "2024-09-10 12:52:26", "2024-09-10 16:22:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6596", "2208", "ایجاد فعالیت", "2024-09-10 12:52:47", "2024-09-10 16:22:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6597", "2208", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:53:06", "2024-09-10 16:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6598", "2208", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:53:06", "2024-09-10 16:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6599", "2209", "ایجاد فعالیت", "2024-09-10 12:53:26", "2024-09-10 16:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6600", "2210", "ایجاد فعالیت", "2024-09-10 12:53:51", "2024-09-10 16:23:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("6601", "2209", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:54:06", "2024-09-10 16:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6602", "2209", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:54:06", "2024-09-10 16:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6603", "2210", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:54:06", "2024-09-10 16:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6604", "2210", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:54:06", "2024-09-10 16:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6605", "2211", "ایجاد فعالیت", "2024-09-10 12:54:47", "2024-09-10 16:24:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6606", "2211", "عملیات توسط WP Cron شروع شد", "2024-09-10 12:55:06", "2024-09-10 16:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6607", "2211", "عملیات توسط WP Cron کامل شد", "2024-09-10 12:55:06", "2024-09-10 16:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6608", "2212", "ایجاد فعالیت", "2024-09-10 12:55:18", "2024-09-10 16:25:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6609", "2212", "عملیات توسط Async Request شروع شد", "2024-09-10 12:55:50", "2024-09-10 16:25:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6610", "2212", "عملیات توسط Async Request کامل شد", "2024-09-10 12:55:50", "2024-09-10 16:25:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6611", "2213", "ایجاد فعالیت", "2024-09-10 12:56:44", "2024-09-10 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6612", "2213", "عملیات توسط Async Request شروع شد", "2024-09-10 12:56:52", "2024-09-10 16:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6613", "2213", "عملیات توسط Async Request کامل شد", "2024-09-10 12:56:52", "2024-09-10 16:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6614", "2214", "ایجاد فعالیت", "2024-09-10 12:57:16", "2024-09-10 16:27:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("6615", "2215", "ایجاد فعالیت", "2024-09-10 12:57:49", "2024-09-10 16:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("6616", "2214", "عملیات توسط Async Request شروع شد", "2024-09-10 12:57:53", "2024-09-10 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6617", "2214", "عملیات توسط Async Request کامل شد", "2024-09-10 12:57:53", "2024-09-10 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6618", "2215", "عملیات توسط Async Request شروع شد", "2024-09-10 12:57:53", "2024-09-10 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6619", "2215", "عملیات توسط Async Request کامل شد", "2024-09-10 12:57:53", "2024-09-10 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6620", "2216", "ایجاد فعالیت", "2024-09-10 12:58:17", "2024-09-10 16:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6621", "2216", "عملیات توسط Async Request شروع شد", "2024-09-10 12:58:54", "2024-09-10 16:28:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6622", "2216", "عملیات توسط Async Request کامل شد", "2024-09-10 12:58:54", "2024-09-10 16:28:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6623", "2217", "ایجاد فعالیت", "2024-09-10 12:59:07", "2024-09-10 16:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6624", "2217", "عملیات توسط Async Request شروع شد", "2024-09-10 12:59:56", "2024-09-10 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6625", "2217", "عملیات توسط Async Request کامل شد", "2024-09-10 12:59:56", "2024-09-10 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("6626", "2218", "ایجاد فعالیت", "2024-09-10 13:00:05", "2024-09-10 16:30:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6627", "2219", "ایجاد فعالیت", "2024-09-10 13:00:57", "2024-09-10 16:30:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6628", "2218", "عملیات توسط Async Request شروع شد", "2024-09-10 13:00:58", "2024-09-10 16:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6629", "2218", "عملیات توسط Async Request کامل شد", "2024-09-10 13:00:58", "2024-09-10 16:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6630", "2219", "عملیات توسط Async Request شروع شد", "2024-09-10 13:00:58", "2024-09-10 16:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6631", "2219", "عملیات توسط Async Request کامل شد", "2024-09-10 13:00:58", "2024-09-10 16:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6632", "2220", "ایجاد فعالیت", "2024-09-10 13:00:59", "2024-09-10 16:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6633", "2220", "عملیات توسط Async Request شروع شد", "2024-09-10 13:01:03", "2024-09-10 16:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6634", "2220", "عملیات توسط Async Request کامل شد", "2024-09-10 13:01:03", "2024-09-10 16:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6635", "2221", "ایجاد فعالیت", "2024-09-10 13:01:21", "2024-09-10 16:31:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6636", "2222", "ایجاد فعالیت", "2024-09-10 13:01:28", "2024-09-10 16:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6637", "2221", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:02:05", "2024-09-10 16:32:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6638", "2221", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:02:05", "2024-09-10 16:32:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6639", "2222", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:02:05", "2024-09-10 16:32:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6640", "2222", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:02:05", "2024-09-10 16:32:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6641", "2223", "ایجاد فعالیت", "2024-09-10 13:02:40", "2024-09-10 16:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6642", "2224", "ایجاد فعالیت", "2024-09-10 13:03:06", "2024-09-10 16:33:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6643", "2223", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:03:06", "2024-09-10 16:33:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6644", "2223", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:03:06", "2024-09-10 16:33:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6645", "2224", "عملیات توسط Async Request شروع شد", "2024-09-10 13:03:20", "2024-09-10 16:33:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6646", "2224", "عملیات توسط Async Request کامل شد", "2024-09-10 13:03:20", "2024-09-10 16:33:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6647", "2225", "ایجاد فعالیت", "2024-09-10 13:03:32", "2024-09-10 16:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6648", "2226", "ایجاد فعالیت", "2024-09-10 13:03:50", "2024-09-10 16:33:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6649", "2225", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:04:12", "2024-09-10 16:34:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6650", "2225", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:04:12", "2024-09-10 16:34:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6651", "2226", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:04:12", "2024-09-10 16:34:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6652", "2226", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:04:12", "2024-09-10 16:34:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6653", "2227", "ایجاد فعالیت", "2024-09-10 13:04:52", "2024-09-10 16:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6654", "2227", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:05:07", "2024-09-10 16:35:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6655", "2227", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:05:07", "2024-09-10 16:35:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6656", "2228", "ایجاد فعالیت", "2024-09-10 13:05:59", "2024-09-10 16:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6657", "2228", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:06:05", "2024-09-10 16:36:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6658", "2228", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:06:05", "2024-09-10 16:36:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6659", "2229", "ایجاد فعالیت", "2024-09-10 13:06:14", "2024-09-10 16:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("6660", "2230", "ایجاد فعالیت", "2024-09-10 13:06:21", "2024-09-10 16:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6661", "2229", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:07:17", "2024-09-10 16:37:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6662", "2229", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:07:17", "2024-09-10 16:37:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6663", "2230", "عملیات توسط WP Cron شروع شد", "2024-09-10 13:07:17", "2024-09-10 16:37:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6664", "2230", "عملیات توسط WP Cron کامل شد", "2024-09-10 13:07:17", "2024-09-10 16:37:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6665", "1954", "عملیات توسط WP Cron شروع شد", "2024-09-11 10:18:19", "2024-09-11 13:48:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6666", "1954", "عملیات توسط WP Cron کامل شد", "2024-09-11 10:18:19", "2024-09-11 13:48:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6667", "2231", "ایجاد فعالیت", "2024-09-11 10:18:20", "2024-09-11 13:48:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6671", "2233", "ایجاد فعالیت", "2024-09-12 18:18:58", "2024-09-12 21:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6672", "2234", "ایجاد فعالیت", "2024-09-12 18:19:10", "2024-09-12 21:49:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6673", "2233", "عملیات توسط WP Cron شروع شد", "2024-09-12 18:19:10", "2024-09-12 21:49:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6674", "2233", "عملیات توسط WP Cron کامل شد", "2024-09-12 18:19:10", "2024-09-12 21:49:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6675", "2234", "عملیات توسط Async Request شروع شد", "2024-09-12 18:19:46", "2024-09-12 21:49:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6676", "2234", "عملیات توسط Async Request کامل شد", "2024-09-12 18:19:46", "2024-09-12 21:49:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6677", "2235", "ایجاد فعالیت", "2024-09-12 18:20:04", "2024-09-12 21:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6678", "2235", "عملیات توسط WP Cron شروع شد", "2024-09-12 18:20:14", "2024-09-12 21:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("6679", "2235", "عملیات توسط WP Cron کامل شد", "2024-09-12 18:20:14", "2024-09-12 21:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("6680", "2236", "ایجاد فعالیت", "2024-09-12 18:20:15", "2024-09-12 21:50:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("6681", "2236", "عملیات توسط Async Request شروع شد", "2024-09-12 18:20:50", "2024-09-12 21:50:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6682", "2236", "عملیات توسط Async Request کامل شد", "2024-09-12 18:20:50", "2024-09-12 21:50:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6683", "2237", "ایجاد فعالیت", "2024-09-12 18:38:18", "2024-09-12 22:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6684", "2237", "عملیات توسط WP Cron شروع شد", "2024-09-12 18:39:11", "2024-09-12 22:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6685", "2237", "عملیات توسط WP Cron کامل شد", "2024-09-12 18:39:11", "2024-09-12 22:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("6686", "2238", "ایجاد فعالیت", "2024-09-13 08:19:44", "2024-09-13 11:49:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6687", "2238", "عملیات توسط WP Cron شروع شد", "2024-09-13 08:20:06", "2024-09-13 11:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6688", "2238", "عملیات توسط WP Cron کامل شد", "2024-09-13 08:20:06", "2024-09-13 11:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6689", "2239", "ایجاد فعالیت", "2024-09-13 08:20:30", "2024-09-13 11:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("6690", "2240", "ایجاد فعالیت", "2024-09-13 08:20:37", "2024-09-13 11:50:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6691", "2239", "عملیات توسط Async Request شروع شد", "2024-09-13 08:20:42", "2024-09-13 11:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6692", "2239", "عملیات توسط Async Request کامل شد", "2024-09-13 08:20:42", "2024-09-13 11:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6693", "2240", "عملیات توسط Async Request شروع شد", "2024-09-13 08:20:42", "2024-09-13 11:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6694", "2240", "عملیات توسط Async Request کامل شد", "2024-09-13 08:20:42", "2024-09-13 11:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6695", "2241", "ایجاد فعالیت", "2024-09-13 08:20:46", "2024-09-13 11:50:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6696", "2241", "عملیات توسط Async Request شروع شد", "2024-09-13 08:20:47", "2024-09-13 11:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6697", "2241", "عملیات توسط Async Request کامل شد", "2024-09-13 08:20:47", "2024-09-13 11:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6698", "2242", "ایجاد فعالیت", "2024-09-13 08:21:09", "2024-09-13 11:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6699", "2243", "ایجاد فعالیت", "2024-09-13 08:21:09", "2024-09-13 11:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6700", "2244", "ایجاد فعالیت", "2024-09-13 08:21:09", "2024-09-13 11:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6701", "2245", "ایجاد فعالیت", "2024-09-13 08:21:10", "2024-09-13 11:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6702", "2242", "عملیات توسط Async Request شروع شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6703", "2242", "عملیات توسط Async Request کامل شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6704", "2243", "عملیات توسط Async Request شروع شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6705", "2243", "عملیات توسط Async Request کامل شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6706", "2244", "عملیات توسط Async Request شروع شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6707", "2244", "عملیات توسط Async Request کامل شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6708", "2245", "عملیات توسط Async Request شروع شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6709", "2245", "عملیات توسط Async Request کامل شد", "2024-09-13 08:21:44", "2024-09-13 11:51:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6710", "2246", "ایجاد فعالیت", "2024-09-13 08:41:07", "2024-09-13 12:11:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6711", "2246", "عملیات توسط Async Request شروع شد", "2024-09-13 08:41:27", "2024-09-13 12:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("6712", "2246", "عملیات توسط Async Request کامل شد", "2024-09-13 08:41:27", "2024-09-13 12:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("6713", "2247", "ایجاد فعالیت", "2024-09-13 08:49:14", "2024-09-13 12:19:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("6714", "2247", "عملیات توسط Async Request شروع شد", "2024-09-13 08:49:41", "2024-09-13 12:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6715", "2247", "عملیات توسط Async Request کامل شد", "2024-09-13 08:49:41", "2024-09-13 12:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6716", "2248", "ایجاد فعالیت", "2024-09-13 09:53:20", "2024-09-13 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6717", "2248", "عملیات توسط Async Request شروع شد", "2024-09-13 09:54:54", "2024-09-13 13:24:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6718", "2248", "عملیات توسط Async Request کامل شد", "2024-09-13 09:54:54", "2024-09-13 13:24:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6719", "2232", "عملیات توسط WP Cron شروع شد", "2024-09-13 11:06:28", "2024-09-13 14:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6720", "2232", "عملیات توسط WP Cron کامل شد", "2024-09-13 11:06:28", "2024-09-13 14:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6721", "2249", "ایجاد فعالیت", "2024-09-13 11:06:28", "2024-09-13 14:36:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6722", "2250", "ایجاد فعالیت", "2024-09-14 06:37:26", "2024-09-14 10:07:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6723", "2250", "عملیات توسط WP Cron شروع شد", "2024-09-14 06:37:54", "2024-09-14 10:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6724", "2250", "عملیات توسط WP Cron کامل شد", "2024-09-14 06:37:54", "2024-09-14 10:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("6725", "2251", "ایجاد فعالیت", "2024-09-14 06:45:19", "2024-09-14 10:15:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6726", "2252", "ایجاد فعالیت", "2024-09-14 06:45:19", "2024-09-14 10:15:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6727", "2253", "ایجاد فعالیت", "2024-09-14 06:45:19", "2024-09-14 10:15:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("6728", "2251", "عملیات توسط Async Request شروع شد", "2024-09-14 06:45:29", "2024-09-14 10:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6729", "2251", "عملیات توسط Async Request کامل شد", "2024-09-14 06:45:29", "2024-09-14 10:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6730", "2252", "عملیات توسط Async Request شروع شد", "2024-09-14 06:45:29", "2024-09-14 10:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6731", "2252", "عملیات توسط Async Request کامل شد", "2024-09-14 06:45:29", "2024-09-14 10:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6732", "2253", "عملیات توسط Async Request شروع شد", "2024-09-14 06:45:29", "2024-09-14 10:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6733", "2253", "عملیات توسط Async Request کامل شد", "2024-09-14 06:45:29", "2024-09-14 10:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6734", "2254", "ایجاد فعالیت", "2024-09-14 10:54:17", "2024-09-14 14:24:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6735", "2255", "ایجاد فعالیت", "2024-09-14 10:54:17", "2024-09-14 14:24:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("6736", "2256", "ایجاد فعالیت", "2024-09-14 10:54:41", "2024-09-14 14:24:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6737", "2257", "ایجاد فعالیت", "2024-09-14 10:54:41", "2024-09-14 14:24:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6738", "2254", "عملیات توسط WP Cron شروع شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6739", "2254", "عملیات توسط WP Cron کامل شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6740", "2255", "عملیات توسط WP Cron شروع شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6741", "2255", "عملیات توسط WP Cron کامل شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6742", "2256", "عملیات توسط WP Cron شروع شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6743", "2256", "عملیات توسط WP Cron کامل شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6744", "2257", "عملیات توسط WP Cron شروع شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6745", "2257", "عملیات توسط WP Cron کامل شد", "2024-09-14 10:55:03", "2024-09-14 14:25:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("6746", "2258", "ایجاد فعالیت", "2024-09-14 10:55:06", "2024-09-14 14:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6747", "2259", "ایجاد فعالیت", "2024-09-14 10:55:06", "2024-09-14 14:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6748", "2258", "عملیات توسط Async Request شروع شد", "2024-09-14 10:55:07", "2024-09-14 14:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6749", "2258", "عملیات توسط Async Request کامل شد", "2024-09-14 10:55:07", "2024-09-14 14:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6750", "2259", "عملیات توسط Async Request شروع شد", "2024-09-14 10:55:07", "2024-09-14 14:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6751", "2259", "عملیات توسط Async Request کامل شد", "2024-09-14 10:55:07", "2024-09-14 14:25:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6752", "2260", "ایجاد فعالیت", "2024-09-14 11:03:16", "2024-09-14 14:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("6753", "2261", "ایجاد فعالیت", "2024-09-14 11:03:32", "2024-09-14 14:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6754", "2262", "ایجاد فعالیت", "2024-09-14 11:03:32", "2024-09-14 14:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6755", "2263", "ایجاد فعالیت", "2024-09-14 11:03:34", "2024-09-14 14:33:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("6756", "2260", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6757", "2260", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6758", "2261", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6759", "2261", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6760", "2262", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6761", "2262", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6762", "2263", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6763", "2263", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:04:07", "2024-09-14 14:34:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6764", "2249", "عملیات توسط Async Request شروع شد", "2024-09-14 11:06:44", "2024-09-14 14:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6765", "2249", "عملیات توسط Async Request کامل شد", "2024-09-14 11:06:44", "2024-09-14 14:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6766", "2264", "ایجاد فعالیت", "2024-09-14 11:06:44", "2024-09-14 14:36:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("6767", "2265", "ایجاد فعالیت", "2024-09-14 11:08:42", "2024-09-14 14:38:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6768", "2265", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:08:59", "2024-09-14 14:38:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6769", "2265", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:08:59", "2024-09-14 14:38:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6770", "2266", "ایجاد فعالیت", "2024-09-14 11:09:05", "2024-09-14 14:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("6771", "2267", "ایجاد فعالیت", "2024-09-14 11:09:09", "2024-09-14 14:39:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6772", "2266", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:10:00", "2024-09-14 14:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6773", "2266", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:10:00", "2024-09-14 14:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6774", "2267", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:10:00", "2024-09-14 14:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6775", "2267", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:10:00", "2024-09-14 14:40:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6776", "2268", "ایجاد فعالیت", "2024-09-14 11:10:07", "2024-09-14 14:40:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6777", "2268", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:11:08", "2024-09-14 14:41:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6778", "2268", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:11:08", "2024-09-14 14:41:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6779", "2269", "ایجاد فعالیت", "2024-09-14 11:11:21", "2024-09-14 14:41:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6780", "2269", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:11:59", "2024-09-14 14:41:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6781", "2269", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:11:59", "2024-09-14 14:41:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6782", "2270", "ایجاد فعالیت", "2024-09-14 11:26:22", "2024-09-14 14:56:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("6783", "2271", "ایجاد فعالیت", "2024-09-14 11:26:40", "2024-09-14 14:56:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("6784", "2272", "ایجاد فعالیت", "2024-09-14 11:26:43", "2024-09-14 14:56:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("6785", "2270", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:27:04", "2024-09-14 14:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6786", "2270", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:27:04", "2024-09-14 14:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6787", "2271", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:27:04", "2024-09-14 14:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6788", "2271", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:27:04", "2024-09-14 14:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6789", "2272", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:27:04", "2024-09-14 14:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6790", "2272", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:27:04", "2024-09-14 14:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("6791", "2273", "ایجاد فعالیت", "2024-09-14 11:27:52", "2024-09-14 14:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("6792", "2274", "ایجاد فعالیت", "2024-09-14 11:27:57", "2024-09-14 14:57:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6793", "2273", "عملیات توسط WP Cron شروع شد", "2024-09-14 11:27:57", "2024-09-14 14:57:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6794", "2273", "عملیات توسط WP Cron کامل شد", "2024-09-14 11:27:57", "2024-09-14 14:57:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6795", "2275", "ایجاد فعالیت", "2024-09-14 11:28:00", "2024-09-14 14:58:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6796", "2274", "عملیات توسط Async Request شروع شد", "2024-09-14 11:28:32", "2024-09-14 14:58:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6797", "2274", "عملیات توسط Async Request کامل شد", "2024-09-14 11:28:32", "2024-09-14 14:58:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6798", "2275", "عملیات توسط Async Request شروع شد", "2024-09-14 11:28:32", "2024-09-14 14:58:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6799", "2275", "عملیات توسط Async Request کامل شد", "2024-09-14 11:28:32", "2024-09-14 14:58:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("6800", "2276", "ایجاد فعالیت", "2024-09-14 11:29:58", "2024-09-14 14:59:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6801", "2277", "ایجاد فعالیت", "2024-09-14 11:30:00", "2024-09-14 15:00:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6802", "2276", "عملیات توسط Async Request شروع شد", "2024-09-14 11:30:39", "2024-09-14 15:00:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6803", "2276", "عملیات توسط Async Request کامل شد", "2024-09-14 11:30:39", "2024-09-14 15:00:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6804", "2277", "عملیات توسط Async Request شروع شد", "2024-09-14 11:30:39", "2024-09-14 15:00:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6805", "2277", "عملیات توسط Async Request کامل شد", "2024-09-14 11:30:39", "2024-09-14 15:00:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("6806", "2278", "ایجاد فعالیت", "2024-09-15 09:04:12", "2024-09-15 12:34:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("6807", "2278", "عملیات توسط WP Cron شروع شد", "2024-09-15 09:05:06", "2024-09-15 12:35:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6808", "2278", "عملیات توسط WP Cron کامل شد", "2024-09-15 09:05:06", "2024-09-15 12:35:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6809", "2279", "ایجاد فعالیت", "2024-09-15 09:17:23", "2024-09-15 12:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("6810", "2279", "عملیات توسط WP Cron شروع شد", "2024-09-15 09:18:00", "2024-09-15 12:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6811", "2279", "عملیات توسط WP Cron کامل شد", "2024-09-15 09:18:00", "2024-09-15 12:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("6812", "2264", "عملیات توسط WP Cron شروع شد", "2024-09-15 11:07:08", "2024-09-15 14:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6813", "2264", "عملیات توسط WP Cron کامل شد", "2024-09-15 11:07:08", "2024-09-15 14:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6814", "2280", "ایجاد فعالیت", "2024-09-15 11:07:08", "2024-09-15 14:37:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6815", "2281", "ایجاد فعالیت", "2024-09-15 11:32:21", "2024-09-15 15:02:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("6816", "2281", "عملیات توسط Async Request شروع شد", "2024-09-15 11:32:41", "2024-09-15 15:02:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6817", "2281", "عملیات توسط Async Request کامل شد", "2024-09-15 11:32:41", "2024-09-15 15:02:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("6818", "2282", "ایجاد فعالیت", "2024-09-15 11:33:26", "2024-09-15 15:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6819", "2283", "ایجاد فعالیت", "2024-09-15 11:33:26", "2024-09-15 15:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6820", "2284", "ایجاد فعالیت", "2024-09-15 11:33:26", "2024-09-15 15:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("6821", "2282", "عملیات توسط Async Request شروع شد", "2024-09-15 11:33:53", "2024-09-15 15:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6822", "2282", "عملیات توسط Async Request کامل شد", "2024-09-15 11:33:53", "2024-09-15 15:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6823", "2283", "عملیات توسط Async Request شروع شد", "2024-09-15 11:33:53", "2024-09-15 15:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6824", "2283", "عملیات توسط Async Request کامل شد", "2024-09-15 11:33:53", "2024-09-15 15:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6825", "2284", "عملیات توسط Async Request شروع شد", "2024-09-15 11:33:53", "2024-09-15 15:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6826", "2284", "عملیات توسط Async Request کامل شد", "2024-09-15 11:33:53", "2024-09-15 15:03:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("6827", "2285", "ایجاد فعالیت", "2024-09-15 11:34:57", "2024-09-15 15:04:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6828", "2285", "عملیات توسط WP Cron شروع شد", "2024-09-15 11:36:08", "2024-09-15 15:06:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6829", "2285", "عملیات توسط WP Cron کامل شد", "2024-09-15 11:36:08", "2024-09-15 15:06:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("6830", "2286", "ایجاد فعالیت", "2024-09-15 11:36:50", "2024-09-15 15:06:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6831", "2286", "عملیات توسط WP Cron شروع شد", "2024-09-15 11:37:01", "2024-09-15 15:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6832", "2286", "عملیات توسط WP Cron کامل شد", "2024-09-15 11:37:01", "2024-09-15 15:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("6833", "2287", "ایجاد فعالیت", "2024-09-15 11:39:06", "2024-09-15 15:09:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6834", "2288", "ایجاد فعالیت", "2024-09-15 11:39:06", "2024-09-15 15:09:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("6835", "2287", "عملیات توسط Async Request شروع شد", "2024-09-15 11:39:42", "2024-09-15 15:09:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6836", "2287", "عملیات توسط Async Request کامل شد", "2024-09-15 11:39:42", "2024-09-15 15:09:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6837", "2288", "عملیات توسط Async Request شروع شد", "2024-09-15 11:39:42", "2024-09-15 15:09:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6838", "2288", "عملیات توسط Async Request کامل شد", "2024-09-15 11:39:42", "2024-09-15 15:09:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("6839", "2289", "ایجاد فعالیت", "2024-09-15 11:40:07", "2024-09-15 15:10:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("6840", "2289", "عملیات توسط Async Request شروع شد", "2024-09-15 11:40:46", "2024-09-15 15:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6841", "2289", "عملیات توسط Async Request کامل شد", "2024-09-15 11:40:46", "2024-09-15 15:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("6842", "2290", "ایجاد فعالیت", "2024-09-15 11:40:59", "2024-09-15 15:10:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("6843", "2290", "عملیات توسط Async Request شروع شد", "2024-09-15 11:41:50", "2024-09-15 15:11:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6844", "2290", "عملیات توسط Async Request کامل شد", "2024-09-15 11:41:50", "2024-09-15 15:11:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6845", "2291", "ایجاد فعالیت", "2024-09-15 11:42:29", "2024-09-15 15:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("6846", "2291", "عملیات توسط Async Request شروع شد", "2024-09-15 11:42:55", "2024-09-15 15:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6847", "2291", "عملیات توسط Async Request کامل شد", "2024-09-15 11:42:55", "2024-09-15 15:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("6848", "2292", "ایجاد فعالیت", "2024-09-15 11:44:37", "2024-09-15 15:14:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("6849", "2292", "عملیات توسط WP Cron شروع شد", "2024-09-15 11:44:58", "2024-09-15 15:14:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6850", "2292", "عملیات توسط WP Cron کامل شد", "2024-09-15 11:44:58", "2024-09-15 15:14:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6851", "2280", "عملیات توسط Async Request شروع شد", "2024-09-16 11:07:33", "2024-09-16 14:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6852", "2280", "عملیات توسط Async Request کامل شد", "2024-09-16 11:07:33", "2024-09-16 14:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6853", "2293", "ایجاد فعالیت", "2024-09-16 11:07:33", "2024-09-16 14:37:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("6854", "2293", "عملیات توسط WP Cron شروع شد", "2024-09-17 11:08:13", "2024-09-17 14:38:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6855", "2293", "عملیات توسط WP Cron کامل شد", "2024-09-17 11:08:13", "2024-09-17 14:38:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6856", "2294", "ایجاد فعالیت", "2024-09-17 11:08:13", "2024-09-17 14:38:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("6857", "2295", "ایجاد فعالیت", "2024-09-17 11:50:48", "2024-09-17 15:20:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6858", "2295", "عملیات توسط WP Cron شروع شد", "2024-09-17 11:50:58", "2024-09-17 15:20:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6859", "2295", "عملیات توسط WP Cron کامل شد", "2024-09-17 11:50:58", "2024-09-17 15:20:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6860", "2296", "ایجاد فعالیت", "2024-09-17 11:51:18", "2024-09-17 15:21:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6861", "2296", "عملیات توسط WP Cron شروع شد", "2024-09-17 11:52:02", "2024-09-17 15:22:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6862", "2296", "عملیات توسط WP Cron کامل شد", "2024-09-17 11:52:02", "2024-09-17 15:22:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("6865", "2297", "ایجاد فعالیت", "2024-09-18 11:08:47", "2024-09-18 14:38:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("6866", "2298", "ایجاد فعالیت", "2024-09-19 07:17:10", "2024-09-19 10:47:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("6867", "2298", "عملیات توسط WP Cron شروع شد", "2024-09-19 07:17:48", "2024-09-19 10:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6868", "2298", "عملیات توسط WP Cron کامل شد", "2024-09-19 07:17:48", "2024-09-19 10:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("6869", "2297", "عملیات توسط WP Cron شروع شد", "2024-09-19 11:08:58", "2024-09-19 14:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6870", "2297", "عملیات توسط WP Cron کامل شد", "2024-09-19 11:08:58", "2024-09-19 14:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("6871", "2299", "ایجاد فعالیت", "2024-09-19 11:08:59", "2024-09-19 14:38:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7679", "2569", "ایجاد فعالیت", "2024-09-29 12:54:20", "2024-09-29 16:24:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7680", "2569", "عملیات توسط WP Cron شروع شد", "2024-09-29 13:08:18", "2024-09-29 16:38:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7681", "2569", "عملیات توسط WP Cron کامل شد", "2024-09-29 13:08:18", "2024-09-29 16:38:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7682", "2570", "ایجاد فعالیت", "2024-09-29 13:08:18", "2024-09-29 16:38:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7683", "2570", "عملیات توسط WP Cron شروع شد", "2024-09-29 13:13:12", "2024-09-29 16:43:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7684", "2570", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-09-29 13:13:12", "2024-09-29 16:43:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7687", "2571", "ایجاد فعالیت", "2024-09-30 05:18:35", "2024-09-30 08:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7688", "2572", "ایجاد فعالیت", "2024-09-30 07:51:43", "2024-09-30 11:21:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7689", "2572", "عملیات توسط WP Cron شروع شد", "2024-09-30 07:53:49", "2024-09-30 11:23:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7690", "2572", "عملیات توسط WP Cron کامل شد", "2024-09-30 07:53:49", "2024-09-30 11:23:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7691", "2573", "ایجاد فعالیت", "2024-09-30 10:03:13", "2024-09-30 13:33:13");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("47", "2622", "designer2", "designer2@abzarwp.com", "", "78.39.83.10", "2023-08-06 10:44:28", "2023-08-06 07:14:28", "عالی", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36", "comment", "0", "39");
INSERT INTO `wp_comments` VALUES("48", "2622", "designer2", "designer2@abzarwp.com", "", "78.39.83.10", "2023-08-06 10:46:03", "2023-08-06 07:16:03", "ممنونم", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36", "comment", "47", "39");
INSERT INTO `wp_comments` VALUES("60", "2566", "designer3", "designer3@abzarwp.com", "", "78.39.83.10", "2024-05-27 14:15:30", "2024-05-27 10:45:30", "تست", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "comment", "0", "40");

/* INSERT TABLE DATA: wp_crocoblock_workflows */
INSERT INTO `wp_crocoblock_workflows` VALUES("1", "1", "jet-engine", "a:3:{s:8:\"workflow\";s:35:\"Create listing for CPT from scratch\";s:11:\"description\";s:176:\"A guide to creating the most basic listing – a listing for CPT based on a query from Query Builder. This could be a good starting point to understand JetEngine possibilities.\";s:16:\"relatedWorkflows\";a:0:{}}", "a:4:{i:0;a:6:{s:4:\"name\";s:18:\"Create a Post Type\";s:4:\"help\";s:327:\"<p>Post Type is the most basic way of storing various pieces of content. Is a tool for creating unique content types, offering more features and fields than standard WordPress posts and pages.</p>Before starting, you need to add a new one.</p><p>If you already have the Post Type you need, you can proceed to the next step.</p>\";s:8:\"tutorial\";s:107:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-a-custom-post-type-based-on-jetengine-plugin/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"admin.php?page=jet-engine-cpt&cpt_action=add\";s:5:\"label\";s:14:\"Create new CPT\";}s:7:\"minTime\";i:3;s:7:\"maxTime\";i:10;}i:1;a:6:{s:4:\"name\";s:36:\"Create a new query for the Post Type\";s:4:\"help\";s:466:\"<p>Query is a base tool for getting any data from database. In this case you need a query to get the posts. But you can use it to get almost any data. On the next step you will use this query as data source for your listing.</p><p>When creating a Query, please make sure you selected the previously created CPT in the <b>Post Type</b> option in the Posts Query’s <b>General</b> settings.</p><p>If you already have a query for this CPT, you can go to next step.</p>\";s:8:\"tutorial\";s:79:\"https://crocoblock.com/knowledge-base/jetengine/query-builder-posts-query-type/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:48:\"admin.php?page=jet-engine-query&query_action=add\";s:5:\"label\";s:16:\"Create new Query\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:4;}i:2;a:6:{s:4:\"name\";s:48:\"Create a listing item based on the created Query\";s:4:\"help\";s:332:\"<p>Listing item represents a single element of your future listing. Here you can set up content, layout, and design of a listing item.</p><p>To use the previously created Query as a source for your listing item, you need to set <b>Listing source</b> to <b>Query Builder</b> and then select your Query in the <b>Query</b> option.</p>\";s:8:\"tutorial\";s:143:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-query-builder-listing-template/#create-listing-template-with-query-builder-source\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"edit.php?post_type=jet-engine#add_new__query\";s:5:\"label\";s:32:\"Create new listing item template\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:10;}i:3;a:6:{s:4:\"name\";s:32:\"Add listing to the selected page\";s:4:\"help\";s:226:\"The last step is to add a new listing, based on the previously created listing item and Query, to the selected page. To do this, you need to use the <b>Listing Grid</b> widget (block/element, depending on the builder you use).\";s:8:\"tutorial\";s:76:\"https://crocoblock.com/knowledge-base/features/listing-grid-widget-overview/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:23:\"edit.php?post_type=page\";s:5:\"label\";s:15:\"Go to all pages\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}}");
INSERT INTO `wp_crocoblock_workflows` VALUES("2", "2", "jet-engine", "a:3:{s:8:\"workflow\";s:21:\"Show posts on the map\";s:11:\"description\";s:83:\"A guide to showcasing your posts listing on the map using the Maps Listings module.\";s:16:\"relatedWorkflows\";a:0:{}}", "a:5:{i:0;a:7:{s:4:\"name\";s:31:\"Set up the Maps Listings module\";s:4:\"help\";s:316:\"<p>Before starting, you need to prepare Maps to work:</p><ul><li>Select <b>Map Provider</b> and <b>Geocoding Provider</b> to be used</li><li>Set up <b>API keys or tokens</b> for this provider (if needed)</li></ul><p>All these things can be done in the <b>Maps Settings</b> section on <b>JetEngine</b> admin page.</p>\";s:8:\"tutorial\";s:108:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-choosing-different-map-providers-for-map-listings/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:39:\"admin.php?page=jet-engine#maps_settings\";s:5:\"label\";s:23:\"Configure Maps settings\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:8;s:10:\"dependency\";a:3:{s:5:\"label\";s:29:\"Activate Maps Listings module\";s:4:\"type\";s:17:\"jet_engine_module\";s:6:\"module\";s:13:\"maps-listings\";}}i:1;a:6:{s:4:\"name\";s:35:\"Add a Map Field to the selected CPT\";s:4:\"help\";s:314:\"<p>The best way to set coordinates for a post on the map is by using the <b>Map</b> meta field. Just add this field type to the CPT which you want to showcase on the map.</p><p>Then go to CPT edit page and select a proper location for all the posts you need. Now your posts are ready to use with Maps Listings.</p>\";s:8:\"tutorial\";s:77:\"https://crocoblock.com/knowledge-base/features/meta-field-types-overview/#map\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:30:\"admin.php?page=jet-engine-meta\";s:5:\"label\";s:24:\"Go to Meta Boxes manager\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}i:2;a:6:{s:4:\"name\";s:36:\"Create a new Query for the Post Type\";s:4:\"help\";s:289:\"<p>Query is a base tool for getting any data from DB. When creating a Query, please make sure you selected the previously created CPT in the <b>Post Type</b> option in the Posts Query’s <b>General</b> settings.</p><p>If you already have a query for this CPT, you can go to next step.</p>\";s:8:\"tutorial\";s:79:\"https://crocoblock.com/knowledge-base/jetengine/query-builder-posts-query-type/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:48:\"admin.php?page=jet-engine-query&query_action=add\";s:5:\"label\";s:16:\"Create new Query\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:4;}i:3;a:6:{s:4:\"name\";s:48:\"Create a listing item based on the created Query\";s:4:\"help\";s:629:\"<p>Listing item represents a single element of your future listing. In case of the map, listing item - is a content of popup you see, when click on map marker.</p><p>You can add any data you want, setup layout and design of a listing item. As mentioned before, on the map, listing items will be shown in the informational pop-up after you clicking a corresponding marker and represents the data of the post, related to this marker.</p><p>To use the previously created Query as a source for your listing item, you need to set <b>Listing source</b> to <b>Query Builder</b> and then select your Query in the <b>Query</b> option.</p>\";s:8:\"tutorial\";s:143:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-query-builder-listing-template/#create-listing-template-with-query-builder-source\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"edit.php?post_type=jet-engine#add_new__query\";s:5:\"label\";s:32:\"Create new listing item template\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:10;}i:4;a:6:{s:4:\"name\";s:40:\"Add the Map Listing to the selected page\";s:4:\"help\";s:618:\"<p>Now you can add map listing, based on the previously created listing item and Query, to the selected page. To do this, you need to use the <b>Map Listing</b> widget (block/element, depending on the builder you use).</p><p>After adding a <b>Map Listing</b> widget/block to the page content, you need to set these options to make sure it will work:</p><ul><li><b>Listing</b> – the listing item you created before</li><li><b>Address Meta Field</b> – here you need to set the name/ID of a Map meta field you created on Step 2</li><li>Set a marker icon for your post on the map in the <b>Marker</b> section</li></ul>\";s:8:\"tutorial\";s:101:\"https://crocoblock.com/knowledge-base/features/map-listing-overview/#map-listing-widgetblock-overview\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:23:\"edit.php?post_type=page\";s:5:\"label\";s:15:\"Go to all pages\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}}");
INSERT INTO `wp_crocoblock_workflows` VALUES("3", "3", "jet-engine", "a:4:{s:8:\"workflow\";s:59:\"Add Favorites/Wishlist functionality via Data Stores module\";s:11:\"description\";s:135:\"A guide to creating the \'Add to favorites/wishlist\' button and Favorites/Wishlist listing on your website using the Data Stores module.\";s:16:\"relatedWorkflows\";a:0:{}s:12:\"fullTutorial\";s:86:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-data-stores-module-overview/\";}", "a:5:{i:0;a:7:{s:4:\"name\";s:23:\"Create a new Data Store\";s:4:\"help\";s:545:\"<p>Data Stores allow you to create user-specific storages for some collections of item IDs (for example, post IDs, user IDs, term IDs, etc.). This functionality lets you add Wishlists, Favorites, Bookmarks, etc., to your website.</p><p>The Data Stores module gives tools for users to add/remove items from such storages and showcase storage data via the Listing Grid widget.</p><p>To start, you need to create your first Data Store. Each type of Data Store has its own specifics; for a quick start, we recommend using the Cookies store type.</p>\";s:8:\"tutorial\";s:108:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-data-stores-module-overview/#creating-a-data-store\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:37:\"admin.php?page=jet-engine#data_stores\";s:5:\"label\";s:17:\"Create Data Store\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;s:10:\"dependency\";a:3:{s:5:\"label\";s:27:\"Activate Data Stores module\";s:4:\"type\";s:17:\"jet_engine_module\";s:6:\"module\";s:11:\"data-stores\";}}i:1;a:6:{s:4:\"name\";s:50:\"Allow users to add items to the created Data Store\";s:4:\"help\";s:579:\"<p>Once you have created a Data Store, you need to enable your website visitors to add items to this store.</p><p>You can use the <b>Data Store Button</b> widget/block for this. Add this widget/block where you need the \'Add to Favorites/Wishlist\' button. This could be:</p><ul><li>Listing of posts (or any other items you want to store)</li><li>Single post template of posts you want to store</li><li>Single user page, if you want to store user IDs</li></ul><p>In widget/block settings, make sure to select the previously created Data Store in the <b>Select store</b> option.</p>\";s:8:\"tutorial\";s:82:\"https://crocoblock.com/knowledge-base/jetengine/data-store-button-widget-overview/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:29:\"edit.php?post_type=jet-engine\";s:5:\"label\";s:19:\"Go to Listing Items\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:3;}i:2;a:6:{s:4:\"name\";s:43:\"Create a query to get items from Data Store\";s:4:\"help\";s:713:\"<p>Before you showcase stored items from a website visitor, you need to query these items from the database. JetEngine has a unified tool to query any data from the database – Query Builder. In this tutorial, we\'ll cover a case when you store posts. For other types of content, the routine will be very similar.</p><p>So, you need to:</p><ul><li>Create a new query and select a <b>Post Type</b> to be stored in the Post Type option.</li><li>Go to the <b>Post & Page</b> tab</li><li>In the <b>Post In</b> option, press the database icon to the right from the input.</li><li>In the dynamic arguments list, select <b>Get store</b>.</li><li>In the <b>Store</b> option, select the previously created store.</li></ul>\";s:8:\"tutorial\";s:137:\"https://crocoblock.com/knowledge-base/jetengine/jetengine-data-stores-module-overview/#creating-a-posts-query-via-jetengine-query-builder\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:48:\"admin.php?page=jet-engine-query&query_action=add\";s:5:\"label\";s:13:\"Add new Query\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:3;}i:3;a:6:{s:4:\"name\";s:48:\"Create a listing item based on the created query\";s:4:\"help\";s:533:\"<p>Listing item represents a single element of your future listing.</p><p>To use the previously created Query as a source for your listing item, you need to set <b>Listing source</b> to <b>Query Builder</b> and then select your Query in the <b>Query</b> option.</p><p><b>Please note!</p> Make sure you\'ve added at least one post to the Data Store by yourself for the listing preview to work correctly.</p><p>Also, you can use any listing item created for the same Post Type and select a previously created Query on the next step.</p>\";s:8:\"tutorial\";s:143:\"https://crocoblock.com/knowledge-base/jetengine/how-to-create-query-builder-listing-template/#create-listing-template-with-query-builder-source\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:44:\"edit.php?post_type=jet-engine#add_new__query\";s:5:\"label\";s:32:\"Create new Listing item template\";}s:7:\"minTime\";i:2;s:7:\"maxTime\";i:10;}i:4;a:6:{s:4:\"name\";s:32:\"Add listing to the selected page\";s:4:\"help\";s:549:\"<p>The last step is to add a new listing, based on the previously created listing item and Query, to the selected page. To do this, you need to use the <b>Listing Grid</b> widget (block/element, depending on the builder you use).</p><p>If you didn\'t create a new listing item in the previous step and want to use a different listing item for the Favorites query, go to the Custom Query section in the Listing Grid widget/block settings and enable the Use Custom Query option. Then, select the previously created query in the Custom Query option.</p>\";s:8:\"tutorial\";s:76:\"https://crocoblock.com/knowledge-base/features/listing-grid-widget-overview/\";s:7:\"stepURL\";a:2:{s:3:\"url\";s:23:\"edit.php?post_type=page\";s:5:\"label\";s:15:\"Go to all pages\";}s:7:\"minTime\";i:1;s:7:\"maxTime\";i:2;}}");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("29", "20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8", "d75d5bb59abce75c1104_20240930095855", "21", "2024-09-30 10:04:24", "designer", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-30 09:58:55\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.8\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:29;s:4:\"Name\";s:39:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"d75d5bb59abce75c1104_20240930095855\";s:8:\"NameHash\";s:75:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.2\";s:6:\"WPUser\";s:8:\"designer\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/meharat/public_html/laptop-shop\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:5496;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:29958;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-09-30 09:58:55\";s:7:\"Version\";s:6:\"1.5.11\";s:9:\"VersionWP\";s:5:\"6.6.2\";s:9:\"VersionDB\";s:7:\"10.11.8\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"d75d5bb59abce75c1104_20240930095855\";s:8:\"NameHash\";s:75:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/meharat/public_html/laptop-shop/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:158:\"/home/meharat/public_html/laptop-shop/wp-content/backups-dup-lite/tmp/20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d75d5bb59abce75c1104_20240930095855_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/meharat/public_html/laptop-shop/wp-admin\";i:1;s:49:\"/home/meharat/public_html/laptop-shop/wp-includes\";i:2;s:58:\"/home/meharat/public_html/laptop-shop/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/meharat/public_html/laptop-shop\";i:1;s:37:\"/home/meharat/public_html/laptop-shop\";i:2;s:48:\"/home/meharat/public_html/laptop-shop/wp-content\";i:3;s:56:\"/home/meharat/public_html/laptop-shop/wp-content/uploads\";i:4;s:56:\"/home/meharat/public_html/laptop-shop/wp-content/plugins\";i:5;s:59:\"/home/meharat/public_html/laptop-shop/wp-content/mu-plugins\";i:6;s:55:\"/home/meharat/public_html/laptop-shop/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/meharat/public_html/laptop-shop/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_jet_cct_customers_comments */
INSERT INTO `wp_jet_cct_customers_comments` VALUES("1", "publish", "ویدا محمدی", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "5", "12322", "38", "2024-07-23 11:09:29", "2024-09-16 13:48:52");
INSERT INTO `wp_jet_cct_customers_comments` VALUES("2", "publish", "زهرا رسولی", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "4", "12321", "38", "2024-07-23 11:11:21", "2024-09-16 13:48:26");
INSERT INTO `wp_jet_cct_customers_comments` VALUES("3", "publish", "مهسا منصوری", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "5", "12321", "38", "2024-07-23 11:11:33", "2024-09-16 13:48:00");
INSERT INTO `wp_jet_cct_customers_comments` VALUES("4", "publish", "یلدا کرمی", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "3", "12320", "38", "2024-07-23 11:11:54", "2024-09-16 13:47:34");

/* INSERT TABLE DATA: wp_jet_post_types */
INSERT INTO `wp_jet_post_types` VALUES("7", NULL, "query", "a:1:{s:4:\"name\";s:37:\"کوئری پرفروش ترین ها\";}", "a:17:{s:10:\"query_type\";s:5:\"posts\";s:5:\"posts\";a:6:{s:7:\"orderby\";a:1:{i:0;a:5:{s:3:\"_id\";i:450621;s:9:\"collapsed\";b:0;s:7:\"orderby\";s:14:\"meta_value_num\";s:5:\"order\";s:4:\"DESC\";s:8:\"meta_key\";s:11:\"total_sales\";}}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:10:\"date_query\";a:0:{}s:9:\"post_type\";a:1:{i:0;s:7:\"product\";}s:14:\"posts_per_page\";s:1:\"5\";}s:15:\"__dynamic_posts\";a:3:{s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:10:\"date_query\";a:0:{}}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("29", "comparecompare", "data-store", "a:1:{s:4:\"name\";s:7:\"compare\";}", "a:8:{s:4:\"type\";s:7:\"cookies\";s:4:\"size\";i:999;s:11:\"count_posts\";b:1;s:7:\"is_user\";b:0;s:13:\"store_on_view\";b:0;s:12:\"on_post_type\";s:0:\"\";s:6:\"is_cct\";b:0;s:11:\"related_cct\";s:0:\"\";}", NULL);
INSERT INTO `wp_jet_post_types` VALUES("26", NULL, "query", "a:1:{s:4:\"name\";s:47:\"کوئری محصولات صفحات آرشیو\";}", "a:17:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:7:{s:14:\"specific_query\";a:0:{}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:384087;s:9:\"collapsed\";b:0;s:8:\"taxonomy\";s:11:\"product_cat\";s:5:\"field\";s:7:\"term_id\";}}s:6:\"status\";a:1:{i:0;s:7:\"publish\";}s:5:\"limit\";s:2:\"12\";}s:26:\"__dynamic_wc-product-query\";a:3:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:384087;a:1:{s:5:\"terms\";s:42:\"%queried_term%{\"context\":\"default_object\"}\";}}}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("27", NULL, "query", "a:1:{s:4:\"name\";s:48:\"کوئری دسته های والد مقالات\";}", "a:17:{s:10:\"query_type\";s:5:\"terms\";s:5:\"terms\";a:4:{s:10:\"meta_query\";a:0:{}s:8:\"taxonomy\";a:1:{i:0;s:8:\"category\";}s:6:\"parent\";s:0:\"\";s:10:\"hide_empty\";b:1;}s:15:\"__dynamic_terms\";a:2:{s:10:\"meta_query\";a:0:{}s:7:\"exclude\";s:42:\"%queried_term%{\"context\":\"default_object\"}\";}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";s:8:\"catquery\";s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("28", NULL, "query", "a:1:{s:4:\"name\";s:34:\"کوئری آرشیو مقالات\";}", "a:17:{s:10:\"query_type\";s:5:\"posts\";s:5:\"posts\";a:8:{s:7:\"orderby\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:6044;s:9:\"collapsed\";b:0;s:8:\"taxonomy\";s:8:\"category\";s:5:\"field\";s:7:\"term_id\";}}s:10:\"date_query\";a:0:{}s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:11:\"post_status\";a:1:{i:0;s:7:\"publish\";}s:14:\"posts_per_page\";s:1:\"9\";s:4:\"page\";s:0:\"\";}s:15:\"__dynamic_posts\";a:3:{s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:6044;a:1:{s:5:\"terms\";s:42:\"%queried_term%{\"context\":\"default_object\"}\";}}s:10:\"date_query\";a:0:{}}s:12:\"show_preview\";b:1;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";s:0:\"\";s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("20", NULL, "query", "a:1:{s:4:\"name\";s:43:\"کوئری محصولات تخفیف دار\";}", "a:17:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:6:{s:14:\"specific_query\";a:0:{}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:5:\"limit\";s:1:\"5\";}s:26:\"__dynamic_wc-product-query\";a:4:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:7:\"include\";s:49:\"%wc_products_on_sale%{\"context\":\"default_object\"}\";}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("21", NULL, "query", "a:1:{s:4:\"name\";s:36:\"کوئری نتایج جست و جو\";}", "a:9:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:8:{s:14:\"specific_query\";a:0:{}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:6:\"status\";a:1:{i:0;s:7:\"publish\";}s:12:\"search_query\";b:1;s:5:\"limit\";s:2:\"12\";}s:26:\"__dynamic_wc-product-query\";a:3:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}}s:12:\"show_preview\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("30", "favorite", "data-store", "a:1:{s:4:\"name\";s:8:\"favorite\";}", "a:8:{s:4:\"type\";s:7:\"cookies\";s:4:\"size\";i:999;s:11:\"count_posts\";b:1;s:7:\"is_user\";b:0;s:13:\"store_on_view\";b:0;s:12:\"on_post_type\";s:0:\"\";s:6:\"is_cct\";b:0;s:11:\"related_cct\";s:0:\"\";}", NULL);
INSERT INTO `wp_jet_post_types` VALUES("32", NULL, "query", "a:1:{s:4:\"name\";s:34:\"کوئری مقالات مرتبط\";}", "a:17:{s:10:\"query_type\";s:5:\"posts\";s:5:\"posts\";a:7:{s:7:\"orderby\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:792589;s:9:\"collapsed\";b:0;s:8:\"taxonomy\";s:8:\"category\";s:5:\"field\";s:7:\"term_id\";}}s:10:\"date_query\";a:0:{}s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:11:\"post_status\";a:1:{i:0;s:7:\"publish\";}s:14:\"posts_per_page\";s:1:\"5\";}s:15:\"__dynamic_posts\";a:4:{s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:792589;a:1:{s:5:\"terms\";s:48:\"%current_categories%{\"context\":\"default_object\"}\";}}s:10:\"date_query\";a:0:{}s:12:\"post__not_in\";s:40:\"%current_id%{\"context\":\"default_object\"}\";}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("31", NULL, "query", "a:1:{s:4:\"name\";s:36:\"کوئری محصولات مرتبط\";}", "a:17:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:7:{s:14:\"specific_query\";a:0:{}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:510248;s:9:\"collapsed\";b:0;s:8:\"taxonomy\";s:11:\"product_cat\";s:5:\"field\";s:7:\"term_id\";}}s:6:\"status\";a:1:{i:0;s:7:\"publish\";}s:5:\"limit\";s:1:\"5\";}s:26:\"__dynamic_wc-product-query\";a:4:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:510248;a:1:{s:5:\"terms\";s:42:\"%queried_term%{\"context\":\"default_object\"}\";}}s:7:\"exclude\";s:40:\"%current_id%{\"context\":\"default_object\"}\";}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";a:0:{}s:10:\"api_schema\";a:1:{i:0;a:2:{s:3:\"arg\";s:0:\"\";s:5:\"value\";s:0:\"\";}}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("24", "customers_comments", "content-type", NULL, "a:20:{s:10:\"has_single\";b:0;s:12:\"create_index\";b:0;s:16:\"rest_get_enabled\";b:0;s:16:\"rest_put_enabled\";b:0;s:17:\"rest_post_enabled\";b:0;s:19:\"rest_delete_enabled\";b:0;s:16:\"hide_field_names\";b:0;s:4:\"name\";s:25:\"نظرات مشتریان\";s:4:\"slug\";s:18:\"customers_comments\";s:8:\"position\";i:59;s:4:\"icon\";s:16:\"dashicons-smiley\";s:10:\"capability\";s:14:\"manage_options\";s:17:\"related_post_type\";s:0:\"\";s:23:\"related_post_type_title\";s:0:\"\";s:25:\"related_post_type_content\";s:0:\"\";s:15:\"rest_get_access\";s:0:\"\";s:15:\"rest_put_access\";s:10:\"edit_posts\";s:16:\"rest_post_access\";s:10:\"edit_posts\";s:18:\"rest_delete_access\";s:10:\"edit_posts\";s:13:\"admin_columns\";a:10:{s:3:\"_ID\";a:4:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:1;s:6:\"is_num\";b:1;s:6:\"prefix\";s:1:\"#\";}s:18:\"cct_single_post_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:13:\"cct_author_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"cct_created\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:12:\"cct_modified\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:10:\"cct_status\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:13:\"customer_name\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:16:\"customer_opinion\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:7:\"scoring\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:14:\"customer_image\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}}}", "a:4:{i:0;a:10:{s:5:\"title\";s:17:\"نام مشتری\";s:4:\"name\";s:13:\"customer_name\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:9:\"33.33333%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:9945;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:1;a:10:{s:5:\"title\";s:17:\"نظر مشتری\";s:4:\"name\";s:16:\"customer_opinion\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:3:\"75%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:8:\"textarea\";s:2:\"id\";i:7439;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}i:2;a:12:{s:5:\"title\";s:18:\"امتیازدهی\";s:4:\"name\";s:7:\"scoring\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:3:\"25%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:4675;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:9:\"min_value\";s:1:\"1\";s:9:\"max_value\";s:1:\"5\";}i:3;a:10:{s:5:\"title\";s:21:\"تصویر مشتری\";s:4:\"name\";s:14:\"customer_image\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:9:\"33.33333%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:5:\"media\";s:2:\"id\";i:6163;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}}");
INSERT INTO `wp_jet_post_types` VALUES("33", NULL, "query", "a:1:{s:4:\"name\";s:50:\"کوئری دسته های والد محصولات\";}", "a:9:{s:10:\"query_type\";s:5:\"terms\";s:5:\"terms\";a:3:{s:10:\"meta_query\";a:0:{}s:8:\"taxonomy\";a:1:{i:0;s:11:\"product_cat\";}s:6:\"parent\";s:1:\"0\";}s:15:\"__dynamic_terms\";a:1:{s:10:\"meta_query\";a:0:{}}s:12:\"show_preview\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("34", NULL, "query", "a:1:{s:4:\"name\";s:47:\"کوئری آرشیو محصولات - برند\";}", "a:17:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:7:{s:14:\"specific_query\";a:0:{}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:872393;s:9:\"collapsed\";b:0;s:8:\"taxonomy\";s:8:\"pa_brand\";s:5:\"field\";s:7:\"term_id\";}}s:6:\"status\";a:1:{i:0;s:7:\"publish\";}s:5:\"limit\";s:2:\"12\";}s:26:\"__dynamic_wc-product-query\";a:3:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:872393;a:1:{s:5:\"terms\";s:42:\"%queried_term%{\"context\":\"default_object\"}\";}}}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";N;s:10:\"api_schema\";N;}", "a:0:{}");

/* INSERT TABLE DATA: wp_jet_smart_filters_indexer */
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("929", "post", "9817", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("928", "post", "9817", "tax_query", "product_cat", "396");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("927", "post", "9817", "tax_query", "pa_color", "423");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("926", "post", "9817", "tax_query", "pa_brand", "421");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("852", "post", "9852", "tax_query", "pa_brand", "421");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("853", "post", "9852", "tax_query", "product_cat", "396");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("854", "post", "9852", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("835", "post", "9910", "tax_query", "pa_color", "422");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("836", "post", "9910", "tax_query", "pa_brand", "421");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("837", "post", "9910", "tax_query", "product_cat", "396");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("838", "post", "9910", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("830", "post", "9977", "tax_query", "pa_proccessor", "460");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("831", "post", "9977", "tax_query", "pa_brand", "429");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("832", "post", "9977", "tax_query", "pa_application", "468");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("833", "post", "9977", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("834", "post", "9977", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("925", "post", "10093", "tax_query", "pa_color", "406");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("924", "post", "10093", "tax_query", "pa_brand", "434");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("923", "post", "10093", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("922", "post", "10093", "tax_query", "pa_application", "468");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("921", "post", "10093", "tax_query", "pa_color", "430");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("920", "post", "10093", "tax_query", "pa_proccessor", "460");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("901", "post", "10111", "tax_query", "pa_proccessor", "461");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("902", "post", "10111", "tax_query", "pa_color", "430");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("903", "post", "10111", "tax_query", "pa_application", "469");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("904", "post", "10111", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("905", "post", "10111", "tax_query", "pa_brand", "434");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("891", "post", "10165", "tax_query", "pa_application", "468");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("892", "post", "10165", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("893", "post", "10165", "tax_query", "pa_application", "470");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("894", "post", "10165", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("886", "post", "10183", "tax_query", "pa_application", "469");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("887", "post", "10183", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("851", "post", "10268", "tax_query", "pa_color", "427");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("850", "post", "10268", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("849", "post", "10268", "tax_query", "pa_application", "470");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("848", "post", "10268", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("847", "post", "10268", "tax_query", "pa_brand", "438");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("846", "post", "10268", "tax_query", "pa_proccessor", "461");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("934", "post", "10287", "tax_query", "pa_color", "406");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("933", "post", "10287", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("932", "post", "10287", "tax_query", "pa_application", "468");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("931", "post", "10287", "tax_query", "pa_brand", "437");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("762", "post", "10299", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("763", "post", "10299", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("876", "post", "10419", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("941", "post", "10425", "tax_query", "pa_application", "470");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("940", "post", "10425", "tax_query", "pa_application", "468");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("939", "post", "10425", "tax_query", "product_cat", "475");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("938", "post", "10425", "tax_query", "pa_color", "430");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("937", "post", "10425", "tax_query", "pa_brand", "438");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("930", "post", "10287", "tax_query", "pa_proccessor", "457");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("885", "post", "10183", "tax_query", "pa_color", "430");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("884", "post", "10183", "tax_query", "pa_brand", "437");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("882", "post", "10183", "tax_query", "pa_proccessor", "457");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("883", "post", "10183", "tax_query", "pa_proccessor", "459");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("782", "post", "10213", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("781", "post", "10213", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("780", "post", "10213", "tax_query", "pa_application", "469");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("779", "post", "10213", "tax_query", "pa_brand", "437");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("760", "post", "10299", "tax_query", "pa_brand", "444");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("761", "post", "10299", "tax_query", "pa_color", "412");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("757", "post", "10311", "tax_query", "pa_brand", "437");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("758", "post", "10311", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("759", "post", "10311", "tax_query", "pa_color", "406");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("890", "post", "10165", "tax_query", "pa_application", "469");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("888", "post", "10165", "tax_query", "pa_proccessor", "460");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("889", "post", "10165", "tax_query", "pa_brand", "405");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("900", "post", "10144", "tax_query", "pa_color", "408");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("899", "post", "10144", "tax_query", "product_cat", "19");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("895", "post", "10144", "tax_query", "pa_proccessor", "458");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("896", "post", "10144", "tax_query", "pa_proccessor", "457");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("897", "post", "10144", "tax_query", "pa_brand", "405");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("898", "post", "10144", "tax_query", "pa_application", "469");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("756", "post", "10311", "tax_query", "pa_proccessor", "457");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("936", "post", "10425", "tax_query", "pa_color", "422");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("935", "post", "10425", "tax_query", "pa_proccessor", "462");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("875", "post", "10419", "tax_query", "pa_application", "468");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("874", "post", "10419", "tax_query", "product_cat", "475");
INSERT INTO `wp_jet_smart_filters_indexer` VALUES("873", "post", "10419", "tax_query", "pa_proccessor", "459");

/* INSERT TABLE DATA: wp_jet_taxonomies */
INSERT INTO `wp_jet_taxonomies` VALUES("1", "product_cat", "a:1:{i:0;s:7:\"product\";}", "built-in", "a:0:{}", "a:1:{s:10:\"with_front\";b:1;}", "a:0:{}");
INSERT INTO `wp_jet_taxonomies` VALUES("2", "pa_brand", NULL, "built-in", "a:0:{}", "a:0:{}", "a:1:{i:0;a:10:{s:5:\"title\";s:19:\"تصویر برند\";s:4:\"name\";s:11:\"brand-image\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:4:\"type\";s:5:\"media\";s:9:\"collapsed\";b:0;s:2:\"id\";i:3698;s:8:\"isNested\";b:0;s:12:\"value_format\";s:4:\"both\";}}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://meharat.com/laptop-shop", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://meharat.com/laptop-shop", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "سایت آماده فروشگاه لپتاپ و کامپیوتر", "on");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت آماده دیگر از ابزار وردپرس", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "designer@abzarwp.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:236:{s:11:\"jsf/(.*)/?$\";s:25:\"index.php?jsf=$matches[1]\";s:16:\"shop/jsf/(.*)/?$\";s:43:\"index.php?post_type=product&jsf=$matches[1]\";s:20:\"([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:19:\"(.?.+?)/jsf/(.*)/?$\";s:46:\"index.php?pagename=$matches[1]&jsf=$matches[2]\";s:19:\"([^/]+)/jsf/(.*)/?$\";s:42:\"index.php?name=$matches[1]&jsf=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:24:\"^custom_wp_die_action/?$\";s:32:\"index.php?custom_wp_die_action=1\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:51:\"e-landing-page/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?e-landing-page=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"e-landing-page/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:46:\"brand/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pa_brand=$matches[1]&feed=$matches[2]\";s:41:\"brand/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pa_brand=$matches[1]&feed=$matches[2]\";s:22:\"brand/([^/]+)/embed/?$\";s:41:\"index.php?pa_brand=$matches[1]&embed=true\";s:34:\"brand/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pa_brand=$matches[1]&paged=$matches[2]\";s:16:\"brand/([^/]+)/?$\";s:30:\"index.php?pa_brand=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=3768&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("38733", "duplicator_settings", "a:19:{s:7:\"version\";s:6:\"1.5.11\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:29;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("36346", "jet_woo_builder[widgets_render_method]", "macros", "yes");
INSERT INTO `wp_options` VALUES("36347", "jet_woo_builder[custom_shop_page]", "", "yes");
INSERT INTO `wp_options` VALUES("36348", "jet_woo_builder[shop_template]", "", "yes");
INSERT INTO `wp_options` VALUES("36349", "jet_woo_builder[custom_taxonomy_template]", "", "yes");
INSERT INTO `wp_options` VALUES("36350", "jet_woo_builder[custom_single_page]", "", "yes");
INSERT INTO `wp_options` VALUES("36351", "jet_woo_builder[single_template]", "", "yes");
INSERT INTO `wp_options` VALUES("36352", "jet_woo_builder[custom_archive_page]", "", "yes");
INSERT INTO `wp_options` VALUES("36353", "jet_woo_builder[archive_template]", "", "yes");
INSERT INTO `wp_options` VALUES("2024", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:14:{i:0;s:25:\"demo-modal/demo-modal.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:31:\"elementor-pro/elementor-pro.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:53:\"jet-engine-trim-callback/jet-engine-trim-callback.php\";i:6;s:25:\"jet-engine/jet-engine.php\";i:7;s:24:\"jet-plugin-pro/index.php\";i:8;s:25:\"jet-search/jet-search.php\";i:9;s:39:\"jet-smart-filters/jet-smart-filters.php\";i:10;s:25:\"jet-tricks/jet-tricks.php\";i:11;s:49:\"variation-swatches-woo/variation-swatches-woo.php\";i:12;s:27:\"woocommerce/woocommerce.php\";i:14;s:29:\"wp-parsidate/wp-parsidate.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34989", "dokan-lite_tracking_last_send", "1668352466", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:4:{i:0;s:85:\"/home/meharat/public_html/laptop-shop/wp-content/themes/hello-elementor/functions.php\";i:1;s:81:\"/home/meharat/public_html/laptop-shop/wp-content/themes/hello-elementor/style.css\";i:3;s:74:\"/home/meharat/public_html/laptop-shop/wp-content/themes/woodmart/style.css\";i:4;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "hello-elementor", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "hello-elementor", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "customer", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "57155", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "23", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "3768", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "16448", "on");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1735195159", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:164:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:28:\"dokan_manage_support_tickets\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:135:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:28:\"dokan_manage_support_tickets\";b:1;}}s:6:\"seller\";a:2:{s:4:\"name\";s:14:\"فروشنده\";s:12:\"capabilities\";a:67:{s:4:\"read\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:17:\"manage_categories\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:16:\"edit_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:28:\"dokan_manage_support_tickets\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"sidebar-store\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("16485", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:27:{i:1727690698;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1727692177;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727692200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727692866;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727693447;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1727693956;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727694036;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1727697509;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"252d3b842da16809d398b2ca6d28a99c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:16666;}}}}i:1727703115;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727709210;a:1:{s:30:\"abzarwp_app_send_updates_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727713905;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727714466;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727724705;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727724752;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1727730000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727757666;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727757684;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727757988;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727758718;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727764233;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727773156;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1727844066;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1727852025;a:1:{s:28:\"dokan-pro_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1728002771;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1728058062;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1728653565;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("43206", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("43252", "wcpay_was_in_use", "no", "yes");
INSERT INTO `wp_options` VALUES("3000", "elementor_experiment-theme_builder_v2", "default", "yes");
INSERT INTO `wp_options` VALUES("68354", "woocommerce_attribute_lookup_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("364", "woocommerce_admin_version", "3.3.2", "yes");
INSERT INTO `wp_options` VALUES("122", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1652157886;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("335", "woocommerce_inbox_variant_assignment", "5", "yes");
INSERT INTO `wp_options` VALUES("342", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"Y7EqwVpC5whNtU2e5Plx1ybiRRXyeqlT\";}", "yes");
INSERT INTO `wp_options` VALUES("340", "action_scheduler_lock_async-request-runner", "66fa7781979444.78490007|1727690685", "yes");
INSERT INTO `wp_options` VALUES("341", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("344", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("345", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("346", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("347", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("348", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("349", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("350", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("351", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("352", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("353", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("354", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("355", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("356", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("357", "widget_woodmart-woocommerce-layered-nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("358", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("359", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("360", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("361", "widget_wd-widget-stock-status", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("365", "woocommerce_admin_install_timestamp", "1652157988", "yes");
INSERT INTO `wp_options` VALUES("366", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("125", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("150", "recently_activated", "a:3:{s:27:\"wp-optimize/wp-optimize.php\";i:1727690592;s:49:\"woo-variation-swatches/woo-variation-swatches.php\";i:1727525332;s:31:\"jet-compare-wishlist/jet-cw.php\";i:1727521821;}", "yes");
INSERT INTO `wp_options` VALUES("41710", "recently_activated_snippets", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("167", "woodmart_js_composer_version", "6.11.0", "yes");
INSERT INTO `wp_options` VALUES("156", "current_theme", "Hello Elementor", "yes");
INSERT INTO `wp_options` VALUES("157", "theme_mods_woodmart", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:0;s:11:\"mobile-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1683783650;s:4:\"data\";a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"sidebar-store\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-1\";a:0:{}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:0:{}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}}}}", "no");
INSERT INTO `wp_options` VALUES("158", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("159", "woodmart-generated-wpbcss-file", "", "yes");
INSERT INTO `wp_options` VALUES("160", "woodmart_is_activated", "", "yes");
INSERT INTO `wp_options` VALUES("38453", "xts-theme_settings_default-file-data", "a:3:{s:4:\"path\";s:50:\"/2023/04/xts-theme_settings_default-1682497107.css\";s:13:\"theme_version\";s:5:\"7.0.4\";s:8:\"site_url\";s:32:\"70179986750fbcdf04b7164c15fafd83\";}", "yes");
INSERT INTO `wp_options` VALUES("162", "xts-options-presets", "", "yes");
INSERT INTO `wp_options` VALUES("163", "xts-woodmart-options", "a:562:{s:12:\"last_message\";s:4:\"save\";s:11:\"insta_token\";s:0:\"\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:5:\"icons\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:23:\"stretch_product_desktop\";s:1:\"0\";s:22:\"stretch_product_tablet\";s:1:\"0\";s:22:\"stretch_product_mobile\";s:1:\"0\";s:25:\"product_title_lines_limit\";s:4:\"none\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_728002\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:227:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مرور این وب سایت، شما با استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1300\";s:11:\"main_layout\";s:10:\"full-width\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:7:\"disable\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:7:\"widgets\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:0:\"\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:0:\"\";s:11:\"copyrights2\";s:0:\"\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:13:\"rgb(21,21,21)\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:13:\"rgb(51,51,51)\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:13:\"rgb(51,51,51)\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:22:\"iranyekanwebbold_FaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:13:\"rgb(51,51,51)\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:1:{i:0;s:15:\"main_navigation\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:25:\"iranyekanwebregular_FaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"0\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:14:\"rgb(239,58,79)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(51,51,51)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(248,248,248)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:12:\"semi-rounded\";s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(239,58,79)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(51,51,51)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:15:\"btns_shop_style\";s:12:\"semi-rounded\";s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(239,58,79)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(51,51,51)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:17:\"btns_accent_style\";s:12:\"semi-rounded\";s:14:\"btns_accent_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(239,58,79)\";}s:20:\"btns_accent_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(51,51,51)\";}s:24:\"btns_accent_color_scheme\";s:5:\"light\";s:30:\"btns_accent_color_scheme_hover\";s:5:\"light\";s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:7:\"rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:16:\"rgb(235,235,235)\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:15:\"empty_cart_text\";s:232:\"قبل از شروع تسویه حساب، باید برخی از محصولات را به سبد خرید خود اضافه کنید.<br> در صفحه \"فروشگاه\" ما محصولات جالب زیادی خواهید یافت.\";s:19:\"quick_shop_variable\";s:1:\"1\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:7:\"rounded\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"15\";s:15:\"compare_on_grid\";s:1:\"1\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:191:\"هیچ محصولی در لیست مقایسه شما وجود ندارد. لطفا ابتدا از فروشگاه محصولاتی را به لیست مقایسه خود اضافه کنید.\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:20:\"single_product_style\";s:1:\"2\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:6:\"bottom\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"1\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:0:\"\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:13:\"ثبت نام\";s:8:\"reg_text\";s:489:\"ثبت نام در این سایت به شما امکان می دهد به وضعیت و سابقه سفارش خود دسترسی داشته باشید. کافی است فیلدهای زیر را پر کنید، و ما در کمترین زمان یک حساب کاربری جدید برای شما راه اندازی خواهیم کرد. ما فقط از شما اطلاعات لازم را برای سریع‌تر و آسان‌تر کردن فرآیند خرید می‌خواهیم.\";s:11:\"login_title\";s:8:\"ورود\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:20:\"old_elements_classes\";s:1:\"1\";s:12:\"combined_css\";s:1:\"0\";s:12:\"minified_css\";s:1:\"1\";s:23:\"light_bootstrap_version\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:29:\"disable_gutenberg_backend_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:11:\"combined_js\";s:1:\"0\";s:11:\"minified_js\";s:1:\"1\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:16:\"flickity_library\";s:8:\"required\";s:21:\"flickity-fade_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:11:\"owl_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:13:\"slick_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:28:\"load_elementor_optimized_css\";s:1:\"0\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"12\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:205:\"هیچ محصولی در لیست علاقه مندی شما وجود ندارد. لطفا ابتدا از فروشگاه محصولاتی را به لیست علاقه مندی خود اضافه کنید.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"include\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:16:\"reviews_location\";s:4:\"tabs\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:8:\"last_tab\";s:16:\"pages_bg_section\";}", "yes");
INSERT INTO `wp_options` VALUES("164", "woodmart_setup_status", "", "yes");
INSERT INTO `wp_options` VALUES("165", "wd_import_theme_version", "", "yes");
INSERT INTO `wp_options` VALUES("166", "woodmart-plugins-update-time", "1683783219", "yes");
INSERT INTO `wp_options` VALUES("177", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("180", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("181", "widget_woodmart-html-block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("182", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("183", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("184", "widget_wd-mailchimp-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("168", "woodmart_revslider_version", "6.6.13", "yes");
INSERT INTO `wp_options` VALUES("169", "wd_wishlist_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("170", "xts-theme_settings_default-css-data", ".wd-popup.wd-promo-popup{\n	background-color:#111111;\n	background-image: none;\n	background-repeat:no-repeat;\n	background-size:contain;\n	background-position:left center;\n}\n\n.page-title-default{\n	background-color:#0a0a0a;\n	background-image: none;\n	background-size:cover;\n	background-position:center center;\n}\n\n.footer-container{\n	background-color:#ffffff;\n	background-image: none;\n}\n\n:root{\n--wd-text-font:\"iranyekanwebregular_FaNum\", Arial, Helvetica, sans-serif;\n--wd-text-font-weight:400;\n--wd-text-color:rgb(21,21,21);\n--wd-text-font-size:14px;\n}\n:root{\n--wd-title-font:\"iranyekanwebregular_FaNum\", Arial, Helvetica, sans-serif;\n--wd-title-font-weight:400;\n--wd-title-color:rgb(51,51,51);\n}\n:root{\n--wd-entities-title-font:\"iranyekanwebregular_FaNum\", Arial, Helvetica, sans-serif;\n--wd-entities-title-font-weight:400;\n--wd-entities-title-color:rgb(51,51,51);\n--wd-entities-title-color-hover:rgb(51 51 51 / 65%);\n}\n:root{\n--wd-alternative-font:\"iranyekanwebregular_FaNum\", Arial, Helvetica, sans-serif;\n}\n:root{\n--wd-widget-title-font:\"iranyekanwebbold_FaNum\", Arial, Helvetica, sans-serif;\n--wd-widget-title-font-weight:400;\n--wd-widget-title-transform:none;\n--wd-widget-title-color:rgb(51,51,51);\n--wd-widget-title-font-size:16px;\n}\n:root{\n--wd-header-el-font:\"iranyekanwebregular_FaNum\", Arial, Helvetica, sans-serif;\n--wd-header-el-font-weight:400;\n--wd-header-el-transform:none;\n--wd-header-el-font-size:14px;\n}\nhtml .wd-nav.wd-nav-main > li > a{\n	font-family: \"iranyekanwebregular_FaNum\", Arial, Helvetica, sans-serif;font-size: 15px;\n}\n\n:root{\n--wd-primary-color:rgb(239,58,79);\n}\n:root{\n--wd-alternative-color:rgb(51,51,51);\n}\n:root{\n--wd-link-color:#333333;\n--wd-link-color-hover:#242424;\n}\nbody{\n	background-color:rgb(255,255,255);\n	background-image: none;\n}\n\n.page .main-page-wrapper{\n	background-color:rgb(255,255,255);\n	background-image: none;\n}\n\n.single-product .main-page-wrapper{\n	background-color:rgb(248,248,248);\n	background-image: none;\n}\n\n:root{\n--btn-default-bgcolor:rgb(239,58,79);\n}\n:root{\n--btn-default-bgcolor-hover:rgb(51,51,51);\n}\n:root{\n--btn-shop-bgcolor:rgb(239,58,79);\n}\n:root{\n--btn-shop-bgcolor-hover:rgb(51,51,51);\n}\n:root{\n--btn-accent-bgcolor:rgb(239,58,79);\n}\n:root{\n--btn-accent-bgcolor-hover:rgb(51,51,51);\n}\n:root{\n--notices-success-bg:#459647;\n}\n:root{\n--notices-success-color:#fff;\n}\n:root{\n--notices-warning-bg:#E0B252;\n}\n:root{\n--notices-warning-color:#fff;\n}\n	:root{\n									--wd-form-brd-radius: 35px;\n			\n			\n					\n					--wd-form-brd-width: 1px;\n		\n					--btn-default-color: #fff;\n		\n					--btn-default-color-hover: #fff;\n		\n					--btn-shop-color: #fff;\n		\n					--btn-shop-color-hover: #fff;\n		\n					--btn-accent-color: #fff;\n		\n					--btn-accent-color-hover: #fff;\n		\n					\n			\n			\n							--btn-default-brd-radius: 5px;\n				--btn-default-box-shadow: none;\n				--btn-default-box-shadow-hover: none;\n					\n					\n			\n			\n							--btn-shop-brd-radius: 5px;\n				--btn-shop-box-shadow: none;\n				--btn-shop-box-shadow-hover: none;\n					\n					\n			\n			\n							--btn-accent-brd-radius: 5px;\n				--btn-accent-box-shadow: none;\n				--btn-accent-box-shadow-hover: none;\n					\n									--wd-sticky-btn-height: 95px;\n					\n					--wd-brd-radius: 0px;\n			}\n\n			@media (max-width: 1024px) {\n			:root {\n				--wd-sticky-btn-height: 95px;\n			}\n		}\n	\n	\n			@media (min-width: 1025px) {\n			.whb-boxed:not(.whb-sticked):not(.whb-full-width) .whb-main-header {\n				max-width: 1270px;\n			}\n		}\n\n		.container {\n			max-width: 1300px;\n		}\n\n		:root{\n			--wd-container-width: 1300px;\n		}\n	\n			.elementor-section.wd-section-stretch > .elementor-column-gap-no {\n			max-width: 1270px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-narrow {\n			max-width: 1280px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-default {\n			max-width: 1290px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-extended {\n			max-width: 1300px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-wide {\n			max-width: 1310px;\n		}\n		.elementor-section.wd-section-stretch > .elementor-column-gap-wider {\n			max-width: 1330px;\n		}\n		@media (min-width: 1317px) {\n			.platform-Windows .wd-section-stretch > .elementor-container {\n				margin-left: auto;\n				margin-right: auto;\n			}\n		}\n		@media (min-width: 1300px) {\n			html:not(.platform-Windows) .wd-section-stretch > .elementor-container {\n				margin-left: auto;\n				margin-right: auto;\n			}\n		}\n	\n			div.wd-popup.popup-quick-view {\n			max-width: 920px;\n		}\n	\n	\n	\n	\n			.woodmart-woocommerce-layered-nav .wd-scroll-content {\n			max-height: 223px;\n		}\n	\n	\n	body, [class*=color-scheme-light], [class*=color-scheme-dark], .wd-search-form[class*=\"wd-header-search-form\"] form.searchform, .wd-el-search .searchform {\n\n							\n							\n									--wd-form-brd-color: rgb(235,235,235);\n					\n							\n								}\n@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//meharat.com/laptop-shop/wp-content/themes/woodmart/fonts/woodmart-font.woff2?v=7.0.4\") format(\"woff2\");\n}\n\n", "yes");
INSERT INTO `wp_options` VALUES("35295", "xts-header_728002-file-data", "a:3:{s:4:\"path\";s:41:\"/2022/11/xts-header_728002-1668433579.css\";s:13:\"theme_version\";s:5:\"7.0.3\";s:8:\"site_url\";s:32:\"510157fd743686ee478d2f4841ac3f9b\";}", "yes");
INSERT INTO `wp_options` VALUES("35289", "xts-header_728002-css-data", ".whb-top-bar .wd-dropdown {\n	margin-top: 0px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 10px;\n}\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n.whb-header .whb-header-bottom .wd-header-cats {\n	margin-top: -0px;\n	margin-bottom: -0px;\n	height: calc(100% + 0px);\n}\n\n\n@media (min-width: 1025px) {\n		.whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n\n		.whb-sticked .whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n		\n		.whb-general-header-inner {\n		height: 90px;\n		max-height: 90px;\n	}\n\n		.whb-sticked .whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n		\n		.whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n\n		.whb-sticked .whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n		\n	\n	}\n\n@media (max-width: 1024px) {\n		.whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n	\n		.whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n		.whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n	\n	\n	}\n		", "yes");
INSERT INTO `wp_options` VALUES("35290", "xts-header_728002-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("35291", "xts-header_728002-version", "7.0.4", "yes");
INSERT INTO `wp_options` VALUES("35292", "xts-header_728002-site-url", "795836ed13065f3682441c8b4e161708", "yes");
INSERT INTO `wp_options` VALUES("35293", "whb_header_728002", "a:4:{s:4:\"name\";s:24:\"هدر اصلی سایت\";s:2:\"id\";s:13:\"header_728002\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:90;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"stick\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}}", "yes");
INSERT INTO `wp_options` VALUES("155", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("740", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("171", "xts-theme_settings_default-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("172", "xts-theme_settings_default-version", "7.0.4", "yes");
INSERT INTO `wp_options` VALUES("173", "xts-theme_settings_default-site-url", "795836ed13065f3682441c8b4e161708", "yes");
INSERT INTO `wp_options` VALUES("174", "wd_has_translation_files", "yes", "yes");
INSERT INTO `wp_options` VALUES("188", "woodmart-update-time", "1683783221", "yes");
INSERT INTO `wp_options` VALUES("189", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"7.2.3\";s:7:\"version\";s:5:\"7.2.3\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1683783221;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:61:\"https://xtemos.com/licenses/api/files/get/woodmart.zip?token=\";}", "yes");
INSERT INTO `wp_options` VALUES("539", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1727690304;}", "yes");
INSERT INTO `wp_options` VALUES("966", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("70761", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.11\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/meharat\\/public_html\\/laptop-shop\\/20230614_d8b3d8a7db8cd8aad8a2d985d8a7d8_d38b7b71d654822f2717_20240929125508_archive.zip\",\n    \"packageHash\": \"d38b7b7-29125508\",\n    \"installerPath\": \"\\/home\\/meharat\\/public_html\\/laptop-shop\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/meharat\\/public_html\\/laptop-shop\\/dup-installer-bootlog__70ff3f7-29125508.txt\",\n    \"installerLog\": \"\\/home\\/meharat\\/public_html\\/laptop-shop\\/dup-installer\\/dup-installer-log__70ff3f7-29125508.txt\",\n    \"dupInstallerPath\": \"\\/home\\/meharat\\/public_html\\/laptop-shop\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/meharat\\/public_html\\/laptop-shop\\/dup-installer\\/original_files_d38b7b7-29125508\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"7.4.33\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 107134482,\n    \"siteNumFiles\": 17706,\n    \"siteDbSize\": 12643429,\n    \"siteDBNumTables\": 67,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1727615296\n}", "no");
INSERT INTO `wp_options` VALUES("567", "duplicator_version_plugin", "1.5.11", "yes");
INSERT INTO `wp_options` VALUES("572", "bodhi_svgs_settings", "a:5:{s:8:\"restrict\";a:1:{i:0;s:13:\"administrator\";}s:12:\"frontend_css\";s:2:\"on\";s:10:\"css_target\";s:0:\"\";s:22:\"sanitize_svg_front_end\";s:2:\"on\";s:24:\"sanitize_on_upload_roles\";a:2:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";}}", "yes");
INSERT INTO `wp_options` VALUES("196", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_options` VALUES("203", "_elementor_installed_time", "1652157978", "yes");
INSERT INTO `wp_options` VALUES("204", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:19:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:19:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:19:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:19:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:19:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:19:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:19:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:19:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:19:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:19:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:19:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:19:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:19:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:19:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:19:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:19:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:19:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:19:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:19:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:19:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:19:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:19:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:19:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:19:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:19:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:19:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:19:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:19:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:19:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:19:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:19:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:19:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:19:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:19:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:19:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:19:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:19:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:19:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:19:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:19:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:19:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:19:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:19:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:19:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:19:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:19:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:19:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:19:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:19:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:19:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:19:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:19:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:19:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:19:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:19:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:19:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:19:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:19:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:19:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:19:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:19:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:19:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:19:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:19:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:19:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:19:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:19:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:19:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:19:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:19:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:19:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:19:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:19:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:19:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:19:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:19:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:19:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:19:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:19:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:19:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:19:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:19:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:19:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:19:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:19:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:19:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:19:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:19:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:19:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:19:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:19:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:19:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:19:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:19:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:19:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:19:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:19:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:19:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:19:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:19:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:19:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:19:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:19:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:19:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:19:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:19:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:19:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:19:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:19:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:19:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:19:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:19:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:19:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:19:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:19:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:19:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:19:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:19:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:19:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:19:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:19:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:19:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:19:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:19:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:19:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:19:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:19:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:19:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:19:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:19:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:19:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:19:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:19:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:19:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:19:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:19:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:19:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:19:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:19:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:19:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:19:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:19:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:19:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:19:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:19:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:19:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:19:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:19:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:19:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:19:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:19:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:19:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:19:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:19:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:19:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:19:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:19:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:19:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:19:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:19:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:19:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:19:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:19:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:19:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:19:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:19:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:19:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:19:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:19:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:19:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:19:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:19:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:19:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:19:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:19:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:19:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:19:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:19:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:19:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:19:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:19:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:19:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:19:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:19:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:19:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:19:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:19:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:19:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:19:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:19:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:19:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:19:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:19:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:19:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:19:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:19:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:19:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:19:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:19:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:19:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:19:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:19:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:19:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:19:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:19:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:19:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:19:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:19:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:19:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:19:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:19:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:19:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:19:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:19:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:19:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:19:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:19:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:19:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:19:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:19:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:19:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:19:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:19:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:19:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:19:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:19:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:19:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:19:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:19:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:19:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:19:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:19:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:19:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:19:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:19:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:15204436