<?php
class Elementor_Uwacmz_Widget extends \Elementor\Widget_Base {
    

	public function get_name() {
		return 'uwacmz-widget';
	}

	public function get_title() {
		return esc_html__( 'Chat & Support Widget', 'uwacmz' );
	}

	public function get_icon() {
        return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'mzwp-elements' ];
	}


	protected function register_controls() {

		// Content Tab Start

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Widget Setting', 'uwacmz' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


        $this->add_control(
         'uwacmz_layout_type',
         [
            'label' => __( 'Layout', 'uwacmz' ),
            'type' => Elementor\Controls_Manager::SELECT,
            'default' => 'widget-layout-multi-users',
            'options' => [
               'widget-layout-multi-users'  => __( 'Multi Users', 'uwacmz' ),
               'widget-layout-pro' => __( 'Professional Widget', 'uwacmz' ),
               'widget-layout-multi-whatsapp' => __( 'Multi Whatsapp', 'uwacmz' ),
               'widget-layout-modern-whatsapp' => __( 'Modern Single Whatsapp', 'uwacmz' ),
               'widget-layout-single-button' => __( 'Single Button', 'uwacmz' ),

            ],
         ]
      );
      
      
        $this->add_control(
			'uwacmz_widget_icon',
			[
				'label' => esc_html__( 'Icon', 'pael' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle',
					'library' => 'fa-solid',
				],
			]
		);  
        
        $this->add_control(
            'uwacmz_widget_btn_lable',
            [
              'label' => esc_html__( 'Whatsapp Button Text', 'uwacmz' ),
              'type'          => Elementor\Controls_Manager::TEXT,
              'default'   => ''
              ]
        );


        $this->add_control(
            'uwacmz_widget_header_title',
            [
              'label' => esc_html__( 'Widget Header Text', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        $this->add_control(
            'uwacmz_widget_header_description',
            [
                'label' => esc_html__( 'Widget Header Description', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        
        $this->add_control(
            'uwacmz_widget_reply_time_txt',
            [
              'label' => esc_html__( 'Response time text', 'uwacmz' ),
              'type'          => Elementor\Controls_Manager::TEXT,
              'default'   => ''
            ]
        );
        
        
        $this->add_control(
            'uwacmz_widget_tlg',
            [
              'label' => esc_html__( 'Telegram UserName', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );        
        

        $this->add_control(
            'uwacmz_widget_insta',
            [
              'label' => esc_html__( 'Instagram UserName', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        $this->add_control(
            'uwacmz_widget_theme_color',
            [
              'label' => esc_html__( 'Widget Color', 'uwacmz' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .icon-single-btn-multi' => 'background: {{VALUE}} !important;',
                    '{{WRAPPER}} .modal-content-top-multi' => 'background: {{VALUE}} !important;',

                ],
            ]
        );
        
        
        
        $this->add_control(
			'show_info_data_form',
			[
				'label' => esc_html__( 'Display the contact information form', 'uwacmz' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'uwacmz' ),
				'label_off' => esc_html__( 'No', 'uwacmz' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		
		
		$this->end_controls_section();

		// Content Tab End
		
		$this->start_controls_section(
			'section_animate',
			[
				'label' => esc_html__( 'Position and Animation', 'uwacmz' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		


        $this->add_control(
         'uwacmz_layout_position',
         [
            'label' => __( 'Widget Position', 'uwacmz' ),
            'type' => Elementor\Controls_Manager::SELECT,
            'default' => 'right:20px; flex-direction:row',
            'options' => [
               'right:20px; flex-direction:row'  => __( 'Right', 'uwacmz' ),
               'left:20px; flex-direction:row-reverse' => __( 'Left', 'uwacmz' ),

            ],
         ]
      );
      
      
        $this->add_control(
            'uwac_mz_widget_mobile_position',
            [
              'label' => esc_html__( 'Mobile Position', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        $this->add_control(
			'uwac_mz_widget_open',
			[
				'label' => esc_html__( 'Automatic widget opening', 'uwacmz' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'uwacmz' ),
				'label_off' => esc_html__( 'No', 'uwacmz' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
        $this->add_control(
            'uwac_mz_widget_open_time',
            [
              'label' => esc_html__( 'Delay', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        
        $this->add_control(
         'uwac_mz_widget_animation',
         [
            'label' => __( 'Widget Animation', 'uwacmz' ),
            'type' => Elementor\Controls_Manager::SELECT,
            'default' => 'None',
            'options' => [
               'None'  => __( 'None', 'uwacmz' ),
               'Shake'  => __( 'Shake', 'uwacmz' ),
               'Flash'  => __( 'Flash', 'uwacmz' ),
               'Swing'  => __( 'Swing', 'uwacmz' ),
               '360'  => __( '360 deg', 'uwacmz' ),

            ],
         ]
      );
      
      
      
        $this->add_control(
         'uwac_mz_widget_duration',
         [
            'label' => __( 'Duration', 'uwacmz' ),
            'type' => Elementor\Controls_Manager::SELECT,
            'default' => '200',
            'options' => [
               '200'  => __( '200 Millisecond', 'uwacmz' ),
               '400'  => __( '400 Millisecond', 'uwacmz' ),
               '600'  => __( '600 Millisecond', 'uwacmz' ),
               '800'  => __( '800 Millisecond', 'uwacmz' ),
               '1000'  => __( '1 second', 'uwacmz' ),
               '1500'  => __( '1.5 second', 'uwacmz' ),
               '2000'  => __( '2 second', 'uwacmz' ),
               '2500'  => __( '2.5 second', 'uwacmz' ),
               '3000'  => __( '3 second', 'uwacmz' ),
            ],
         ]
      );
        
        
        
        $this->add_control(
         'uwac_mz_widget_iterations',
         [
            'label' => __( 'Repeat', 'uwacmz' ),
            'type' => Elementor\Controls_Manager::SELECT,
            'default' => '15',
            'options' => [
               '1'  => __( '1', 'uwacmz' ),
               '2'  => __( '2', 'uwacmz' ),
               '3'  => __( '3', 'uwacmz' ),
               '4'  => __( '4', 'uwacmz' ),
               '5'  => __( '5', 'uwacmz' ),
               '6'  => __( '6', 'uwacmz' ),
               '7'  => __( '7', 'uwacmz' ),
               '8'  => __( '8', 'uwacmz' ),
               '9'  => __( '9', 'uwacmz' ),
               '10'  => __( '10', 'uwacmz' ),
               '15'  => __( '15', 'uwacmz' ),
               '20'  => __( '20', 'uwacmz' ),
            ],
         ]
      );
      



        $this->add_control(
         'uwac_mz_widget_delay',
         [
            'label' => __( 'Delay', 'uwacmz' ),
            'type' => Elementor\Controls_Manager::SELECT,
            'default' => '200',
            'options' => [
               '200'  => __( '200 Millisecond', 'uwacmz' ),
               '400'  => __( '400 Millisecond', 'uwacmz' ),
               '600'  => __( '600 Millisecond', 'uwacmz' ),
               '800'  => __( '800 Millisecond', 'uwacmz' ),
               '1000'  => __( '1 second', 'uwacmz' ),
               '2000'  => __( '2 second', 'uwacmz' ),
               '3000'  => __( '3 second', 'uwacmz' ),
               '4000'  => __( '4 second', 'uwacmz' ),
               '5000'  => __( '5 second', 'uwacmz' ),
               '6000'  => __( '6 second', 'uwacmz' ),
               '7000'  => __( '7 second', 'uwacmz' ),
               '8000'  => __( '8 second', 'uwacmz' ),
               '9000'  => __( '9 second', 'uwacmz' ),
               '10000'  => __( '10 second', 'uwacmz' ),
            ],
         ]
      );

      
		$this->end_controls_section();

		// Content Tab End
		
		
		$this->start_controls_section(
			'section_account',
			[
				'label' => esc_html__( 'Account Setting', 'uwacmz' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
        $repeater = new \Elementor\Repeater();



        $repeater->add_control(
         'uwacmz_account_type_desktop',
         [
            'label' => __( 'Account Type for desktop', 'uwacmz' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
               'https://web.whatsapp.com/send?phone=+98'  => __( 'Whatsapp', 'uwacmz' ),
               'https://tlgrm.in/'  => __( 'Telegram', 'uwacmz' ),
               'https://instagram.com/'  => __( 'Instagram ', 'uwacmz' ),
               'tel:'  => __( 'Phone', 'uwacmz' ),
               'https://web.igap.net/app?q=@'  => __( 'Igap', 'uwacmz' ),
               'https://web.splus.ir/#/im?p=@'  => __( 'Soroush ', 'uwacmz' ),
               'https://web.gap.im/#/im?p=@'  => __( 'Gap', 'uwacmz' ),
               'https://web.eitaa.com/#/im?p='  => __( 'Eitaa', 'uwacmz' ),
               'sms:'  => __( 'SMS ', 'uwacmz' ),
            ],
         ]
      );
      
        $repeater->add_control(
         'uwacmz_account_type_mobile',
         [
            'label' => __( 'Account Type for mobile', 'uwacmz' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '',
            'options' => [
               'whatsapp://send?phone='  => __( 'Whatsapp', 'uwacmz' ),
               'https://tlgrm.in/'  => __( 'Telegram', 'uwacmz' ),
               'https://instagram.com/'  => __( 'Instagram ', 'uwacmz' ),
               'tel:'  => __( 'Phone', 'uwacmz' ),
               'iGap://resolve?domain='  => __( 'Igap', 'uwacmz' ),
               'soroush://lookup?key='  => __( 'Soroush ', 'uwacmz' ),
               'gap://@'  => __( 'Gap', 'uwacmz' ),
               'et://resolve?domain='  => __( 'Eitaa', 'uwacmz' ),
               'sms:'  => __( 'SMS ', 'uwacmz' ),
            ],
         ]
      );
      
        $repeater->add_control(
            'uwacmz_account_username',
            [
                'label' => esc_html__( 'Account UserName', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
    
        $repeater->add_control(
            'uwacmz_account_pic',
            [
                'label' => esc_html__( 'User Picture Url', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        

        $repeater->add_control(
            'uwacmz_account_department',
            [
                'label' => esc_html__( 'Department', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        $repeater->add_control(
            'uwacmz_widget_account_pm',
            [
                'label' => esc_html__( 'Account Description', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        
        $repeater->add_control(
            'uwacmz_widget_account_number',
            [
              'label' => esc_html__( 'Account number', 'uwacmz' ),
              'type'          => Elementor\Controls_Manager::TEXT,
              'default'   => ''
            ]
        );
        
        
        $repeater->add_control(
            'uwacmz_account_theme_color',
            [
              'label' => esc_html__( 'Account Color', 'uwacmz' ),
              'type' => Elementor\Controls_Manager::COLOR,

            ]
        );  
        
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Tabs', 'uwacmz' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'placeholder' => esc_html__( 'Enter your account tabs here', 'uwacmz' ),
                'fields' => $repeater->get_controls(),
            ]
        );
        
        
        

		$this->end_controls_section();

		// Content Tab End




		$this->start_controls_section(
			'section_faq',
			[
				'label' => esc_html__( 'FAQ Setting', 'uwacmz' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		
		
		
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'uwacmz_faq_title',
            [
                'label' => esc_html__( 'Enter FAQ Title', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
    
        $repeater->add_control(
            'uwacmz_faq_subtitle',
            [
                'label' => esc_html__( 'Enter FAQ SubTitle', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        

        $repeater->add_control(
            'uwacmz_faq_url',
            [
                'label' => esc_html__( 'Enter FAQ Url', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        $repeater->add_control(
            'uwacmz_faq_description',
            [
                'label' => esc_html__( 'Enter FAQ Description', 'uwacmz' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'default'   => ''
            ]
        );
        
        
        
        $this->add_control(
            'tabs_faqs',
            [
                'label' => esc_html__( 'FAQ Tabs', 'uwacmz' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'placeholder' => esc_html__( 'Enter your FAQ tabs here', 'uwacmz' ),
                'fields' => $repeater->get_controls(),
            ]
        );
		
		
		


		$this->end_controls_section();

		// Content Tab End
		
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		 extract( $settings );
		 
		include 'layout/'.$uwacmz_layout_type.'.php';


	}
}

Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Elementor_Uwacmz_Widget );