<?php defined('ABSPATH') or die('This script cannot be accessed directly.');
/** Function and condition */
?>
<header class="uwac-header">
    <h1 class="uwac-header-text">
        <i class="fal fa-file-user"></i> <?php _e('Manage accounts','uwacmz');?>
    </h1>
</header>
<div class="check-nf-status">
    <div class="notice-box-uwac">
        <i class="cli cli-layers"></i>
        <p class="notice-admin-uwac">
            <i class="fal fa-file-user"></i> <?php _e('In this section, you can manage (delete and edit) created accounts','uwacmz');?>
        </p>
    </div>
    <br>
    <div style="height:max-content; overflow: auto">
        <table class="wp-list-table widefat fixed striped table-view-list users">
            <thead class="style">
                <tr>
                    <th> <?php _e('ID','uwacmz');?> </th>
                    <th> <?php _e('Status','uwacmz');?> </th>
                    <th> <?php _e('Account Name','uwacmz');?> </th>
                    <th> <?php _e('Whatsapp Number','uwacmz');?> </th>
                    <th> <?php _e('Account Style','uwacmz');?> </th>
                    <th> <?php _e('ShortCode','uwacmz');?> </th>
                    <th> <?php _e('Edit / Delete','uwacmz');?> </th>
                </tr>
            </thead>
            <tbody> <?php  

            global $wpdb;
            $uwacmz_user_account_table = $wpdb->prefix . 'uwacmz_user_account';
            $account_datas = $wpdb->get_results( "SELECT * FROM $uwacmz_user_account_table" );

            foreach($account_datas as $account_data): 
                    $ac_active=$account_data->uwacmz_ac_active;
                    $ac_style=$account_data->uwacmz_ac_theme_style;
                if ($ac_active == 'active') {
                $ac_active_view = __('active', 'uwacmz');;
                }
                
                if ($ac_active == 'deactive') {
                $ac_active_view = __('deactive', 'uwacmz');;
                }
                
                if ($ac_style == 'Default') {
                $ac_style_view = __('Default', 'uwacmz');;
                }
                
                if ($ac_style == 'Modern') {
                $ac_style_view = __('Modern Ui', 'uwacmz');;
                }
                
                   ?>
                <tr>
                    <td> <?php echo $account_data->ID  ?> </td>
                    <td> <?php echo $ac_active_view  ?> </td>
                    <td> <?php echo $account_data->uwacmz_ac_user_name  ?> </td>
                    <td> <?php echo $account_data->uwacmz_ac_whatsapp_num  ?> </td>
                    <td> <?php echo $ac_style_view  ?> </td>
                    <td> [uwacmz_account id=" <?php echo $account_data->ID ?>"] </td>
                    <td>
                        <div class="action-row-uwacmz">
                            <a href="<?php echo add_query_arg(['action' => 'edit' , 'item' => $account_data->ID]);  ?>">
                                <div class="update-uwac-row-item">
                                    <i class="fal fa-file-edit"></i> <?php _e('Edit','uwacmz');?>
                                </div>
                            </a>
                            <a href="<?php echo add_query_arg(['action' => 'delete' , 'item' => $account_data->ID]);  ?>">
                                <div class="remove-uwac-row-item">
                                    <i class="fal fa-trash-alt"></i> <?php _e('Delete','uwacmz');?>
                                </div>
                            </a>
                        </div>
                    </td>
                </tr> <?php endforeach ?> </tbody>
        </table>
    </div>