{# twig vars #}{##}
{% set urlImage2 = ucfunc("get_woo_image2",item.products.id,item.products.image_size) %}

{% set image1Elem %}
  <div class="uc_product_image" >        
    {% if item.products.image is empty %}
      <img src="{{default_image}}" {{default_image_attributes|raw}}>
    {% else %}
      <img src="{{item.products.image}}" {{item.products.image_attributes|raw}}>
    {% endif %}            
  </div>
{% endset %}{# end image1Elem #}{##}

{% set image2Elem %}
  {% if swap_image_on_hover == "true" %}
    {% if urlImage2 is not empty %}
      <div class="uc_product_image uc_product_image--second">
        <img src="{{urlImage2}}" >
      </div>   
    {% endif %}
  {% endif %}
{% endset %}{# end image1Elem #}{##}

{% set custom_field_value = ucfunc("get_post_custom_field", item.products.id, custom_field_name) %} 

{% set customFeildLabelElem %}
  {% if custom_field_value is not empty %}
    <div class="ue_woocommerce_product_label ue_woocommerce_product_label-custom-field">{{custom_field_value|raw}}</div>
  {% endif %}
{% endset %}

{% set categoriesElem %}
  {% if show_all_categories == "false" %}
    <div class="ue_cat_name uc-direction"><a href="{{item.products.category_link}}">{{item.products.category_name}}</a></div>
  {% else %}
    <div class="ue_cat_name uc-direction">
      {% for cat in item.products.categories %}
        <a href="{{cat.link}}">{{cat.name}}</a>
      {% endfor %}
    </div>
  {% endif %}
{% endset %}

{% set ratingElem %}
  <div class="product-rating">
    {% for staritem in item.products.woo_rating_stars %}                
      <i class="{{staritem.class}}"></i>
    {% endfor %}
  </div>
{% endset %}

{% set qtyIncrementBtnElem %}
  <div class="uc_carousel-count-buttons">
    <button class="uc_carousel-count-buttons__minus" disabled>{{quantity_minus_html|raw}}</button>
    <input type="number" class="uc_carousel-count-buttons__number" value="1">
    <button class="uc_carousel-count-buttons__plus" >{{quantity_plus_html|raw}}</button>
  </div>
{% endset %}

{% set productBtnElem %}
  <a class="uc_btn uc_more_btn uc-direction {{item.products.dynamic_popup_link_class|raw}}" {{item.products.dynamic_popup_link_attributes|raw}} target="{{open_product_in_new_tab}}">{{product_button_icon_html|raw}}{{product_button_text|raw}}</a> 
{% endset %}

{% set loaderElem %}
  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20" viewBox="0 0 32 32">
    <g stroke-width="1" transform="translate(0.5, 0.5)">
      <g class="nc-loop-bars-rotate-32-icon-o" stroke-width="1">
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="31" x2="26" y1="16" y2="16" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="26.607" x2="23.071" y1="26.607" y2="23.071" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="16" x2="16" y1="31" y2="26" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="5.393" x2="8.929" y1="26.607" y2="23.071" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="1" x2="6" y1="16" y2="16" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="5.393" x2="8.929" y1="5.393" y2="8.929" opacity="0.4" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="16" x2="16" y1="1" y2="6" opacity="0.6" stroke-linejoin="miter"></line>
        <line fill="none" stroke="#fff" stroke-linecap="square" stroke-width="1" x1="26.607" x2="23.071" y1="5.393" y2="8.929" opacity="0.8" stroke-linejoin="miter"></line>
      </g>
      <style stroke-width="1">
        .nc-loop-bars-rotate-32-icon-o{
          --animation-duration:0.8s;
          transform-origin:16px 16px;
          animation:nc-loop-bars-rotate-anim var(--animation-duration) infinite steps(8,jump-start)
        }
        @keyframes nc-loop-bars-rotate-anim{
          0%{
            transform:rotate(0)
          }
          100%{
            transform:rotate(360deg)
          }
        }
      </style>
    </g>
</svg>
{% endset %}{# end loaderElem #}{##}

{% set buttonAddCartTextCombined %}
  {% if item.products.woo_type == "variable" %}
    {{select_options_button_text}}        	
  {% else %}
    {{add_to_cart_button_text}}
  {% endif %}  
{% endset %}

{% set addToCartBtnElem %}
  {% if item.products.woo_type == "variable" %}
    <a class="uc-button-addcart ue-variable-btn" href="{{item.products.link}}" {{item.products.woo_addcart_ajax_attributes|raw}}>{{add_to_cart_button_icon_html|raw}}{{ buttonAddCartTextCombined|raw}}</a>
  {% else %}
    <button {{item.products.woo_addcart_ajax_attributes|raw}}>
      <div class="ue-inner-btn-wrapper">
        <span>{{add_to_cart_button_icon_html|raw}}</span>
        <span>{{ buttonAddCartTextCombined|raw}}</span>                     
        <span class="add-to-cart__loader" style="display:none">{{loaderElem}}</span> 
      </div>{# end ue-inner-btn-wrapper #}{##}
    </button>
  {% endif %}
{% endset %}

{% set custom_field_link = ucfunc("get_post_custom_field", item.post_list.id, additional_button_link_custom_field) %}

{% set additionalBtnElem %}
  <a class="uc_more_btn-custom-field" href="{{custom_field_link}}" target="{{additional_button_open_type}}">
    <div class="uc_btn_inner"><div class="uc_btn_txt">{{additional_button_text|raw}}</div></div>
  </a>
{% endset %}

{# end twig vars #}{##}

<div class="uc_image_carousel_container_holder ue-woo-item ue-item" id="{{item.item_id}}">
  
  {% if before_shop_loop_item == "true" %}{{do_action("woocommerce_before_shop_loop_item")}}{% endif %} 
      
  <div class="uc_image_carousel_placeholder">
    
    {% if enable_third_party_integrations == "true" %}{{do_action('ue_woocommerce_product_integrations', item.products.id)}}{% endif %}
    
    <a href="{{item.products.link}}">      
      {{image1Elem}}      
      {{image2Elem}}      
    </a>
    
    {% if show_labels == "true" %}
      {% if item.products.woo_stock_status == "outofstock" %}
        <div class="ue_woocommerce_product_label ue_woocommerce_product_grid_out_of_stock_label">{{out_of_stock_text|raw}}</div>
      {% else %}
        {% if item.products.woo_sale_price is not empty %}
          <div class="ue_woocommerce_product_label ue_woocommerce_product_carousel_sale_label uc-direction">
            
            {% if sale_label_position == "before" %}{{sale_label|raw}}{% endif %}
            {% if show_sale_precent_in_label == "true" %}{{item.products.woo_discount_percent}}%{% endif %}	   
            {% if sale_label_position == "after" %}{{sale_label|raw}}{% endif %} 
            
          </div>{# end ue_woocommerce_product_label #}{##}
        {% endif %}	
      {% endif %}	
    {% endif %}
  </div>{# end uc_image_carousel_placeholder #}{##}

  <div class="uc_image_carousel_content" >
    <div class="uc_image_carousel_content_inside">
      
      {% if show_label_from_custom_field_ == "true" and custom_field_label_position_static == "before" %}{{customFeildLabelElem}}{% endif %}        
      {% if show_category == "true" %}{{categoriesElem}}{% endif %}      
      {% if before_shop_loop_item_title == "true" %}{{do_action("woocommerce_before_shop_loop_item_title")}}{% endif %}      
      {% if show_title == "true" %}<div class="uc_post_title uc-direction"><a href="{{item.products.link}}">{{item.products.title|raw}}</a></div>{% endif %}      
      {% if after_shop_loop_item_title == "true" %}{{do_action("woocommerce_after_shop_loop_item_title")}}{% endif %}      
      {% if show_rating == "true" %}{{ratingElem}}{% endif %}      
      {% if show_intro == "true" %}<div class="uc_post_intro uc-direction">{{item.products.intro_full|truncate(intro_characters, false, "...")}}</div>{% endif %}

      <div class="uc_prices">

        {% if show_regular_price == "true" %}{# if show_regular_price is true (not sale) #}{##}
          <div class="uc_regular_price {% if item.products.woo_sale_price is empty %}uc_regular_price--single{% endif %}">

            {% if item.products.woo_type == "variable" %}{# if variable product #}{##}

              {% if item.products.woo_regular_price_from == item.products.woo_regular_price_to %}{# if equal "from" and "to" price #}{##}

                {% if replace_0_price_by_text == "true" and item.products.woo_regular_price_from != 0 %}{# if "from" price is not 0, show "from" price #}{##}             
                  <span class="uc_sale_currency">{{item.products.woo_regular_price_from|wc_price|raw}}{{text_after_prices|raw}}</span>
                {% elseif replace_0_price_by_text == "true" and item.products.woo_regular_price == 0 %}{# if "from" price is 0 show replace_0_price_text #}{##}              
                  {{replace_0_price_text|raw}}
                {% endif %}

                {% if replace_0_price_by_text == "false" %}{# display "from" price if replace_0_price_by_text false #}{##}              
                  <span class="uc_sale_currency">{{item.products.woo_regular_price_from|wc_price|raw}}{{text_after_prices|raw}}</span>         
                {% endif %}

              {% else %}{# if not equal "from" and "to" price (price is always not empty in this case) #}{##}        

                {% if show_only_lowest_variable_product_price == "true" %}{# lowest variable price can be only in cases when "from" and "to" price are not equal #}{##}   
                  <span class="uc_sale_currency">{{before_lowest_price_text|raw}}{{item.products.woo_regular_price_from|wc_price|raw}}{{text_after_prices|raw}}</span>
                {% else %}{# if show lowest price is false, then display "from" and "to" price #}{##}  
                  <span class="uc_sale_currency">{{item.products.woo_regular_price_from|wc_price|raw}}{{text_after_prices|raw}}</span> - <span class="uc_sale_currency">{{item.products.woo_regular_price_to|wc_price|raw}}{{text_after_prices|raw}}</span>
                {% endif %}

              {% endif %}{# end if equal "from" and "to" price #}{##}

            {% else %}{# if not variable product #}{##}

              {% if replace_0_price_by_text == "true" and item.products.woo_regular_price != "" and item.products.woo_regular_price != 0 %}{# if replace 0 price is true and price is not empty or equal to 0, show regular price #}{##}            
                {{item.products.woo_regular_price|wc_price|raw}}{{text_after_prices|raw}}         
              {% elseif replace_0_price_by_text == "true" and item.products.woo_regular_price == "" or replace_0_price_by_text == "true" and item.products.woo_regular_price == 0 %}{# if replace 0 price is true and price is empty show replace_0_price_text #}{##}            
                {{replace_0_price_text|raw}}              
              {% endif %}

              {% if replace_0_price_by_text == "false" %}{# if replace 0 price is false show, regular price #}{##}               
                {{item.products.woo_regular_price|wc_price|raw}}{{text_after_prices|raw}}          
              {% endif %}

            {% endif %}{# end if variable product #}{##}              
          </div>{# end uc_regular_price #}{##}         	
        {% endif %}{# end show_regular_price #}{##}

        {% if show_sale_price == "true" %}{# if show_sale_price is true (not regular) #}{##}
          <div class="uc_price">

            {% if item.products.woo_type == "variable" %}{# if product is variable (not simple) #}{##}
              {% if item.products.woo_sale_price_from == item.products.woo_sale_price_to and item.products.woo_sale_price_from != "" %}{# if "from" price is equal to "to" price and not empty, show "from" price #}{##}                      
                  {{item.products.woo_sale_price_from|wc_price|raw}}{{text_after_prices|raw}}  
              {% elseif item.products.woo_sale_price_from != item.products.woo_sale_price_to and item.products.woo_sale_price_from != "" %}{# if "from" price is not equal to "to" price and not empty #}{##}

                {% if show_only_lowest_variable_product_price == "true" %}{# if show only "from" sale price is true and it's not empty, show "from" sale price #}{##}
                  {{before_lowest_price_text|raw}}{{item.products.woo_sale_price_from|wc_price|raw}}{{text_after_prices|raw}}
                {% elseif show_only_lowest_variable_product_price == "false" %}{# if show only "from" sale price is false and it's not empty, show "from"-"to" sale price #}{##}
                  {{item.products.woo_sale_price_from|wc_price|raw}}{{text_after_prices|raw}} - {{item.products.woo_sale_price_to|wc_price|raw}}{{text_after_prices|raw}}           
                {% endif %}

              {% endif %}{# end if "from" price is equal to "to" price #}{##}

            {% else %}{# if product is not variable (simple) #}{##}            
              {% if item.products.woo_sale_price != "" %}{# if sale price is not empty, show it  #}{##}
                {{item.products.woo_sale_price|wc_price|raw}}{{text_after_prices|raw}} 
              {% endif %}
            {% endif %}{# end if product is variable #}{##}

          </div>{# end uc_price #}{##}
        {% endif %}{# end if show_sale_price is true (not regular) #}{##}      
      </div>{# end uc_prices #}{##}

      {% if show_label_from_custom_field_ == "true" and custom_field_label_position_static == "after" %}{{customFeildLabelElem}}{% endif %}    

      <div class="uc_post_grid_style_one_button uc_buttons">

        {% if show_quantity_increment_buttons == "true" and item.products.woo_type == "simple" %}{{qtyIncrementBtnElem}}{% endif %}      
        {% if show_product_button == "true" %}{{productBtnElem}}{% endif %}
        {% if show_add_to_cart_button == "true" %}{{addToCartBtnElem}}{% endif %}
        {% if show_additional_button == "true" %}{{additionalBtnElem}}{% endif %}

      </div>{# end uc_post_grid_style_one_button #}{##}
    </div>{# end uc_image_carousel_content_inside #}{##}

    {% if enable_third_party_integrations == "true" %}{{do_action('ue_woocommerce_product_integrations_bottom', item.products.id)}}{% endif %}
    
  </div>{# end uc_image_carousel_content #}{##}
  
  {% if after_shop_loop_item == "true" %}{{do_action("woocommerce_after_shop_loop_item")}}{% endif %}
</div>{# end uc_image_carousel_container_holder #}{##}